/*
 * Decompiled with CFR 0.152.
 */
package migrami.core.interfaces;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import migrami.core.infra.ResourceResolver;
import migrami.core.infra.ResourceStream;
import migrami.core.interfaces.MigramiCategory;
import migrami.core.interfaces.MigramiChecksumFactory;
import migrami.core.interfaces.MigramiScript;
import migrami.core.interfaces.MigramiScriptLoader;
import migrami.core.interfaces.ResourceName;

class ClassPathScriptLoader
implements MigramiScriptLoader {
    private final String path;

    public ClassPathScriptLoader() {
        this.path = "migration";
    }

    public Iterable<MigramiScript> load(MigramiCategory category, MigramiChecksumFactory checksumFactory) {
        try {
            Path path = Paths.get(this.path, category.path());
            Enumeration<URL> resources = this.getClassLoader().getResources(path.toString());
            ArrayList<MigramiScript> scripts = new ArrayList<MigramiScript>();
            if (resources.hasMoreElements()) {
                URL location = resources.nextElement();
                ResourceResolver.resolver(location).resolve().forEach(resourceName -> {
                    String content = ResourceStream.read(path, resourceName);
                    MigramiScript script = this.toMigramiScript(category, checksumFactory, (ResourceName)resourceName, content);
                    scripts.add(script);
                });
            }
            return scripts;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    private MigramiScript toMigramiScript(MigramiCategory category, MigramiChecksumFactory checksumFactory, ResourceName resourceName, String content) {
        return MigramiScript.create((MigramiCategory)category, (MigramiChecksumFactory)checksumFactory, (ResourceName)resourceName, (String)content);
    }

    public ClassPathScriptLoader(String path) {
        this.path = path;
    }
}

