/*
 * Decompiled with CFR 0.152.
 */
package migrami.core.interfaces;

import java.security.MessageDigest;
import migrami.core.interfaces.MigramiChecksum;

class MD5Checksum
implements MigramiChecksum {
    private final String value;

    static MD5Checksum create(String content) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(content.getBytes());
            StringBuilder result = new StringBuilder();
            for (byte b : md.digest()) {
                result.append(String.format("%02x", b));
            }
            return new MD5Checksum(result.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    MD5Checksum(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MD5Checksum)) {
            return false;
        }
        MD5Checksum other = (MD5Checksum)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MD5Checksum;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

