/*
 * Decompiled with CFR 0.152.
 */
package toolbox.data.interfaces;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import toolbox.data.interfaces.DataSet;

public class SQLExecutor {
    private final DataSource dataSource;
    private Logger logger = LoggerFactory.getLogger(SQLExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String statement, Consumer<PreparedStatement> consumer) {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.dataSource.getConnection();
            ps = connection.prepareStatement(statement);
            consumer.accept(ps);
            boolean bl = ps.execute();
            this.close(ps);
            this.close(connection);
            return bl;
        }
        catch (SQLException e) {
            try {
                boolean bl = this.report(e);
                this.close(ps);
                this.close(connection);
                return bl;
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String statement) {
        Connection connection = null;
        Statement st = null;
        try {
            connection = this.dataSource.getConnection();
            st = connection.createStatement();
            boolean bl = st.execute(statement);
            this.close(st);
            this.close(connection);
            return bl;
        }
        catch (SQLException e) {
            try {
                boolean bl = this.report(e);
                this.close(st);
                this.close(connection);
                return bl;
            }
            catch (Throwable throwable) {
                this.close(st);
                this.close(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet query(String statement) {
        Connection connection = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            connection = this.dataSource.getConnection();
            st = connection.createStatement();
            rs = st.executeQuery(statement);
            DataSet dataSet = DataSet.create(rs);
            this.close(rs);
            this.close(st);
            this.close(connection);
            return dataSet;
        }
        catch (SQLException e) {
            try {
                this.report(e);
                DataSet dataSet = DataSet.empty();
                this.close(rs);
                this.close(st);
                this.close(connection);
                return dataSet;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(st);
                this.close(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet query(String statement, Object ... values) {
        Connection connection = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            connection = this.dataSource.getConnection();
            st = connection.prepareStatement(statement);
            int index = 1;
            for (Object value : values) {
                st.setObject(index++, value);
            }
            rs = st.executeQuery();
            DataSet dataSet = DataSet.create(rs);
            this.close(rs);
            this.close(st);
            this.close(connection);
            return dataSet;
        }
        catch (SQLException e) {
            this.report(e);
            DataSet dataSet = DataSet.empty();
            return dataSet;
        }
        finally {
            this.close(rs);
            this.close(st);
            this.close(connection);
        }
    }

    private boolean report(Exception e) {
        this.logger.warn("Error in sql execution", (Throwable)e);
        return false;
    }

    private void close(AutoCloseable connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("Error on closing resource", (Throwable)e);
        }
    }

    private SQLExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static SQLExecutor create(DataSource dataSource) {
        return new SQLExecutor(dataSource);
    }
}

