/*
 * Decompiled with CFR 0.152.
 */
package triady.generator.jsonschema.interfaces;

import compozitor.processor.core.interfaces.TypeModel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import triady.generator.core.interfaces.Id;
import triady.generator.core.interfaces.Resource;

public class JsonSchemaSpecification
extends Resource {
    private static final Path PATH = Paths.get("src/data/", "json-schemas/");
    protected static final String VALUE = "value";
    private final List<SchemaProperty> properties = new ArrayList<SchemaProperty>();

    public JsonSchemaSpecification(Id id) {
        super(PATH.toString(), id);
    }

    public static JsonSchemaSpecification create(TypeModel typeModel) {
        Id id = Id.create(typeModel.getQualifiedName());
        return new JsonSchemaSpecification(id).put(VALUE, typeModel.getQualifiedName());
    }

    protected JsonSchemaSpecification put(String key, String value) {
        this.properties.add(new SchemaProperty(key, value));
        return this;
    }

    public Path getEndpoint() {
        String endpoint = this.getPath().toString().replace("src", "");
        return Paths.get(endpoint, new String[0]);
    }

    List<SchemaProperty> getProperties() {
        return this.properties;
    }

    public class SchemaProperty {
        private final String key;
        private final String value;

        public SchemaProperty(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

