/*
 * Decompiled with CFR 0.152.
 */
package triady.generator.jsonschema.interfaces;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import java.util.HashMap;
import java.util.List;
import triady.generator.core.interfaces.Json;
import triady.generator.jsonschema.interfaces.JsonSchemaSpecification;

public class JsonSchema {
    private static final ObjectMapper json = new ObjectMapper();

    public String generate(JsonSchemaSpecification schemaSpecification) {
        List<JsonSchemaSpecification.SchemaProperty> properties = schemaSpecification.getProperties();
        if (properties.size() == 1) {
            JsonSchemaSpecification.SchemaProperty property2 = properties.get(0);
            return this.toString(property2.getValue());
        }
        HashMap schemaMap = new HashMap();
        properties.forEach(property -> schemaMap.put(property.getKey(), this.toJsonSchema(property.getValue())));
        return Json.toString(schemaMap);
    }

    private String toString(String targetClassName) {
        return Json.toString(this.toJsonSchema(targetClassName));
    }

    private com.fasterxml.jackson.module.jsonSchema.JsonSchema toJsonSchema(String targetClassName) {
        try {
            Class<?> targetClass = Class.forName(targetClassName);
            JsonSchemaGenerator schemaGenerator = new JsonSchemaGenerator(json);
            return schemaGenerator.generateSchema(targetClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        json.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
    }
}

