/*
 * Decompiled with CFR 0.152.
 */
package triady.generator.endpoint.interfaces;

import java.nio.file.Path;
import java.nio.file.Paths;
import triady.generator.core.interfaces.Id;
import triady.generator.core.interfaces.Resource;

public class EndpointGraphQLSchema
extends Resource {
    private static final Path PATH = Paths.get("src/data/", "graphql-schemas/");
    private static final Empty EMPTY = new Empty();
    private final Path path;

    protected EndpointGraphQLSchema(Id id, Path path) {
        super(PATH.toString(), id);
        this.path = path;
    }

    public static EndpointGraphQLSchema create() {
        return EMPTY;
    }

    public static EndpointGraphQLSchema create(Path pathToFile) {
        return new EndpointGraphQLSchema(Id.create(pathToFile), pathToFile);
    }

    public Path getEndpoint() {
        String endpoint = this.getPath().toString().replace("src", "");
        return Paths.get(endpoint, new String[0]);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    static class Empty
    extends EndpointGraphQLSchema {
        public Empty() {
            super(Id.create(new Object[0]), null);
        }

        @Override
        public Path getPath() {
            return Paths.get("", new String[0]);
        }
    }
}

