/*
 * Decompiled with CFR 0.152.
 */
package triady.generator.type.interfaces;

import compozitor.processor.core.interfaces.FieldModel;
import compozitor.processor.core.interfaces.PackageModel;
import compozitor.processor.core.interfaces.TypeModel;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import triady.generator.type.interfaces.TypeHash;

class TypeHashFactory {
    TypeHashFactory() {
    }

    public static TypeHash create(TypeModel typeModel) {
        TypeHash typeHash = TypeHash.create();
        typeModel.getFields().forEach(field -> TypeHashFactory.add(field, typeHash));
        return typeHash;
    }

    private static void add(FieldModel field, TypeHash typeHash) {
        String property = field.getName();
        TypeModel type = field.getType();
        TypeHashFactory.set(property, type, typeHash);
    }

    private static void set(String property, TypeModel value, TypeHash typeHash) {
        if (TypeHashFactory.simpleType(value)) {
            typeHash.set(property, value.getName());
            return;
        }
        if (value.isEnum()) {
            List values = value.getConstants().stream().map(constant -> constant.getName()).collect(Collectors.toList());
            typeHash.set(property, values);
            return;
        }
        TypeHash valueTypeHash = TypeHash.create();
        typeHash.set(property, valueTypeHash);
        value.getFields().forEach(field -> TypeHashFactory.add(field, valueTypeHash));
    }

    private static boolean simpleType(TypeModel typeModel) {
        PackageModel packageModel = typeModel.getPackage();
        for (String packageName : Arrays.asList("java.lang", "java.util", "java.math", "java.sql")) {
            if (!packageModel.getName().startsWith(packageName)) continue;
            return true;
        }
        return false;
    }
}

