/*
 * Decompiled with CFR 0.152.
 */
package triady.generator.type.interfaces;

import compozitor.processor.core.interfaces.TypeModel;
import java.nio.file.Path;
import java.nio.file.Paths;
import triady.generator.core.interfaces.Id;
import triady.generator.core.interfaces.Resource;
import triady.generator.type.interfaces.TypeHash;
import triady.generator.type.interfaces.TypeHashFactory;

public class TypeSpecification
extends Resource {
    private static final Path PATH = Paths.get("src/data/", "types/");
    private final TypeHash typeHash;
    private final Boolean undefined;

    private TypeSpecification(Id id, TypeHash typeHash, Boolean undefined) {
        super(PATH.toString(), id);
        this.typeHash = typeHash;
        this.undefined = undefined;
    }

    public static TypeSpecification create() {
        return new TypeSpecification(Id.create(new Object[0]), null, true){

            @Override
            public Path getPath() {
                return Paths.get("", new String[0]);
            }
        };
    }

    public static TypeSpecification create(TypeModel typeModel) {
        Id id = Id.create(typeModel.getQualifiedName());
        TypeHash typeHash = TypeHashFactory.create(typeModel);
        return new TypeSpecification(id, typeHash, false);
    }

    public Path getEndpoint() {
        String endpoint = this.getPath().toString().replace("src", "");
        return Paths.get(endpoint, new String[0]);
    }

    public Boolean undefined() {
        return this.undefined;
    }

    public String toYaml() {
        return this.typeHash.toYaml();
    }

    public String toString() {
        return this.toYaml();
    }
}

