/*
 * Decompiled with CFR 0.152.
 */
package org.arecap.cop;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=-2147483648)
public final class BeanUtil
implements ApplicationContextAware {
    private static ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static Map<String, Class<?>> getAnnotatedBeans(Class<? extends Annotation> annotationType) {
        String[] beanNames = BeanUtil.getBeanNamesForAnnotation(annotationType);
        LinkedHashMap results = new LinkedHashMap(beanNames.length);
        for (String beanName : beanNames) {
            results.put(beanName, BeanUtil.getBeanType(beanName));
        }
        return results;
    }

    public static Object getBean(Class<?> beanClass) {
        if (context == null) {
            return null;
        }
        return context.getBean(beanClass);
    }

    public static Object getBean(String beanName) {
        if (context == null) {
            return null;
        }
        return context.getBean(beanName);
    }

    public static Class<?> getBeanType(String beanName) {
        if (context == null) {
            return null;
        }
        return context.getType(beanName);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> beanType) {
        if (context == null) {
            return null;
        }
        return context.getBeansOfType(beanType);
    }

    public static BeanFactory getBeanFactory() {
        if (context == null) {
            return null;
        }
        return context.getAutowireCapableBeanFactory();
    }

    public static String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotation) {
        if (context == null) {
            return new String[0];
        }
        return context.getBeanNamesForAnnotation(annotation);
    }
}

