/*
 * Decompiled with CFR 0.152.
 */
package org.arecap.cop;

import java.lang.reflect.AnnotatedElement;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arecap.contextualj.lang.weaving.PointcutLinkSpecification;
import org.arecap.cop.ApplicationContextLink;
import org.arecap.cop.BeanUtil;
import org.arecap.cop.annotation.ContextOriented;
import org.arecap.cop.proxy.InverseMultiplexerIntroductionInterceptor;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration
@ComponentScan(value={"org.springframework.cop"})
public class ContextLinkWrapper
implements BeanPostProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private BeanUtil beanUtil;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean != null) {
            if (PointcutLinkSpecification.class.isAssignableFrom(bean.getClass())) {
                return bean;
            }
            this.logger.debug((Object)("postProcess bean signal:\t" + beanName));
            List<Class<?>> links = this.getContextOrientedBeans(beanName).entrySet().stream().filter(p -> ApplicationContextLink.isLink(AopUtils.getTargetClass((Object)bean), (AnnotatedElement)p.getValue())).map(p -> (Class)p.getValue()).sorted((Comparator<Class>)new AnnotationAwareOrderComparator()).collect(Collectors.toList());
            if (links.size() > 0) {
                this.logger.debug((Object)("bean signal:\t" + beanName + "\thas:\t" + links.size() + "\tlinks"));
                return this.wrapBean(bean, beanName, links);
            }
        }
        return bean;
    }

    private Map<String, Class<?>> getContextOrientedBeans(String beanName) {
        String[] beanNames = BeanUtil.getBeanNamesForAnnotation(ContextOriented.class);
        LinkedHashMap results = new LinkedHashMap(beanNames.length);
        for (String name : beanNames) {
            if (name.equalsIgnoreCase(beanName)) continue;
            results.put(name, BeanUtil.getBeanType(name));
        }
        return results;
    }

    private Object wrapBean(Object bean, String beanName, List<Class<?>> links) {
        this.logger.debug((Object)("inverse multiplex signal:\t" + beanName + "\tfor links types\t"));
        links.stream().forEach(link -> this.logger.debug((Object)("\t link type" + link)));
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(AopUtils.getTargetClass((Object)bean));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource(bean));
        proxyFactory.addAdvisor((Advisor)new DefaultIntroductionAdvisor((Advice)new InverseMultiplexerIntroductionInterceptor(links)));
        proxyFactory.setOptimize(true);
        proxyFactory.setExposeProxy(true);
        return proxyFactory.getProxy();
    }
}

