/*
 * Decompiled with CFR 0.152.
 */
package org.arecap.cop.annotation;

import org.springframework.util.Assert;

public interface SpringLexicalExpressionResolver {
    default public boolean resolveLexicalExpression(String lex, Object expressionValue, Object expressionValid) {
        switch (lex) {
            case "equals": {
                return expressionValue.equals(expressionValid);
            }
            case "between": {
                this.assertionLexNumberBetween(expressionValue, expressionValid);
                return ((Number)expressionValue).doubleValue() >= ((Number[])expressionValid)[0].doubleValue() && ((Number)expressionValue).doubleValue() <= ((Number[])expressionValid)[1].doubleValue();
            }
            case ">": {
                this.assertionLexNumberComparator(expressionValue, expressionValid);
                return ((Number)expressionValue).doubleValue() > ((Number)expressionValid).doubleValue();
            }
            case ">=": {
                this.assertionLexNumberComparator(expressionValue, expressionValid);
                return ((Number)expressionValue).doubleValue() >= ((Number)expressionValid).doubleValue();
            }
            case "<": {
                this.assertionLexNumberComparator(expressionValue, expressionValid);
                return ((Number)expressionValue).doubleValue() < ((Number)expressionValid).doubleValue();
            }
            case "<=": {
                this.assertionLexNumberComparator(expressionValue, expressionValid);
                return ((Number)expressionValue).doubleValue() <= ((Number)expressionValid).doubleValue();
            }
        }
        return false;
    }

    default public void assertionLexNumberBetween(Object expressionValue, Object expressionValid) {
        Assert.isAssignable(Number.class, expressionValue.getClass(), (String)"@ContextExpression lex BETWEEN value type not supported! Value must be a valid Number assignable type!");
        Assert.isAssignable(Number[].class, expressionValid.getClass(), (String)"@ContextExpression lex BETWEEN valid type not supported! Valid must be a valid Number array assignable type!");
        Assert.isTrue((((Number[])expressionValid).length == 2 ? 1 : 0) != 0, (String)("Valid number array length not supported! Current: " + ((Number[])expressionValid).length + " Expected: 2!"));
    }

    default public void assertionLexNumberComparator(Object expressionValue, Object expressionValid) {
        Assert.isAssignable(Number.class, expressionValue.getClass(), (String)"@ContextExpression lex BETWEEN value type not supported! Value must be a valid Number assignable type!");
        Assert.isAssignable(Number.class, expressionValid.getClass(), (String)"@ContextExpression lex BETWEEN valid type not supported! Valid must be a valid Number assignable type!");
    }
}

