/*
 * Decompiled with CFR 0.152.
 */
package org.arecap.cop.proxy;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arecap.contextualj.lang.annotation.ContextTarget;
import org.arecap.contextualj.lang.annotation.pointcut.Bid;
import org.arecap.contextualj.lang.annotation.pointcut.FinalBinding;
import org.arecap.contextualj.lang.annotation.pointcut.HandlingReturn;
import org.arecap.contextualj.lang.annotation.pointcut.HandlingThrowing;
import org.arecap.contextualj.lang.annotation.pointcut.Track;
import org.arecap.contextualj.lang.annotation.pointcut.Wrap;
import org.arecap.contextualj.lang.weaving.InverseMultiplexer;
import org.arecap.cop.ApplicationContextLink;
import org.arecap.cop.BeanUtil;
import org.arecap.cop.proxy.ContextOrientedMethodInvocation;
import org.arecap.cop.proxy.TrackMethodInvocation;
import org.arecap.cop.proxy.WrapMethodInvocation;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.ReflectionUtils;

public class InverseMultiplexerIntroductionInterceptor
extends DelegatingIntroductionInterceptor
implements InverseMultiplexer<MethodInvocation, Object> {
    private static final long serialVersionUID = 0L;
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final ReflectionUtils.MethodFilter bidSelector = method -> AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, Bid.class) != null;
    public static final ReflectionUtils.MethodFilter wrapSelector = method -> AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, Wrap.class) != null;
    public static final ReflectionUtils.MethodFilter trackSelector = method -> AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, Track.class) != null;
    public static final ReflectionUtils.MethodFilter finalBindingSelector = method -> AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, FinalBinding.class) != null;
    public static final ReflectionUtils.MethodFilter handlingReturnSelector = method -> AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, HandlingReturn.class) != null;
    public static final ReflectionUtils.MethodFilter handlingThrowingSelector = method -> AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, HandlingThrowing.class) != null;
    public static final ReflectionUtils.FieldFilter contextTargetSelector = field -> AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, ContextTarget.class) != null;
    private final List<Class<?>> links;

    public InverseMultiplexerIntroductionInterceptor(List<Class<?>> links) {
        this.links = links;
    }

    protected Object doProceed(MethodInvocation mi) throws Throwable {
        this.logger.debug((Object)("inverse multiplexer of signal method:\t" + mi.getMethod().getName() + "\t of object instance type:\t" + mi.getThis().getClass()));
        return this.inverseMultiplex(mi);
    }

    public void bidMux(MethodInvocation methodInvocation) throws Throwable {
        for (Class<?> link : this.links) {
            for (Method bidMethod : this.getLinks(methodInvocation.getMethod(), MethodIntrospector.selectMethods(link, (ReflectionUtils.MethodFilter)bidSelector).stream())) {
                new ContextOrientedMethodInvocation(this.getLink(methodInvocation.getThis(), link), bidMethod, this.resolveLinkArguments(bidMethod, methodInvocation)).proceed();
            }
        }
    }

    public void returnMux(MethodInvocation methodInvocation, Object o) throws Throwable {
        for (Class<?> link : this.links) {
            for (Method handlingReturnMethod : this.getLinks(methodInvocation.getMethod(), MethodIntrospector.selectMethods(link, (ReflectionUtils.MethodFilter)handlingReturnSelector).stream())) {
                new ContextOrientedMethodInvocation(this.getLink(methodInvocation.getThis(), link), handlingReturnMethod, this.resolveHandlingReturnLinkArguments(handlingReturnMethod, methodInvocation, o)).proceed();
            }
        }
    }

    public void finalMux(MethodInvocation methodInvocation, Object o, Throwable throwable) {
        for (Class<?> link : this.links) {
            for (Method finalBidingMethod : this.getLinks(methodInvocation.getMethod(), MethodIntrospector.selectMethods(link, (ReflectionUtils.MethodFilter)finalBindingSelector).stream())) {
                try {
                    new ContextOrientedMethodInvocation(this.getLink(methodInvocation.getThis(), link), finalBidingMethod, this.resolveFinalBindingLinkArguments(finalBidingMethod, methodInvocation, o, throwable)).proceed();
                }
                catch (Throwable throwable1) {
                    this.logger.warn((Object)"@link FinalBinding advices should not be throwable! Implemented not supported!", throwable1);
                }
            }
        }
    }

    public void throwingMux(MethodInvocation methodInvocation, Throwable throwable) {
        for (Class<?> link : this.links) {
            for (Method handlingThrowingMethod : this.getLinks(methodInvocation.getMethod(), MethodIntrospector.selectMethods(link, (ReflectionUtils.MethodFilter)handlingThrowingSelector).stream())) {
                try {
                    new ContextOrientedMethodInvocation(this.getLink(methodInvocation.getThis(), link), handlingThrowingMethod, this.resolveHandlingThrowingLinkArguments(handlingThrowingMethod, methodInvocation, throwable)).proceed();
                }
                catch (Throwable throwable1) {
                    this.logger.warn((Object)"@link HandlingThrowing advices should not be throwable! Implemented not supported!", throwable1);
                }
            }
        }
    }

    public Object wrapTrackMux(MethodInvocation methodInvocation) throws Throwable {
        WrapMethodInvocation wrapMethodInvocation = new WrapMethodInvocation(methodInvocation);
        LinkedHashSet<MethodInvocation> trackMethodInvocation = new LinkedHashSet<MethodInvocation>();
        for (Class<?> link : this.links) {
            for (Method wrapMethod : this.getLinks(methodInvocation.getMethod(), MethodIntrospector.selectMethods(link, (ReflectionUtils.MethodFilter)wrapSelector).stream())) {
                wrapMethodInvocation.add(new ContextOrientedMethodInvocation(this.getLink(methodInvocation.getThis(), link), wrapMethod, this.resolveWrapLinkArguments(wrapMethod, methodInvocation)));
            }
            for (Method trackMethod : this.getLinks(methodInvocation.getMethod(), MethodIntrospector.selectMethods(link, (ReflectionUtils.MethodFilter)trackSelector).stream())) {
                trackMethodInvocation.add(new ContextOrientedMethodInvocation(this.getLink(methodInvocation.getThis(), link), trackMethod, this.resolveLinkArguments(trackMethod, methodInvocation)));
            }
        }
        wrapMethodInvocation.add(new TrackMethodInvocation(methodInvocation, trackMethodInvocation));
        return wrapMethodInvocation.proceed();
    }

    private List<Method> getLinks(Method signal, Stream<Method> links) {
        return links.filter(link -> ApplicationContextLink.isLink(signal, link)).sorted((Comparator<Method>)new AnnotationAwareOrderComparator()).collect(Collectors.toList());
    }

    private boolean hasNoArgs(Method linkMethod) {
        return linkMethod.getParameterTypes().length == 0;
    }

    private boolean isObjectTypeFirstParameter(Method adviceMethod) {
        return Object.class.isAssignableFrom(adviceMethod.getParameterTypes()[0]);
    }

    private boolean isThrowableTypeFirstParameter(Method adviceMethod) {
        return adviceMethod.getParameterTypes()[0].isAssignableFrom(Throwable.class);
    }

    private Object[] argsMatchBinding(Method linkMethod, MethodInvocation joinPoint) {
        if (linkMethod.getParameterTypes().length != joinPoint.getArguments().length) {
            throw new IllegalArgumentException();
        }
        for (Class<?> adviceMethodParameterType : linkMethod.getParameterTypes()) {
            for (Object methodInvocationArgument : joinPoint.getArguments()) {
                if (adviceMethodParameterType.isAssignableFrom(methodInvocationArgument.getClass())) continue;
                throw new IllegalArgumentException();
            }
        }
        return joinPoint.getArguments();
    }

    private Object[] resolveLinkArguments(Method linkMethod, MethodInvocation joinPoint) {
        if (this.hasNoArgs(linkMethod)) {
            return new Object[0];
        }
        return this.argsMatchBinding(linkMethod, joinPoint);
    }

    private Object[] resolveFinalBindingLinkArguments(Method linkMethod, MethodInvocation joinPoint, Object returnObj, Throwable throwable) {
        if (this.hasNoArgs(linkMethod)) {
            return new Object[0];
        }
        if (linkMethod.getParameterTypes().length == 1) {
            if (this.isThrowableTypeFirstParameter(linkMethod)) {
                return new Object[]{throwable};
            }
            return new Object[]{returnObj};
        }
        if (linkMethod.getParameterTypes().length != 2) {
            throw new IllegalArgumentException();
        }
        if (!this.isObjectTypeFirstParameter(linkMethod) && !linkMethod.getParameterTypes()[1].isAssignableFrom(Throwable.class)) {
            throw new IllegalArgumentException();
        }
        return new Object[]{returnObj, throwable};
    }

    private Object[] resolveHandlingReturnLinkArguments(Method linkMethod, MethodInvocation joinPoint, Object returnObj) {
        if (this.hasNoArgs(linkMethod)) {
            return new Object[0];
        }
        if (linkMethod.getParameterTypes().length != 1) {
            throw new IllegalArgumentException();
        }
        if (!this.isObjectTypeFirstParameter(linkMethod)) {
            throw new IllegalArgumentException();
        }
        return new Object[]{returnObj};
    }

    private Object[] resolveHandlingThrowingLinkArguments(Method linkMethod, MethodInvocation joinPoint, Throwable throwable) {
        if (this.hasNoArgs(linkMethod)) {
            return new Object[0];
        }
        if (linkMethod.getParameterTypes().length != 1) {
            throw new IllegalArgumentException();
        }
        if (!this.isThrowableTypeFirstParameter(linkMethod)) {
            throw new IllegalArgumentException();
        }
        return new Object[]{throwable};
    }

    public Object[] resolveWrapLinkArguments(Method linkMethod, MethodInvocation joinPoint) {
        if (linkMethod.getParameterTypes().length != 1) {
            throw new IllegalArgumentException();
        }
        if (!MethodInvocation.class.isAssignableFrom(linkMethod.getParameterTypes()[0])) {
            throw new IllegalArgumentException();
        }
        return new Object[]{joinPoint};
    }

    private Object getLink(Object signal, Class<?> linkType) {
        Object link = BeanUtil.getBean(linkType);
        ReflectionUtils.doWithFields(linkType, field -> {
            if (field.getType().isAssignableFrom(signal.getClass())) {
                boolean acc = field.isAccessible();
                field.setAccessible(true);
                field.set(link, signal);
                field.setAccessible(acc);
            } else {
                this.logger.warn((Object)("ContextOriented type " + linkType + " declared error! @ContextTarget field type mismatch."));
            }
        }, (ReflectionUtils.FieldFilter)contextTargetSelector);
        return link;
    }
}

