/*
 * Decompiled with CFR 0.152.
 */
package org.arkecosystem.client;

import java.util.HashMap;
import java.util.Map;
import org.arkecosystem.client.Connection;
import org.arkecosystem.client.api.AbstractAPI;

public class ConnectionManager {
    private Map<String, Connection<? extends AbstractAPI>> connections = new HashMap<String, Connection<? extends AbstractAPI>>();
    private String defaultConnection = "main";

    public String getDefaultConnection() {
        return this.defaultConnection;
    }

    public void setDefaultConnection(String name) {
        this.defaultConnection = name;
    }

    public Map<String, Connection<? extends AbstractAPI>> getConnections() {
        return this.connections;
    }

    public <T extends AbstractAPI> Connection<T> connect(Map config, String name) {
        if (this.connections.containsKey(name)) {
            throw new IllegalArgumentException("Connection [" + name + "] is already configured.");
        }
        this.connections.put(name, new Connection(config));
        return this.connections.get(name);
    }

    public <T extends AbstractAPI> Connection<T> connect(Map config) {
        return this.connect(config, "main");
    }

    public void disconnect(String name) {
        if (name == null || name.isEmpty()) {
            name = this.getDefaultConnection();
        }
        this.connections.remove(name);
    }

    public void disconnect() {
        this.disconnect(null);
    }

    public <T extends AbstractAPI> Connection<T> connection(String name) {
        if (name == null || name.isEmpty()) {
            name = this.getDefaultConnection();
        }
        if (!this.connections.containsKey(name)) {
            throw new IllegalArgumentException("Connection [" + name + "] not configured.");
        }
        return this.connections.get(name);
    }

    public Connection connection() {
        return this.connection(null);
    }
}

