/*
 * Decompiled with CFR 0.152.
 */
package org.arkecosystem.client.http;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Client {
    private String host;
    private int version;
    private OkHttpClient client;
    private MediaType JSON = MediaType.parse((String)"application/json charset=utf-8");

    public Client(String host, int version) {
        this.host = host;
        this.version = version;
        this.client = new OkHttpClient();
    }

    public LinkedTreeMap<String, Object> get(String url, Map<String, Object> params) throws IOException {
        HttpUrl.Builder httpBuider = HttpUrl.parse((String)(this.host + url)).newBuilder();
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                httpBuider.addQueryParameter(entry.getKey(), entry.getValue().toString());
            }
        }
        Request request = new Request.Builder().url(httpBuider.build()).build();
        Response response = this.client.newCall(request).execute();
        return (LinkedTreeMap)new Gson().fromJson(response.body().string(), new LinkedTreeMap().getClass());
    }

    public LinkedTreeMap<String, Object> get(String url) throws IOException {
        return this.get(url, new HashMap<String, Object>());
    }

    public LinkedTreeMap<String, Object> post(String url, Map payload) throws IOException {
        RequestBody body = RequestBody.create((MediaType)this.JSON, (String)new Gson().toJson((Object)payload));
        Request request = new Request.Builder().url(this.host + url).post(body).build();
        Response response = this.client.newCall(request).execute();
        return (LinkedTreeMap)new Gson().fromJson(response.body().string(), new LinkedTreeMap().getClass());
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }
}

