/*
 * Decompiled with CFR 0.152.
 */
package org.arkecosystem.crypto.transactions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.arkecosystem.crypto.encoding.Hex;
import org.arkecosystem.crypto.enums.Types;
import org.arkecosystem.crypto.identities.Address;
import org.arkecosystem.crypto.transactions.Transaction;
import org.arkecosystem.crypto.transactions.deserializers.DelegateRegistration;
import org.arkecosystem.crypto.transactions.deserializers.MultiSignatureRegistration;
import org.arkecosystem.crypto.transactions.deserializers.SecondSignatureRegistration;
import org.arkecosystem.crypto.transactions.deserializers.Transfer;
import org.arkecosystem.crypto.transactions.deserializers.Vote;

public class Deserializer {
    private String serialized;
    private ByteBuffer buffer;
    private Transaction transaction;

    public Transaction deserialize(String serialized) {
        this.serialized = serialized;
        this.buffer = ByteBuffer.wrap(Hex.decode(serialized)).slice();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.get();
        this.transaction = new Transaction();
        int assetOffset = this.deserializeHeader();
        this.deserializeTypeSpecific(assetOffset);
        this.deserializeVersionOne();
        return this.transaction;
    }

    public int deserializeHeader() {
        this.transaction.version = this.buffer.get();
        this.transaction.network = this.buffer.get();
        this.transaction.type = Types.values()[this.buffer.get()];
        this.transaction.timestamp = this.buffer.getInt();
        byte[] senderPublicKey = new byte[33];
        this.buffer.get(senderPublicKey);
        this.transaction.senderPublicKey = Hex.encode(senderPublicKey);
        this.transaction.fee = this.buffer.getLong();
        byte vendorFieldLength = this.buffer.get();
        if (vendorFieldLength > 0) {
            byte[] vendorFieldHex = new byte[vendorFieldLength];
            this.buffer.get(vendorFieldHex);
            this.transaction.vendorFieldHex = Hex.encode(vendorFieldHex);
        }
        return 100 + vendorFieldLength * 2;
    }

    public void deserializeTypeSpecific(int assetOffset) {
        switch (this.transaction.type) {
            case TRANSFER: {
                new Transfer(this.serialized, this.buffer, this.transaction).deserialize(assetOffset);
                break;
            }
            case SECOND_SIGNATURE_REGISTRATION: {
                new SecondSignatureRegistration(this.serialized, this.buffer, this.transaction).deserialize(assetOffset);
                break;
            }
            case DELEGATE_REGISTRATION: {
                new DelegateRegistration(this.serialized, this.buffer, this.transaction).deserialize(assetOffset);
                break;
            }
            case VOTE: {
                new Vote(this.serialized, this.buffer, this.transaction).deserialize(assetOffset);
                break;
            }
            case MULTI_SIGNATURE_REGISTRATION: {
                new MultiSignatureRegistration(this.serialized, this.buffer, this.transaction).deserialize(assetOffset);
            }
        }
    }

    public void deserializeVersionOne() {
        if (this.transaction.secondSignature != null) {
            this.transaction.signSignature = this.transaction.secondSignature;
        }
        if (this.transaction.type == Types.VOTE) {
            this.transaction.recipientId = Address.fromPublicKey(this.transaction.senderPublicKey, this.transaction.network);
        }
        if (this.transaction.type == Types.MULTI_SIGNATURE_REGISTRATION) {
            for (int i = 0; i < this.transaction.asset.multisignature.keysgroup.size(); ++i) {
                this.transaction.asset.multisignature.keysgroup.set(i, "+" + this.transaction.asset.multisignature.keysgroup.get(i));
            }
        }
        if (this.transaction.vendorFieldHex != null) {
            this.transaction.vendorField = new String(Hex.decode(this.transaction.vendorFieldHex));
        }
        if (this.transaction.id == null) {
            this.transaction.id = this.transaction.computeId();
        }
        if (this.transaction.type == Types.SECOND_SIGNATURE_REGISTRATION || this.transaction.type == Types.MULTI_SIGNATURE_REGISTRATION) {
            this.transaction.recipientId = Address.fromPublicKey(this.transaction.senderPublicKey, this.transaction.network);
        }
    }
}

