/*
 * Decompiled with CFR 0.152.
 */
package org.arkecosystem.crypto.transactions.deserializers;

import java.nio.ByteBuffer;
import org.arkecosystem.crypto.transactions.Transaction;
import org.arkecosystem.crypto.transactions.deserializers.AbstractDeserializer;

public class Vote
extends AbstractDeserializer {
    public Vote(String serialized, ByteBuffer buffer, Transaction transaction) {
        super(serialized, buffer, transaction);
    }

    public void deserialize(int assetOffset) {
        this.buffer.position(assetOffset / 2);
        int voteLength = this.buffer.get() & 0xFF;
        for (int i = 0; i < voteLength; ++i) {
            String vote = this.serialized.substring(assetOffset + 2 + i * 2 * 34, assetOffset + 2 + (i + 1) * 2 * 34);
            vote = (vote.startsWith("01") ? (char)'+' : '-') + vote.substring(2);
            this.transaction.asset.votes.add(vote);
        }
        this.transaction.parseSignatures(this.serialized, assetOffset + 2 + voteLength * 34 * 2);
    }
}

