/*
 * Decompiled with CFR 0.152.
 */
package org.arkecosystem.crypto.utils;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.arkecosystem.crypto.encoding.Hex;
import org.arkecosystem.crypto.identities.PrivateKey;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Sha256Hash;

public class Message {
    private String publickey;
    private String signature;
    private String message;

    public Message(String publickey, String signature, String message) {
        this.publickey = publickey;
        this.signature = signature;
        this.message = message;
    }

    public static Message sign(String message, String passphrase) {
        ECKey privateKey = PrivateKey.fromPassphrase(passphrase);
        Sha256Hash messageBytes = Sha256Hash.of((byte[])message.getBytes());
        return new Message(privateKey.getPublicKeyAsHex(), Hex.encode(privateKey.sign(messageBytes).encodeToDER()), message);
    }

    public boolean verify() {
        ECKey keys = ECKey.fromPublicOnly((byte[])Hex.decode(this.publickey));
        byte[] signature = Hex.decode(this.signature);
        byte[] messageBytes = Sha256Hash.hash((byte[])this.message.getBytes());
        return ECKey.verify((byte[])messageBytes, (byte[])signature, (byte[])keys.getPubKey());
    }

    public Map toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("message", this.message);
        map.put("publickey", this.publickey);
        map.put("signature", this.signature);
        return map;
    }

    public String toJson() {
        return new Gson().toJson((Object)this.toMap());
    }

    public String getMessage() {
        return this.message;
    }

    public String getPublickey() {
        return this.publickey;
    }

    public String getSignature() {
        return this.signature;
    }
}

