/*
 * Decompiled with CFR 0.152.
 */
package org.arkecosystem.crypto.transactions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.arkecosystem.crypto.encoding.Hex;
import org.arkecosystem.crypto.enums.CoreTransactionTypes;
import org.arkecosystem.crypto.transactions.types.DelegateRegistration;
import org.arkecosystem.crypto.transactions.types.DelegateResignation;
import org.arkecosystem.crypto.transactions.types.HtlcClaim;
import org.arkecosystem.crypto.transactions.types.HtlcLock;
import org.arkecosystem.crypto.transactions.types.HtlcRefund;
import org.arkecosystem.crypto.transactions.types.Ipfs;
import org.arkecosystem.crypto.transactions.types.MultiPayment;
import org.arkecosystem.crypto.transactions.types.MultiSignatureRegistration;
import org.arkecosystem.crypto.transactions.types.SecondSignatureRegistration;
import org.arkecosystem.crypto.transactions.types.Transaction;
import org.arkecosystem.crypto.transactions.types.Transfer;
import org.arkecosystem.crypto.transactions.types.Vote;

public class Deserializer {
    private ByteBuffer buffer;
    private Transaction transaction;
    private Map<Integer, Transaction> transactionsClasses = new HashMap<Integer, Transaction>();

    public Deserializer(String serialized) {
        this.transactionsClasses.put(CoreTransactionTypes.TRANSFER.getValue(), new Transfer());
        this.transactionsClasses.put(CoreTransactionTypes.SECOND_SIGNATURE_REGISTRATION.getValue(), new SecondSignatureRegistration());
        this.transactionsClasses.put(CoreTransactionTypes.DELEGATE_REGISTRATION.getValue(), new DelegateRegistration());
        this.transactionsClasses.put(CoreTransactionTypes.VOTE.getValue(), new Vote());
        this.transactionsClasses.put(CoreTransactionTypes.MULTI_SIGNATURE_REGISTRATION.getValue(), new MultiSignatureRegistration());
        this.transactionsClasses.put(CoreTransactionTypes.IPFS.getValue(), new Ipfs());
        this.transactionsClasses.put(CoreTransactionTypes.MULTI_PAYMENT.getValue(), new MultiPayment());
        this.transactionsClasses.put(CoreTransactionTypes.DELEGATE_RESIGNATION.getValue(), new DelegateResignation());
        this.transactionsClasses.put(CoreTransactionTypes.HTLC_LOCK.getValue(), new HtlcLock());
        this.transactionsClasses.put(CoreTransactionTypes.HTLC_CLAIM.getValue(), new HtlcClaim());
        this.transactionsClasses.put(CoreTransactionTypes.HTLC_REFUND.getValue(), new HtlcRefund());
        this.buffer = ByteBuffer.wrap(Hex.decode(serialized)).slice();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public Transaction deserialize() {
        this.buffer.get();
        this.deserializeCommon();
        this.deserializeVendorField();
        this.transaction.deserialize(this.buffer);
        this.deserializeSignature();
        this.transaction.computeId();
        return this.transaction;
    }

    private void deserializeCommon() {
        byte version = this.buffer.get();
        byte network = this.buffer.get();
        int typeGroup = this.buffer.getInt();
        short type = this.buffer.getShort();
        long nonce = this.buffer.getLong();
        this.transaction = this.transactionsClasses.get(type);
        this.transaction.version = version;
        this.transaction.network = network;
        this.transaction.typeGroup = typeGroup;
        this.transaction.type = type;
        this.transaction.nonce = nonce;
        byte[] senderPublicKey = new byte[33];
        this.buffer.get(senderPublicKey);
        this.transaction.senderPublicKey = Hex.encode(senderPublicKey);
        this.transaction.fee = this.buffer.getLong();
    }

    private void deserializeVendorField() {
        byte vendorFieldLength = this.buffer.get();
        if (vendorFieldLength > 0) {
            byte[] vendorField = new byte[vendorFieldLength];
            this.buffer.get(vendorField);
            this.transaction.vendorField = new String(vendorField);
        }
    }

    private void deserializeSignature() {
        byte[] signatureBuffer;
        int signatureLength;
        if (this.buffer.remaining() != 0) {
            signatureLength = this.currentSignatureLength();
            signatureBuffer = new byte[signatureLength];
            this.buffer.get(signatureBuffer);
            this.transaction.signature = Hex.encode(signatureBuffer);
        }
        if (this.buffer.remaining() != 0) {
            signatureLength = this.currentSignatureLength();
            signatureBuffer = new byte[signatureLength];
            this.buffer.get(signatureBuffer);
            this.transaction.secondSignature = Hex.encode(signatureBuffer);
        }
    }

    private int currentSignatureLength() {
        int mark = this.buffer.position();
        this.buffer.position(mark + 1);
        String length = String.valueOf(this.buffer.get());
        int signatureLength = Integer.parseInt(length) + 2;
        this.buffer.position(mark);
        return signatureLength;
    }
}

