/*
 * Decompiled with CFR 0.152.
 */
package org.arkecosystem.crypto.transactions.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import org.arkecosystem.crypto.encoding.Hex;
import org.arkecosystem.crypto.enums.CoreTransactionTypes;
import org.arkecosystem.crypto.enums.TransactionTypeGroup;
import org.arkecosystem.crypto.transactions.types.Transaction;

public class Vote
extends Transaction {
    @Override
    public int getTransactionType() {
        return CoreTransactionTypes.VOTE.getValue();
    }

    @Override
    public int getTransactionTypeGroup() {
        return TransactionTypeGroup.CORE.getValue();
    }

    @Override
    public HashMap<String, Object> assetToHashMap() {
        HashMap<String, Object> asset = new HashMap<String, Object>();
        asset.put("votes", this.asset.votes);
        return asset;
    }

    @Override
    public byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(1 + this.asset.votes.size() * 34);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ArrayList<String> votes = new ArrayList<String>(this.asset.votes);
        for (int i = 0; i < votes.size(); ++i) {
            votes.set(i, (((String)votes.get(i)).startsWith("+") ? "01" : "00") + ((String)votes.get(i)).substring(1));
        }
        buffer.put((byte)votes.size());
        buffer.put(Hex.decode(String.join((CharSequence)"", votes)));
        return buffer.array();
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        int voteLength = buffer.get();
        for (int i = 0; i < voteLength; ++i) {
            byte[] voteBuffer = new byte[34];
            buffer.get(voteBuffer);
            String vote = Hex.encode(voteBuffer);
            vote = (vote.startsWith("01") ? (char)'+' : '-') + vote.substring(2);
            this.asset.votes.add(vote);
        }
    }
}

