/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Symbol;

public abstract class AbstractString
extends AbstractVector {
    public LispObject typep(LispObject type) {
        if (type instanceof Symbol) {
            if (type == Symbol.STRING) {
                return Lisp.T;
            }
            if (type == Symbol.BASE_STRING) {
                return Lisp.T;
            }
        }
        if (type == BuiltInClass.STRING) {
            return Lisp.T;
        }
        if (type == BuiltInClass.BASE_STRING) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public final boolean stringp() {
        return true;
    }

    public LispObject getElementType() {
        return Symbol.CHARACTER;
    }

    public final boolean isSimpleVector() {
        return false;
    }

    public final LispObject STRING() {
        return this;
    }

    public abstract void fill(char var1);

    public abstract char charAt(int var1);

    public abstract void setCharAt(int var1, char var2);

    public final String writeToString(int beginIndex, int endIndex) {
        LispThread thread;
        int limit;
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex > (limit = this.length())) {
            endIndex = limit;
        }
        if (Symbol.PRINT_ESCAPE.symbolValue(thread = LispThread.currentThread()) != Lisp.NIL || Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL) {
            StringBuilder sb = new StringBuilder("\"");
            for (int i = beginIndex; i < endIndex; ++i) {
                char c = this.charAt(i);
                if (c == '\"' || c == '\\') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            sb.append('\"');
            return sb.toString();
        }
        return this.getStringValue().substring(beginIndex, endIndex);
    }

    public String writeToString() {
        return this.writeToString(0, this.length());
    }

    public String toString() {
        int length = this.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(this.charAt(i));
        }
        return sb.toString();
    }
}

