/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Autoload;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Load;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class AutoloadMacro
extends Autoload {
    private static final Primitive AUTOLOAD_MACRO = new Primitive("autoload-macro", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject first) {
            if (first instanceof Symbol) {
                Symbol symbol = (Symbol)first;
                AutoloadMacro.installAutoloadMacro(symbol, null);
                return Lisp.T;
            }
            if (first instanceof Cons) {
                for (LispObject list = first; list != Lisp.NIL; list = list.cdr()) {
                    Symbol symbol = Lisp.checkSymbol(list.car());
                    AutoloadMacro.installAutoloadMacro(symbol, null);
                }
                return Lisp.T;
            }
            return Lisp.error(new TypeError(first));
        }

        public LispObject execute(LispObject first, LispObject second) {
            String fileName = second.getStringValue();
            if (first instanceof Symbol) {
                Symbol symbol = (Symbol)first;
                AutoloadMacro.installAutoloadMacro(symbol, fileName);
                return Lisp.T;
            }
            if (first instanceof Cons) {
                for (LispObject list = first; list != Lisp.NIL; list = list.cdr()) {
                    Symbol symbol = Lisp.checkSymbol(list.car());
                    AutoloadMacro.installAutoloadMacro(symbol, fileName);
                }
                return Lisp.T;
            }
            return Lisp.error(new TypeError(first));
        }
    };

    private AutoloadMacro(Symbol symbol) {
        super(symbol);
    }

    private AutoloadMacro(Symbol symbol, String fileName) {
        super(symbol, fileName, null);
    }

    static void installAutoloadMacro(Symbol symbol, String fileName) {
        AutoloadMacro am = new AutoloadMacro(symbol, fileName);
        if (symbol.getSymbolFunction() instanceof SpecialOperator) {
            Lisp.put(symbol, Symbol.MACROEXPAND_MACRO, am);
        } else {
            symbol.setSymbolFunction(am);
        }
    }

    public void load() {
        Load.loadSystemFile(this.getFileName(), true);
    }

    public String writeToString() {
        StringBuffer sb = new StringBuffer("#<AUTOLOAD-MACRO ");
        sb.append(this.getSymbol().writeToString());
        sb.append(" \"");
        sb.append(this.getFileName());
        sb.append("\">");
        return sb.toString();
    }
}

