/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.ComplexVector;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class BasicVector_UnsignedByte8
extends AbstractVector {
    private int capacity;
    private byte[] elements;

    public BasicVector_UnsignedByte8(int capacity) {
        this.elements = new byte[capacity];
        this.capacity = capacity;
    }

    public BasicVector_UnsignedByte8(byte[] array) {
        this.capacity = array.length;
        this.elements = new byte[this.capacity];
        System.arraycopy(array, 0, this.elements, 0, this.capacity);
    }

    public BasicVector_UnsignedByte8(LispObject[] array) {
        this.capacity = array.length;
        this.elements = new byte[this.capacity];
        int i = array.length;
        while (i-- > 0) {
            this.elements[i] = Lisp.coerceLispObjectToJavaByte(array[i]);
        }
    }

    public LispObject typeOf() {
        return Lisp.list(Symbol.SIMPLE_ARRAY, Lisp.UNSIGNED_BYTE_8, new Cons(Fixnum.getInstance(this.capacity)));
    }

    public LispObject classOf() {
        return BuiltInClass.VECTOR;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public LispObject getElementType() {
        return Lisp.UNSIGNED_BYTE_8;
    }

    public boolean isSimpleVector() {
        return false;
    }

    public boolean hasFillPointer() {
        return false;
    }

    public boolean isAdjustable() {
        return false;
    }

    public int capacity() {
        return this.capacity;
    }

    public int length() {
        return this.capacity;
    }

    public LispObject elt(int index) {
        try {
            return Lisp.coerceJavaByteToLispObject(this.elements[index]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return Lisp.NIL;
        }
    }

    public int aref(int index) {
        try {
            return this.elements[index] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.length);
            return 0;
        }
    }

    public LispObject AREF(int index) {
        try {
            return Lisp.coerceJavaByteToLispObject(this.elements[index]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.length);
            return Lisp.NIL;
        }
    }

    public void aset(int index, int n) {
        try {
            this.elements[index] = (byte)n;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    public void aset(int index, LispObject value) {
        try {
            this.elements[index] = Lisp.coerceLispObjectToJavaByte(value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    public LispObject subseq(int start, int end) {
        BasicVector_UnsignedByte8 v = new BasicVector_UnsignedByte8(end - start);
        int i = start;
        int j = 0;
        try {
            while (i < end) {
                v.elements[j++] = this.elements[i++];
            }
            return v;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Lisp.error(new TypeError("Array index out of bounds: " + i + "."));
        }
    }

    public void fill(LispObject obj) {
        byte b = Lisp.coerceLispObjectToJavaByte(obj);
        int i = this.capacity;
        while (i-- > 0) {
            this.elements[i] = b;
        }
    }

    public void shrink(int n) {
        if (n < this.capacity) {
            byte[] newArray = new byte[n];
            System.arraycopy(this.elements, 0, newArray, 0, n);
            this.elements = newArray;
            this.capacity = n;
            return;
        }
        if (n == this.capacity) {
            return;
        }
        Lisp.error(new LispError());
    }

    public LispObject reverse() {
        BasicVector_UnsignedByte8 result = new BasicVector_UnsignedByte8(this.capacity);
        int i = 0;
        int j = this.capacity - 1;
        while (i < this.capacity) {
            result.elements[i] = this.elements[j];
            ++i;
            --j;
        }
        return result;
    }

    public LispObject nreverse() {
        int i = 0;
        for (int j = this.capacity - 1; i < j; ++i, --j) {
            byte temp = this.elements[i];
            this.elements[i] = this.elements[j];
            this.elements[j] = temp;
        }
        return this;
    }

    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            LispObject[] newElements = new LispObject[newCapacity];
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    newElements[i] = list.car();
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    newElements[i] = initialContents.elt(i);
                }
            } else {
                Lisp.type_error(initialContents, Symbol.SEQUENCE);
            }
            return new BasicVector_UnsignedByte8(newElements);
        }
        if (this.capacity != newCapacity) {
            LispObject[] newElements = new LispObject[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, Math.min(this.capacity, newCapacity));
            if (initialElement != null) {
                for (int i = this.capacity; i < newCapacity; ++i) {
                    newElements[i] = initialElement;
                }
            }
            return new BasicVector_UnsignedByte8(newElements);
        }
        return this;
    }

    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        return new ComplexVector(newCapacity, displacedTo, displacement);
    }
}

