/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public final class ByteArrayInputStream
extends Stream {
    private final java.io.ByteArrayInputStream byteArrayInputStream;
    private static final Primitive MAKE_BYTE_ARRAY_INPUT_STREAM = new Primitive("%make-byte-array-input-stream", Lisp.PACKAGE_SYS, false, "bytes &optional element-type"){

        public LispObject execute(LispObject bytes) {
            return new ByteArrayInputStream((byte[])bytes.javaInstance(byte[].class));
        }

        public LispObject execute(LispObject bytes, LispObject elementType) {
            return new ByteArrayInputStream((byte[])bytes.javaInstance(byte[].class), elementType);
        }
    };

    public ByteArrayInputStream(byte[] bytes) {
        this(bytes, Lisp.UNSIGNED_BYTE_8);
    }

    ByteArrayInputStream(byte[] bytes, LispObject elementType) {
        super(Symbol.SYSTEM_STREAM);
        this.elementType = elementType;
        this.byteArrayInputStream = new java.io.ByteArrayInputStream(bytes);
        this.initAsBinaryInputStream(this.byteArrayInputStream);
    }

    public LispObject typeOf() {
        return Symbol.STREAM;
    }

    public LispObject classOf() {
        return BuiltInClass.STREAM;
    }

    public LispObject typep(LispObject type) {
        return super.typep(type);
    }

    public String toString() {
        return this.unreadableString("BYTE-ARRAY-INPUT-STREAM");
    }
}

