/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class CharacterFunctions {
    private static final Primitive CHAR_EQUALS = new Primitive("char=", "&rest characters"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof LispCharacter) {
                return Lisp.T;
            }
            return Lisp.type_error(arg, Symbol.CHARACTER);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return LispCharacter.getValue(first) == LispCharacter.getValue(second) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject[] array) {
            int length = array.length;
            char c0 = LispCharacter.getValue(array[0]);
            for (int i = 1; i < length; ++i) {
                if (c0 == LispCharacter.getValue(array[i])) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive CHAR_EQUAL = new Primitive("char-equal", "&rest characters"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof LispCharacter) {
                return Lisp.T;
            }
            return Lisp.type_error(arg, Symbol.CHARACTER);
        }

        public LispObject execute(LispObject first, LispObject second) {
            char c2;
            char c1 = LispCharacter.getValue(first);
            if (c1 == (c2 = LispCharacter.getValue(second))) {
                return Lisp.T;
            }
            if (LispCharacter.toUpperCase(c1) == LispCharacter.toUpperCase(c2)) {
                return Lisp.T;
            }
            if (LispCharacter.toLowerCase(c1) == LispCharacter.toLowerCase(c2)) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }

        public LispObject execute(LispObject[] array) {
            int length = array.length;
            char c0 = LispCharacter.getValue(array[0]);
            for (int i = 1; i < length; ++i) {
                char c = LispCharacter.getValue(array[i]);
                if (c0 == c || LispCharacter.toUpperCase(c0) == LispCharacter.toUpperCase(c) || LispCharacter.toLowerCase(c0) == LispCharacter.toLowerCase(c)) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive CHAR_GREATERP = new Primitive("char-greaterp", "&rest characters"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof LispCharacter) {
                return Lisp.T;
            }
            return Lisp.type_error(arg, Symbol.CHARACTER);
        }

        public LispObject execute(LispObject first, LispObject second) {
            char c2;
            char c1 = LispCharacter.toUpperCase(LispCharacter.getValue(first));
            return c1 > (c2 = LispCharacter.toUpperCase(LispCharacter.getValue(second))) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject[] array) {
            int i;
            int length = array.length;
            char[] chars = new char[length];
            for (i = 0; i < length; ++i) {
                chars[i] = LispCharacter.toUpperCase(LispCharacter.getValue(array[i]));
            }
            for (i = 1; i < length; ++i) {
                if (chars[i - 1] > chars[i]) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive CHAR_NOT_GREATERP = new Primitive("char-not-greaterp", "&rest characters"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof LispCharacter) {
                return Lisp.T;
            }
            return Lisp.type_error(arg, Symbol.CHARACTER);
        }

        public LispObject execute(LispObject first, LispObject second) {
            char c2;
            char c1 = LispCharacter.toUpperCase(LispCharacter.getValue(first));
            return c1 <= (c2 = LispCharacter.toUpperCase(LispCharacter.getValue(second))) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject[] array) {
            int i;
            int length = array.length;
            char[] chars = new char[length];
            for (i = 0; i < length; ++i) {
                chars[i] = LispCharacter.toUpperCase(LispCharacter.getValue(array[i]));
            }
            for (i = 1; i < length; ++i) {
                if (chars[i] >= chars[i - 1]) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive CHAR_LESS_THAN = new Primitive("char<", "&rest characters"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof LispCharacter) {
                return Lisp.T;
            }
            return Lisp.type_error(arg, Symbol.CHARACTER);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return LispCharacter.getValue(first) < LispCharacter.getValue(second) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject[] args) {
            int i;
            int length = args.length;
            char[] chars = new char[length];
            for (i = 0; i < length; ++i) {
                chars[i] = LispCharacter.getValue(args[i]);
            }
            for (i = 1; i < length; ++i) {
                if (chars[i - 1] < chars[i]) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive CHAR_LE = new Primitive("char<=", "&rest characters"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof LispCharacter) {
                return Lisp.T;
            }
            return Lisp.type_error(arg, Symbol.CHARACTER);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return LispCharacter.getValue(first) <= LispCharacter.getValue(second) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (LispCharacter.getValue(first) > LispCharacter.getValue(second)) {
                return Lisp.NIL;
            }
            if (LispCharacter.getValue(second) > LispCharacter.getValue(third)) {
                return Lisp.NIL;
            }
            return Lisp.T;
        }

        public LispObject execute(LispObject[] args) {
            int i;
            int length = args.length;
            char[] chars = new char[length];
            for (i = 0; i < length; ++i) {
                chars[i] = LispCharacter.getValue(args[i]);
            }
            for (i = 1; i < length; ++i) {
                if (chars[i - 1] <= chars[i]) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive CHAR_LESSP = new Primitive("char-lessp", "&rest characters"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof LispCharacter) {
                return Lisp.T;
            }
            return Lisp.type_error(arg, Symbol.CHARACTER);
        }

        public LispObject execute(LispObject first, LispObject second) {
            char c2;
            char c1 = LispCharacter.toUpperCase(LispCharacter.getValue(first));
            return c1 < (c2 = LispCharacter.toUpperCase(LispCharacter.getValue(second))) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject[] array) {
            int i;
            int length = array.length;
            char[] chars = new char[length];
            for (i = 0; i < length; ++i) {
                chars[i] = LispCharacter.toUpperCase(LispCharacter.getValue(array[i]));
            }
            for (i = 1; i < length; ++i) {
                if (chars[i - 1] < chars[i]) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive CHAR_NOT_LESSP = new Primitive("char-not-lessp", "&rest characters"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof LispCharacter) {
                return Lisp.T;
            }
            return Lisp.type_error(arg, Symbol.CHARACTER);
        }

        public LispObject execute(LispObject first, LispObject second) {
            char c2;
            char c1 = LispCharacter.toUpperCase(LispCharacter.getValue(first));
            return c1 >= (c2 = LispCharacter.toUpperCase(LispCharacter.getValue(second))) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject[] array) {
            int i;
            int length = array.length;
            char[] chars = new char[length];
            for (i = 0; i < length; ++i) {
                chars[i] = LispCharacter.toUpperCase(LispCharacter.getValue(array[i]));
            }
            for (i = 1; i < length; ++i) {
                if (chars[i] <= chars[i - 1]) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
}

