/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.ArrayList;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Closure
extends Function {
    public static final int REQUIRED = 0;
    public static final int OPTIONAL = 1;
    public static final int KEYWORD = 2;
    public static final int REST = 3;
    public static final int AUX = 4;
    private static final int STATE_REQUIRED = 0;
    private static final int STATE_OPTIONAL = 1;
    private static final int STATE_KEYWORD = 2;
    private static final int STATE_REST = 3;
    private static final int STATE_AUX = 4;
    private Parameter[] requiredParameters = new Parameter[0];
    private Parameter[] optionalParameters = this.requiredParameters;
    private Parameter[] keywordParameters = this.requiredParameters;
    private Parameter[] auxVars = this.requiredParameters;
    private final LispObject body;
    private final LispObject executionBody;
    private final Environment environment;
    private final boolean andKey;
    private final boolean allowOtherKeys;
    private Symbol restVar;
    private Symbol envVar;
    private int arity;
    private int minArgs;
    private int maxArgs;
    private Symbol[] variables = new Symbol[0];
    private LispObject specials = Lisp.NIL;
    private boolean bindInitForms;
    private static final Primitive LAMBDA_LIST_NAMES = new Primitive("lambda-list-names", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            Closure closure = new Closure((LispObject)Lisp.list(Symbol.LAMBDA, arg, Lisp.NIL), new Environment());
            return closure.getVariableList();
        }
    };

    public Closure(Parameter[] required, Parameter[] optional, Parameter[] keyword, Symbol keys, Symbol rest, Symbol moreKeys) {
        this.minArgs = required.length;
        this.maxArgs = rest == Lisp.NIL && moreKeys == Lisp.NIL ? this.minArgs + optional.length + 2 * keyword.length : -1;
        this.arity = rest == Lisp.NIL && moreKeys == Lisp.NIL && keys == Lisp.NIL && optional.length == 0 ? this.maxArgs : -1;
        this.requiredParameters = required;
        this.optionalParameters = optional;
        this.keywordParameters = keyword;
        if (rest != Lisp.NIL) {
            this.restVar = rest;
        }
        this.andKey = keys != Lisp.NIL;
        this.allowOtherKeys = moreKeys != Lisp.NIL;
        this.variables = this.processVariables();
        this.bindInitForms = false;
        this.body = null;
        this.executionBody = null;
        this.environment = null;
    }

    public Closure(LispObject lambdaExpression, Environment env) {
        this(null, lambdaExpression, env);
    }

    public Closure(LispObject name, LispObject lambdaExpression, Environment env) {
        super(name, lambdaExpression.cadr());
        LispObject lambdaList = lambdaExpression.cadr();
        this.setLambdaList(lambdaList);
        if (lambdaList != Lisp.NIL && !(lambdaList instanceof Cons)) {
            Lisp.error(new ProgramError("The lambda list " + lambdaList.writeToString() + " is invalid."));
        }
        boolean _andKey = false;
        boolean _allowOtherKeys = false;
        if (lambdaList instanceof Cons) {
            int length = lambdaList.length();
            ArrayList<Parameter> required = null;
            ArrayList<Parameter> optional = null;
            ArrayList<Parameter> keywords = null;
            ArrayList<Parameter> aux = null;
            int state = 0;
            for (LispObject remaining = lambdaList; remaining != Lisp.NIL; remaining = remaining.cdr()) {
                LispObject obj = remaining.car();
                if (obj instanceof Symbol) {
                    if (state == 4) {
                        if (aux == null) {
                            aux = new ArrayList<Parameter>();
                        }
                        aux.add(new Parameter((Symbol)obj, Lisp.NIL, 4));
                        continue;
                    }
                    if (obj == Symbol.AND_OPTIONAL) {
                        state = 1;
                        this.arity = -1;
                        continue;
                    }
                    if (obj == Symbol.AND_REST || obj == Symbol.AND_BODY) {
                        LispObject remainingcar;
                        if (_andKey) {
                            Lisp.error(new ProgramError("&REST/&BODY must precede &KEY."));
                        }
                        state = 3;
                        this.arity = -1;
                        this.maxArgs = -1;
                        if ((remaining = remaining.cdr()) == Lisp.NIL) {
                            Lisp.error(new ProgramError("&REST/&BODY must be followed by a variable."));
                        }
                        if (this.restVar != null) {
                            Lisp.error(new ProgramError("&REST/&BODY may occur only once."));
                        }
                        if ((remainingcar = remaining.car()) instanceof Symbol) {
                            this.restVar = (Symbol)remainingcar;
                            continue;
                        }
                        Lisp.error(new ProgramError("&REST/&BODY must be followed by a variable."));
                        continue;
                    }
                    if (obj == Symbol.AND_ENVIRONMENT) {
                        remaining = remaining.cdr();
                        this.envVar = (Symbol)remaining.car();
                        this.arity = -1;
                        continue;
                    }
                    if (obj == Symbol.AND_KEY) {
                        state = 2;
                        _andKey = true;
                        this.arity = -1;
                        continue;
                    }
                    if (obj == Symbol.AND_ALLOW_OTHER_KEYS) {
                        _allowOtherKeys = true;
                        this.maxArgs = -1;
                        continue;
                    }
                    if (obj == Symbol.AND_AUX) {
                        state = 4;
                        this.arity = -1;
                        continue;
                    }
                    if (state == 1) {
                        if (optional == null) {
                            optional = new ArrayList();
                        }
                        optional.add(new Parameter((Symbol)obj, Lisp.NIL, 1));
                        if (this.maxArgs < 0) continue;
                        ++this.maxArgs;
                        continue;
                    }
                    if (state == 2) {
                        if (keywords == null) {
                            keywords = new ArrayList<Parameter>();
                        }
                        keywords.add(new Parameter((Symbol)obj, Lisp.NIL, 2));
                        if (this.maxArgs < 0) continue;
                        this.maxArgs += 2;
                        continue;
                    }
                    if (state != 0) {
                        Lisp.error(new ProgramError("required parameters cannot appear after &REST/&BODY."));
                    }
                    if (required == null) {
                        required = new ArrayList<Parameter>();
                    }
                    required.add(new Parameter((Symbol)obj));
                    if (this.maxArgs < 0) continue;
                    ++this.maxArgs;
                    continue;
                }
                if (obj instanceof Cons) {
                    LispObject initForm;
                    Symbol sym;
                    if (state == 4) {
                        sym = Lisp.checkSymbol(obj.car());
                        initForm = obj.cadr();
                        Debug.assertTrue(initForm != null);
                        if (aux == null) {
                            aux = new ArrayList();
                        }
                        aux.add(new Parameter(sym, initForm, 4));
                        continue;
                    }
                    if (state == 1) {
                        sym = Lisp.checkSymbol(obj.car());
                        initForm = obj.cadr();
                        LispObject svar = obj.cdr().cdr().car();
                        if (optional == null) {
                            optional = new ArrayList<Parameter>();
                        }
                        optional.add(new Parameter(sym, initForm, svar, 1));
                        if (this.maxArgs < 0) continue;
                        ++this.maxArgs;
                        continue;
                    }
                    if (state == 2) {
                        Symbol var;
                        Symbol keyword;
                        LispObject initForm2 = Lisp.NIL;
                        LispObject svar = Lisp.NIL;
                        LispObject first = obj.car();
                        if (first instanceof Cons) {
                            keyword = Lisp.checkSymbol(first.car());
                            var = Lisp.checkSymbol(first.cadr());
                        } else {
                            var = Lisp.checkSymbol(first);
                            keyword = Lisp.PACKAGE_KEYWORD.intern(var.name);
                        }
                        obj = obj.cdr();
                        if (obj != Lisp.NIL) {
                            initForm2 = obj.car();
                            if ((obj = obj.cdr()) != Lisp.NIL) {
                                svar = obj.car();
                            }
                        }
                        if (keywords == null) {
                            keywords = new ArrayList();
                        }
                        keywords.add(new Parameter(keyword, var, initForm2, svar));
                        if (this.maxArgs < 0) continue;
                        this.maxArgs += 2;
                        continue;
                    }
                    Closure.invalidParameter(obj);
                    continue;
                }
                Closure.invalidParameter(obj);
            }
            if (this.arity == 0) {
                this.arity = length;
            }
            if (required != null) {
                this.requiredParameters = new Parameter[required.size()];
                required.toArray(this.requiredParameters);
            }
            if (optional != null) {
                this.optionalParameters = new Parameter[optional.size()];
                optional.toArray(this.optionalParameters);
            }
            if (keywords != null) {
                this.keywordParameters = new Parameter[keywords.size()];
                keywords.toArray(this.keywordParameters);
            }
            if (aux != null) {
                this.auxVars = new Parameter[aux.size()];
                aux.toArray(this.auxVars);
            }
        } else {
            Debug.assertTrue(lambdaList == Lisp.NIL);
            this.arity = 0;
            this.maxArgs = 0;
        }
        this.body = lambdaExpression.cddr();
        LispObject bodyAndDecls = Lisp.parseBody(this.body, false);
        this.executionBody = bodyAndDecls.car();
        this.specials = Lisp.parseSpecials(bodyAndDecls.NTH(1));
        this.environment = env;
        this.andKey = _andKey;
        this.allowOtherKeys = _allowOtherKeys;
        this.minArgs = this.requiredParameters.length;
        if (this.arity >= 0) {
            Debug.assertTrue(this.arity == this.minArgs);
        }
        this.variables = this.processVariables();
    }

    private final void processParameters(ArrayList<Symbol> vars, Parameter[] parameters) {
        for (Parameter parameter : parameters) {
            vars.add(parameter.var);
            if (parameter.svar != Lisp.NIL) {
                vars.add((Symbol)parameter.svar);
            }
            if (this.bindInitForms || parameter.initForm.constantp()) continue;
            this.bindInitForms = true;
        }
    }

    private final Symbol[] processVariables() {
        ArrayList<Symbol> vars = new ArrayList<Symbol>();
        for (Parameter parameter : this.requiredParameters) {
            vars.add(parameter.var);
        }
        this.processParameters(vars, this.optionalParameters);
        if (this.restVar != null) {
            vars.add(this.restVar);
        }
        this.processParameters(vars, this.keywordParameters);
        Symbol[] array = new Symbol[vars.size()];
        vars.toArray(array);
        return array;
    }

    private static final void invalidParameter(LispObject obj) {
        Lisp.error(new ProgramError(obj.writeToString() + " may not be used as a variable in a lambda list."));
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.COMPILED_FUNCTION) {
            return Lisp.NIL;
        }
        return super.typep(typeSpecifier);
    }

    public final LispObject getVariableList() {
        LispObject result = Lisp.NIL;
        int i = this.variables.length;
        while (i-- > 0) {
            result = new Cons(this.variables[i], result);
        }
        return result;
    }

    public final LispObject getBody() {
        return this.body;
    }

    public final Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public LispObject execute() {
        if (this.arity == 0) {
            return Lisp.progn(this.executionBody, this.environment, LispThread.currentThread());
        }
        return this.execute(new LispObject[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LispObject bindParametersAndExecute(LispObject ... objects) {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        Environment ext = new Environment(this.environment);
        this.bindRequiredParameters(ext, thread, objects);
        if (this.arity != this.minArgs) {
            this.bindParameterDefaults(this.optionalParameters, ext, thread);
            if (this.restVar != null) {
                Lisp.bindArg(this.specials, this.restVar, Lisp.NIL, ext, thread);
            }
            this.bindParameterDefaults(this.keywordParameters, ext, thread);
        }
        this.bindAuxVars(ext, thread);
        this.declareFreeSpecials(ext);
        try {
            LispObject lispObject = Lisp.progn(this.executionBody, ext, thread);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    private final void bindRequiredParameters(Environment ext, LispThread thread, LispObject[] objects) {
        if (this.envVar != null) {
            Lisp.bindArg(this.specials, this.envVar, this.environment, ext, thread);
        }
        for (int i = 0; i < objects.length; ++i) {
            Lisp.bindArg(this.specials, this.requiredParameters[i].var, objects[i], ext, thread);
        }
    }

    public final LispObject invokeArrayExecute(LispObject ... objects) {
        return this.execute(objects);
    }

    @Override
    public LispObject execute(LispObject arg) {
        if (this.minArgs == 1) {
            return this.bindParametersAndExecute(arg);
        }
        return this.invokeArrayExecute(arg);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second) {
        if (this.minArgs == 2) {
            return this.bindParametersAndExecute(first, second);
        }
        return this.invokeArrayExecute(first, second);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        if (this.minArgs == 3) {
            return this.bindParametersAndExecute(first, second, third);
        }
        return this.invokeArrayExecute(first, second, third);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
        if (this.minArgs == 4) {
            return this.bindParametersAndExecute(first, second, third, fourth);
        }
        return this.invokeArrayExecute(first, second, third, fourth);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        if (this.minArgs == 5) {
            return this.bindParametersAndExecute(first, second, third, fourth, fifth);
        }
        return this.invokeArrayExecute(first, second, third, fourth, fifth);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        if (this.minArgs == 6) {
            return this.bindParametersAndExecute(first, second, third, fourth, fifth, sixth);
        }
        return this.invokeArrayExecute(first, second, third, fourth, fifth, sixth);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        if (this.minArgs == 7) {
            return this.bindParametersAndExecute(first, second, third, fourth, fifth, sixth, seventh);
        }
        return this.invokeArrayExecute(first, second, third, fourth, fifth, sixth, seventh);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        if (this.minArgs == 8) {
            return this.bindParametersAndExecute(first, second, third, fourth, fifth, sixth, seventh, eighth);
        }
        return this.invokeArrayExecute(first, second, third, fourth, fifth, sixth, seventh, eighth);
    }

    private final void declareFreeSpecials(Environment ext) {
        LispObject s = this.specials;
        block0: while (s != Lisp.NIL) {
            Symbol special = (Symbol)s.car();
            s = s.cdr();
            for (Symbol var : this.variables) {
                if (special == var) continue block0;
            }
            for (Parameter parameter : this.auxVars) {
                if (special == parameter.var) continue block0;
            }
            ext.declareSpecial(special);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LispObject execute(LispObject[] args) {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        Environment ext = new Environment(this.environment);
        args = this.optionalParameters.length == 0 && this.keywordParameters.length == 0 ? this.fastProcessArgs(args) : this.processArgs(args, thread);
        Debug.assertTrue(args.length == this.variables.length);
        if (this.envVar != null) {
            Lisp.bindArg(this.specials, this.envVar, this.environment, ext, thread);
        }
        for (int i = 0; i < this.variables.length; ++i) {
            Symbol sym = this.variables[i];
            Lisp.bindArg(this.specials, sym, args[i], ext, thread);
        }
        this.bindAuxVars(ext, thread);
        this.declareFreeSpecials(ext);
        try {
            LispObject lispObject = Lisp.progn(this.executionBody, ext, thread);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final LispObject[] processArgs(LispObject[] args, LispThread thread) {
        if (this.optionalParameters.length == 0 && this.keywordParameters.length == 0) {
            return this.fastProcessArgs(args);
        }
        int argsLength = args.length;
        if (this.arity >= 0) {
            if (argsLength != this.arity) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            return args;
        }
        if (argsLength < this.minArgs) {
            Lisp.error(new WrongNumberOfArgumentsException(this));
        }
        LispObject[] array = new LispObject[this.variables.length];
        int index = 0;
        SpecialBindingsMark mark = thread.markSpecialBindings();
        Environment ext = new Environment(this.environment);
        try {
            int i;
            if (this.bindInitForms && this.envVar != null) {
                Lisp.bindArg(this.specials, this.envVar, this.environment, ext, thread);
            }
            for (i = 0; i < this.minArgs; ++i) {
                if (this.bindInitForms) {
                    Lisp.bindArg(this.specials, this.requiredParameters[i].var, args[i], ext, thread);
                }
                array[index++] = args[i];
            }
            i = this.minArgs;
            int argsUsed = this.minArgs;
            for (Parameter parameter : this.optionalParameters) {
                if (i < argsLength) {
                    if (this.bindInitForms) {
                        Lisp.bindArg(this.specials, parameter.var, args[i], ext, thread);
                    }
                    array[index++] = args[i];
                    ++argsUsed;
                    if (parameter.svar != Lisp.NIL) {
                        if (this.bindInitForms) {
                            Lisp.bindArg(this.specials, (Symbol)parameter.svar, Lisp.T, ext, thread);
                        }
                        array[index++] = Lisp.T;
                    }
                } else {
                    LispObject value = parameter.initVal != null ? parameter.initVal : Lisp.eval(parameter.initForm, ext, thread);
                    if (this.bindInitForms) {
                        Lisp.bindArg(this.specials, parameter.var, value, ext, thread);
                    }
                    array[index++] = value;
                    if (parameter.svar != Lisp.NIL) {
                        if (this.bindInitForms) {
                            Lisp.bindArg(this.specials, (Symbol)parameter.svar, Lisp.NIL, ext, thread);
                        }
                        array[index++] = Lisp.NIL;
                    }
                }
                ++i;
            }
            if (this.restVar != null) {
                LispObject rest = Lisp.NIL;
                int j = argsLength;
                while (j-- > argsUsed) {
                    rest = new Cons(args[j], rest);
                }
                if (this.bindInitForms) {
                    Lisp.bindArg(this.specials, this.restVar, rest, ext, thread);
                }
                array[index++] = rest;
            }
            if (this.keywordParameters.length > 0) {
                int argsLeft = argsLength - argsUsed;
                if (argsLeft == 0) {
                    for (int k = 0; k < this.keywordParameters.length; ++k) {
                        Parameter parameter = this.keywordParameters[k];
                        LispObject value = parameter.initVal != null ? parameter.initVal : Lisp.eval(parameter.initForm, ext, thread);
                        if (this.bindInitForms) {
                            Lisp.bindArg(this.specials, parameter.var, value, ext, thread);
                        }
                        array[index++] = value;
                        if (parameter.svar == Lisp.NIL) continue;
                        if (this.bindInitForms) {
                            Lisp.bindArg(this.specials, (Symbol)parameter.svar, Lisp.NIL, ext, thread);
                        }
                        array[index++] = Lisp.NIL;
                    }
                } else {
                    if (argsLeft % 2 != 0) {
                        Lisp.error(new ProgramError("Odd number of keyword arguments."));
                    }
                    LispObject allowOtherKeysValue = null;
                    for (Parameter parameter : this.keywordParameters) {
                        Symbol keyword = parameter.keyword;
                        LispObject value = null;
                        boolean unbound = true;
                        for (int j = argsUsed; j < argsLength; j += 2) {
                            if (args[j] != keyword) continue;
                            if (this.bindInitForms) {
                                Lisp.bindArg(this.specials, parameter.var, args[j + 1], ext, thread);
                            }
                            int n = index++;
                            LispObject lispObject = args[j + 1];
                            array[n] = lispObject;
                            value = lispObject;
                            if (parameter.svar != Lisp.NIL) {
                                if (this.bindInitForms) {
                                    Lisp.bindArg(this.specials, (Symbol)parameter.svar, Lisp.T, ext, thread);
                                }
                                array[index++] = Lisp.T;
                            }
                            args[j] = null;
                            args[j + 1] = null;
                            unbound = false;
                            break;
                        }
                        if (unbound) {
                            value = parameter.initVal != null ? parameter.initVal : Lisp.eval(parameter.initForm, ext, thread);
                            if (this.bindInitForms) {
                                Lisp.bindArg(this.specials, parameter.var, value, ext, thread);
                            }
                            array[index++] = value;
                            if (parameter.svar != Lisp.NIL) {
                                if (this.bindInitForms) {
                                    Lisp.bindArg(this.specials, (Symbol)parameter.svar, Lisp.NIL, ext, thread);
                                }
                                array[index++] = Lisp.NIL;
                            }
                        }
                        if (keyword != Keyword.ALLOW_OTHER_KEYS || allowOtherKeysValue != null) continue;
                        allowOtherKeysValue = value;
                    }
                    if (!(this.allowOtherKeys || allowOtherKeysValue != null && allowOtherKeysValue != Lisp.NIL)) {
                        LispObject unrecognizedKeyword = null;
                        for (int j = argsUsed; j < argsLength; j += 2) {
                            LispObject keyword = args[j];
                            if (keyword == null) continue;
                            if (keyword == Keyword.ALLOW_OTHER_KEYS) {
                                if (allowOtherKeysValue != null || (allowOtherKeysValue = args[j + 1]) == Lisp.NIL) continue;
                                break;
                            }
                            boolean ok = false;
                            for (Parameter parameter : this.keywordParameters) {
                                if (parameter.keyword != keyword) continue;
                                ok = true;
                                break;
                            }
                            if (ok || unrecognizedKeyword != null) continue;
                            unrecognizedKeyword = keyword;
                        }
                        if (!(unrecognizedKeyword == null || this.allowOtherKeys || allowOtherKeysValue != null && allowOtherKeysValue != Lisp.NIL)) {
                            Lisp.error(new ProgramError("Unrecognized keyword argument " + unrecognizedKeyword.writeToString()));
                        }
                    }
                }
            } else if (argsUsed < argsLength) {
                if (argsUsed + 2 <= argsLength) {
                    LispObject keyword;
                    LispObject allowOtherKeysValue = Lisp.NIL;
                    for (int n = argsUsed; n < argsLength; n += 2) {
                        LispObject keyword2 = args[n];
                        if (keyword2 != Keyword.ALLOW_OTHER_KEYS) continue;
                        allowOtherKeysValue = args[n + 1];
                        break;
                    }
                    if (this.allowOtherKeys || allowOtherKeysValue != Lisp.NIL) {
                        while (argsUsed + 2 <= argsLength) {
                            argsUsed += 2;
                        }
                    } else if (this.andKey && (keyword = args[argsUsed]) == Keyword.ALLOW_OTHER_KEYS) {
                        argsUsed += 2;
                    }
                }
                if (argsUsed < argsLength && this.restVar == null) {
                    Lisp.error(new WrongNumberOfArgumentsException(this));
                }
            }
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
        return array;
    }

    protected final LispObject[] fastProcessArgs(LispObject[] args) {
        int argsLength = args.length;
        if (this.arity >= 0) {
            if (argsLength != this.arity) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            return args;
        }
        if (argsLength < this.minArgs) {
            Lisp.error(new WrongNumberOfArgumentsException(this));
        }
        LispObject[] array = new LispObject[this.variables.length];
        int index = 0;
        for (int i = 0; i < this.minArgs; ++i) {
            array[index++] = args[i];
        }
        int argsUsed = this.minArgs;
        if (this.restVar != null) {
            LispObject rest = Lisp.NIL;
            int j = argsLength;
            while (j-- > argsUsed) {
                rest = new Cons(args[j], rest);
            }
            array[index++] = rest;
        } else if (argsUsed < argsLength) {
            if (argsUsed + 2 <= argsLength) {
                LispObject keyword;
                LispObject allowOtherKeysValue = Lisp.NIL;
                for (int n = argsUsed; n < argsLength; n += 2) {
                    keyword = args[n];
                    if (keyword != Keyword.ALLOW_OTHER_KEYS) continue;
                    allowOtherKeysValue = args[n + 1];
                    break;
                }
                if (this.allowOtherKeys || allowOtherKeysValue != Lisp.NIL) {
                    while (argsUsed + 2 <= argsLength) {
                        argsUsed += 2;
                    }
                } else if (this.andKey && (keyword = args[argsUsed]) == Keyword.ALLOW_OTHER_KEYS) {
                    argsUsed += 2;
                }
            }
            if (argsUsed < argsLength && this.restVar == null) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
        }
        return array;
    }

    private final void bindParameterDefaults(Parameter[] parameters, Environment env, LispThread thread) {
        for (Parameter parameter : parameters) {
            LispObject value = parameter.initVal != null ? parameter.initVal : Lisp.eval(parameter.initForm, env, thread);
            Lisp.bindArg(this.specials, parameter.var, value, env, thread);
            if (parameter.svar == Lisp.NIL) continue;
            Lisp.bindArg(this.specials, (Symbol)parameter.svar, Lisp.NIL, env, thread);
        }
    }

    private final void bindAuxVars(Environment env, LispThread thread) {
        for (Parameter parameter : this.auxVars) {
            Symbol sym = parameter.var;
            LispObject value = parameter.initVal != null ? parameter.initVal : Lisp.eval(parameter.initForm, env, thread);
            Lisp.bindArg(this.specials, sym, value, env, thread);
        }
    }

    public static class Parameter {
        final Symbol var;
        final LispObject initForm;
        final LispObject initVal;
        final LispObject svar;
        private final int type;
        final Symbol keyword;

        public Parameter(Symbol var) {
            this.var = var;
            this.initForm = null;
            this.initVal = null;
            this.svar = Lisp.NIL;
            this.type = 0;
            this.keyword = null;
        }

        public Parameter(Symbol var, LispObject initForm, int type) {
            this.var = var;
            this.initForm = initForm;
            this.initVal = Parameter.processInitForm(initForm);
            this.svar = Lisp.NIL;
            this.type = type;
            this.keyword = type == 2 ? Lisp.PACKAGE_KEYWORD.intern(var.name) : null;
        }

        public Parameter(Symbol var, LispObject initForm, LispObject svar, int type) {
            this.var = var;
            this.initForm = initForm;
            this.initVal = Parameter.processInitForm(initForm);
            this.svar = svar != Lisp.NIL ? Lisp.checkSymbol(svar) : Lisp.NIL;
            this.type = type;
            this.keyword = type == 2 ? Lisp.PACKAGE_KEYWORD.intern(var.name) : null;
        }

        public Parameter(Symbol keyword, Symbol var, LispObject initForm, LispObject svar) {
            this.var = var;
            this.initForm = initForm;
            this.initVal = Parameter.processInitForm(initForm);
            this.svar = svar != Lisp.NIL ? Lisp.checkSymbol(svar) : Lisp.NIL;
            this.type = 2;
            this.keyword = keyword;
        }

        public String toString() {
            if (this.type == 0) {
                return this.var.toString();
            }
            StringBuffer sb = new StringBuffer();
            if (this.keyword != null) {
                sb.append(this.keyword);
                sb.append(' ');
            }
            sb.append(this.var.toString());
            sb.append(' ');
            sb.append(this.initForm);
            sb.append(' ');
            sb.append(this.type);
            return sb.toString();
        }

        private static final LispObject processInitForm(LispObject initForm) {
            if (initForm.constantp()) {
                if (initForm instanceof Symbol) {
                    return initForm.getSymbolValue();
                }
                if (initForm instanceof Cons) {
                    Debug.assertTrue(initForm.car() == Symbol.QUOTE);
                    return initForm.cadr();
                }
                return initForm;
            }
            return null;
        }
    }
}

