/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Autoload;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.StringOutputStream;
import org.armedbear.lisp.Symbol;

public class Condition
extends StandardObject {
    protected String message;

    public Condition() {
        super(StandardClass.CONDITION);
        Debug.assertTrue(this.slots.length == 2);
        this.setFormatArguments(Lisp.NIL);
    }

    protected Condition(LispClass cls) {
        super(cls);
        Debug.assertTrue(this.slots.length >= 2);
        this.setFormatArguments(Lisp.NIL);
    }

    public Condition(LispClass cls, int length) {
        super(cls, length);
    }

    public Condition(LispObject initArgs) {
        super(StandardClass.CONDITION);
        Debug.assertTrue(this.slots.length == 2);
        this.initialize(initArgs);
    }

    protected void initialize(LispObject initArgs) {
        LispObject control = null;
        LispObject arguments = null;
        while (initArgs instanceof Cons) {
            LispObject first = initArgs.car();
            initArgs = initArgs.cdr();
            LispObject second = initArgs.car();
            initArgs = initArgs.cdr();
            if (first == Keyword.FORMAT_CONTROL) {
                if (control != null) continue;
                control = second;
                continue;
            }
            if (first != Keyword.FORMAT_ARGUMENTS || arguments != null) continue;
            arguments = second;
        }
        if (control != null) {
            this.setFormatControl(control);
        }
        if (arguments == null) {
            arguments = Lisp.NIL;
        }
        this.setFormatArguments(arguments);
    }

    public Condition(String message) {
        super(StandardClass.CONDITION);
        Debug.assertTrue(this.slots.length == 2);
        this.setFormatControl(message);
        this.setFormatArguments(Lisp.NIL);
    }

    public final LispObject getFormatControl() {
        return this.getInstanceSlotValue(Symbol.FORMAT_CONTROL);
    }

    public final void setFormatControl(LispObject formatControl) {
        this.setInstanceSlotValue(Symbol.FORMAT_CONTROL, formatControl);
    }

    public final void setFormatControl(String s) {
        this.setFormatControl(new SimpleString(s));
    }

    public final LispObject getFormatArguments() {
        return this.getInstanceSlotValue(Symbol.FORMAT_ARGUMENTS);
    }

    public final void setFormatArguments(LispObject formatArguments) {
        this.setInstanceSlotValue(Symbol.FORMAT_ARGUMENTS, formatArguments);
    }

    public String getMessage() {
        return null;
    }

    public LispObject typeOf() {
        LispObject c = this.getLispClass();
        if (c instanceof LispClass) {
            return ((LispClass)c).getName();
        }
        if (c != null) {
            return Symbol.CLASS_NAME.execute(c);
        }
        return Symbol.CONDITION;
    }

    public LispObject classOf() {
        LispObject c = this.getLispClass();
        if (c != null) {
            return c;
        }
        return StandardClass.CONDITION;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.CONDITION) {
            return Lisp.T;
        }
        if (type == StandardClass.CONDITION) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public String getConditionReport() {
        String s = this.getMessage();
        if (s != null) {
            return s;
        }
        LispObject formatControl = this.getFormatControl();
        if (formatControl != Lisp.NIL) {
            return Lisp.format(formatControl, this.getFormatArguments());
        }
        return this.unreadableString(this.typeOf().writeToString());
    }

    public final String writeToString() {
        LispObject printLevel;
        LispThread thread = LispThread.currentThread();
        if (Symbol.PRINT_ESCAPE.symbolValue(thread) == Lisp.NIL) {
            String s = this.getMessage();
            if (s != null) {
                return s;
            }
            LispObject formatControl = this.getFormatControl();
            if (formatControl instanceof Function) {
                StringOutputStream stream = new StringOutputStream();
                Symbol.APPLY.execute(formatControl, stream, this.getFormatArguments());
                return stream.getString().getStringValue();
            }
            if (formatControl instanceof AbstractString) {
                LispObject f = Symbol.FORMAT.getSymbolFunction();
                if (f == null || f instanceof Autoload) {
                    return Lisp.format(formatControl, this.getFormatArguments());
                }
                return Symbol.APPLY.execute(f, Lisp.NIL, formatControl, this.getFormatArguments()).getStringValue();
            }
        }
        int maxLevel = (printLevel = Symbol.PRINT_LEVEL.symbolValue(thread)) instanceof Fixnum ? ((Fixnum)printLevel).value : Integer.MAX_VALUE;
        LispObject currentPrintLevel = Lisp._CURRENT_PRINT_LEVEL_.symbolValue(thread);
        int currentLevel = ((Fixnum)currentPrintLevel).value;
        if (currentLevel >= maxLevel) {
            return "#";
        }
        return this.unreadableString(this.typeOf().writeToString());
    }
}

