/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.ControlTransfer;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.JavaClassLoader;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaslClassLoader
extends JavaClassLoader {
    private final String baseName;
    private final JavaObject boxedThis = new JavaObject(this);
    private static final Primitive MAKE_FASL_CLASS_LOADER = new pf_make_fasl_class_loader();
    private static final Primitive GET_FASL_FUNCTION = new pf_get_fasl_function();

    public FaslClassLoader(String baseName) {
        this.baseName = baseName;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith(this.baseName + "_")) {
            String internalName = "org/armedbear/lisp/" + name;
            Class<?> c = this.findLoadedClass(internalName);
            if (c == null) {
                c = this.findClass(name);
            }
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            byte[] b = this.getFunctionClassBytes(name);
            return this.defineClass(name, b, 0, b.length);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (e instanceof ControlTransfer) {
                throw (ControlTransfer)e;
            }
            throw new ClassNotFoundException("Function class not found: " + name, e);
        }
    }

    public byte[] getFunctionClassBytes(String name) {
        Pathname pathname = new Pathname(name.substring("org/armedbear/lisp/".length()) + ".cls");
        return Lisp.readFunctionBytes(pathname);
    }

    public byte[] getFunctionClassBytes(Class<?> functionClass) {
        return this.getFunctionClassBytes(functionClass.getName());
    }

    public byte[] getFunctionClassBytes(Function f) {
        byte[] b = this.getFunctionClassBytes(f.getClass());
        f.setClassBytes(b);
        return b;
    }

    public LispObject loadFunction(int fnNumber) {
        try {
            String name = this.baseName + "_" + (fnNumber + 1);
            Function f = (Function)this.loadClass(name).newInstance();
            f.setClassBytes(this.getFunctionClassBytes(name));
            return f;
        }
        catch (Exception e) {
            if (e instanceof ControlTransfer) {
                throw (ControlTransfer)e;
            }
            Debug.trace(e);
            return Lisp.error(new LispError("Compiled function can't be loaded: " + this.baseName + "_" + (fnNumber + 1) + " " + Symbol.LOAD_TRUENAME.symbolValue()));
        }
    }

    private static final class pf_get_fasl_function
    extends Primitive {
        pf_get_fasl_function() {
            super("get-fasl-function", Lisp.PACKAGE_SYS, false, "loader function-number");
        }

        public LispObject execute(LispObject loader, LispObject fnNumber) {
            FaslClassLoader l = (FaslClassLoader)loader.javaInstance(FaslClassLoader.class);
            return l.loadFunction(fnNumber.intValue());
        }
    }

    private static final class pf_make_fasl_class_loader
    extends Primitive {
        pf_make_fasl_class_loader() {
            super("make-fasl-class-loader", Lisp.PACKAGE_SYS, false, "base-name");
        }

        public LispObject execute(LispObject baseName) {
            return new FaslClassLoader(baseName.getStringValue()).boxedThis;
        }

        public LispObject execute(LispObject unused1, LispObject baseName, LispObject unused2) {
            return this.execute(baseName);
        }
    }
}

