/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public class ForwardReferencedClass
extends LispClass {
    @DocString(name="make-forward-referenced=class")
    private static final Primitive MAKE_FORWARD_REFERENCED_CLASS = new Primitive("make-forward-referenced-class", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Symbol) {
                Symbol name = (Symbol)arg;
                ForwardReferencedClass c = new ForwardReferencedClass(name);
                LispClass.addClass(name, c);
                return c;
            }
            return Lisp.error(new TypeError(arg.writeToString() + " is not a valid class name."));
        }
    };

    public ForwardReferencedClass(Symbol name) {
        super(name);
    }

    public LispObject typeOf() {
        return Symbol.FORWARD_REFERENCED_CLASS;
    }

    public LispObject classOf() {
        return StandardClass.FORWARD_REFERENCED_CLASS;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.FORWARD_REFERENCED_CLASS) {
            return Lisp.T;
        }
        if (type == StandardClass.FORWARD_REFERENCED_CLASS) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public String writeToString() {
        StringBuffer sb = new StringBuffer(Symbol.FORWARD_REFERENCED_CLASS.writeToString());
        if (this.getName() != null) {
            sb.append(' ');
            sb.append(this.getName().writeToString());
        }
        return this.unreadableString(sb.toString());
    }
}

