/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.StackFrame;
import org.armedbear.lisp.Symbol;

public class JavaStackFrame
extends StackFrame {
    public final StackTraceElement javaFrame;
    static final Symbol CLASS = Lisp.internKeyword("CLASS");
    static final Symbol METHOD = Lisp.internKeyword("METHOD");
    static final Symbol FILE = Lisp.internKeyword("FILE");
    static final Symbol LINE = Lisp.internKeyword("LINE");
    static final Symbol NATIVE_METHOD = Lisp.internKeyword("NATIVE-METHOD");

    public JavaStackFrame(StackTraceElement javaFrame) {
        this.javaFrame = javaFrame;
    }

    public LispObject typeOf() {
        return Symbol.JAVA_STACK_FRAME;
    }

    public LispObject classOf() {
        return BuiltInClass.JAVA_STACK_FRAME;
    }

    public String writeToString() {
        String JAVA_STACK_FRAME = "JAVA-STACK-FRAME";
        return this.unreadableString("JAVA-STACK-FRAME " + this.toLispString().toString());
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.JAVA_STACK_FRAME) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.JAVA_STACK_FRAME) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    public LispObject toLispList() {
        LispObject result = Lisp.NIL;
        if (this.javaFrame == null) {
            return result;
        }
        result = result.push(CLASS);
        result = result.push(new SimpleString(this.javaFrame.getClassName()));
        result = result.push(METHOD);
        result = result.push(new SimpleString(this.javaFrame.getMethodName()));
        result = result.push(FILE);
        result = result.push(new SimpleString(this.javaFrame.getFileName()));
        result = result.push(LINE);
        result = result.push(Fixnum.getInstance(this.javaFrame.getLineNumber()));
        if (this.javaFrame.isNativeMethod()) {
            result = result.push(NATIVE_METHOD);
            result = result.push(Symbol.T);
        }
        return result.nreverse();
    }

    public SimpleString toLispString() {
        return new SimpleString(this.javaFrame.toString());
    }

    public LispObject getParts() {
        LispObject result = Lisp.NIL;
        result = result.push(new Cons("CLASS", (LispObject)new SimpleString(this.javaFrame.getClassName())));
        result = result.push(new Cons("METHOD", (LispObject)new SimpleString(this.javaFrame.getMethodName())));
        result = result.push(new Cons("FILE", (LispObject)new SimpleString(this.javaFrame.getFileName())));
        result = result.push(new Cons("LINE", (LispObject)Fixnum.getInstance(this.javaFrame.getLineNumber())));
        result = result.push(new Cons("NATIVE-METHOD", LispObject.getInstance(this.javaFrame.isNativeMethod())));
        return result.nreverse();
    }
}

