/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.AutoloadedFunctionProxy;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.FileStream;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.LogicalPathname;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Site;
import org.armedbear.lisp.SpecialBinding;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.Utilities;

public final class Load {
    private static final Symbol FASL_LOADER = Lisp.PACKAGE_SYS.intern("*FASL-LOADER*");
    static final LispObject COMPILE_FILE_INIT_FASL_TYPE = new SimpleString("_");
    static final Symbol _FASL_VERSION_ = Lisp.exportConstant("*FASL-VERSION*", Lisp.PACKAGE_SYS, Fixnum.getInstance(37));
    private static final Symbol _FASL_EXTERNAL_FORMAT_ = Lisp.internConstant("*FASL-EXTERNAL-FORMAT*", Lisp.PACKAGE_SYS, new SimpleString("UTF-8"));
    public static final Symbol _FASL_UNINTERNED_SYMBOLS_ = Lisp.internSpecial("*FASL-UNINTERNED-SYMBOLS*", Lisp.PACKAGE_SYS, Lisp.NIL);
    private static final Primitive INIT_FASL = new init_fasl();
    private static Symbol[] savedSpecials = new Symbol[]{Symbol.CURRENT_READTABLE, Symbol._PACKAGE_, Lisp._SPEED_, Lisp._SPACE_, Lisp._SAFETY_, Lisp._DEBUG_, Lisp._EXPLAIN_};
    private static final Primitive _LOAD = new _load();
    private static final Primitive _LOAD_RETURNING_LAST_RESULT = new _load_returning_last_result();
    private static final Primitive LOAD_SYSTEM_FILE = new load_system_file();

    public static final LispObject load(String filename) {
        LispThread thread = LispThread.currentThread();
        return Load.load(new Pathname(filename), Symbol.LOAD_VERBOSE.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, true);
    }

    private static final Pathname findLoadableFile(Pathname name) {
        LispObject truename = Pathname.truename(name, false);
        if (truename instanceof Pathname) {
            Pathname t = (Pathname)truename;
            if (t.name != Lisp.NIL && t.name != null) {
                return t;
            }
        }
        if (name.type == Lisp.NIL && (name.name != Lisp.NIL || name.name != null)) {
            Pathname lispPathname = new Pathname(name);
            lispPathname.type = new SimpleString("lisp");
            lispPathname.invalidateNamestring();
            LispObject lisp = Pathname.truename(lispPathname, false);
            Pathname abclPathname = new Pathname(name);
            abclPathname.type = new SimpleString("abcl");
            abclPathname.invalidateNamestring();
            LispObject abcl = Pathname.truename(abclPathname, false);
            if (lisp instanceof Pathname && abcl instanceof Pathname) {
                lispPathname = (Pathname)lisp;
                abclPathname = (Pathname)abcl;
                long lispLastModified = lispPathname.getLastModified();
                long abclLastModified = abclPathname.getLastModified();
                if (abclLastModified > lispLastModified) {
                    return abclPathname;
                }
                return lispPathname;
            }
            if (abcl instanceof Pathname) {
                return (Pathname)abcl;
            }
            if (lisp instanceof Pathname) {
                return (Pathname)lisp;
            }
        }
        if (name.isJar() && name.type.equals(Lisp.NIL)) {
            name.type = COMPILE_FILE_INIT_FASL_TYPE;
            name.invalidateNamestring();
            Pathname result = Load.findLoadableFile(name);
            if (result != null) {
                return result;
            }
            name.type = new SimpleString("abcl");
            name.invalidateNamestring();
            result = Load.findLoadableFile(name);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public static final LispObject load(Pathname pathname, boolean verbose, boolean print, boolean ifDoesNotExist) {
        return Load.load(pathname, verbose, print, ifDoesNotExist, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LispObject load(Pathname pathname, boolean verbose, boolean print, boolean ifDoesNotExist, boolean returnLastResult) {
        InputStream in;
        Pathname truename;
        Pathname mergedPathname = null;
        if (!pathname.isAbsolute() && !pathname.isJar()) {
            Pathname pathnameDefaults = Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue());
            mergedPathname = Pathname.mergePathnames(pathname, pathnameDefaults);
        }
        if ((truename = Load.findLoadableFile(mergedPathname != null ? mergedPathname : pathname)) == null || truename.equals(Lisp.NIL)) {
            if (ifDoesNotExist) {
                return Lisp.error(new FileError("File not found.", pathname));
            }
            Debug.warn("Failed to load " + pathname.getNamestring());
            return Lisp.NIL;
        }
        if (Utilities.checkZipFile(truename)) {
            String n = truename.getNamestring();
            mergedPathname = new Pathname(n = (n = Pathname.uriEncode(n)).startsWith("jar:") ? "jar:" + n + "!/" + truename.name.getStringValue() + "." + COMPILE_FILE_INIT_FASL_TYPE : "jar:file:" + n + "!/" + truename.name.getStringValue() + "." + COMPILE_FILE_INIT_FASL_TYPE);
            LispObject initTruename = Pathname.truename(mergedPathname);
            if (initTruename == null || initTruename.equals(Lisp.NIL)) {
                Pathname p = new Pathname(mergedPathname);
                p.name = Keyword.WILD;
                p.invalidateNamestring();
                LispObject result = Pathname.MATCH_WILD_JAR_PATHNAME.execute(p);
                if (result instanceof Cons && ((Cons)result).length() == 1 && ((Cons)result).car() instanceof Pathname) {
                    initTruename = (Pathname)result.car();
                } else {
                    String errorMessage = "Loadable FASL not found for '" + pathname + "'" + " in " + "'" + mergedPathname + "'";
                    if (ifDoesNotExist) {
                        return Lisp.error(new FileError(errorMessage, mergedPathname));
                    }
                    Debug.trace(errorMessage);
                    return Lisp.NIL;
                }
            }
            truename = (Pathname)initTruename;
        }
        Debug.assertTrue((in = truename.getInputStream()) != null);
        try {
            LispObject lispObject = Load.loadFileFromStream(pathname, truename, new Stream(Symbol.SYSTEM_STREAM, in, (LispObject)Symbol.CHARACTER), verbose, print, false, returnLastResult);
            return lispObject;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    return Lisp.error(new LispError(e.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LispObject loadSystemFile(String filename, boolean auto) {
        LispThread thread = LispThread.currentThread();
        if (auto) {
            SpecialBindingsMark mark = thread.markSpecialBindings();
            thread.bindSpecial(Symbol.CURRENT_READTABLE, Lisp.STANDARD_READTABLE.symbolValue(thread));
            thread.bindSpecial(Symbol._PACKAGE_, Lisp.PACKAGE_CL_USER);
            try {
                LispObject lispObject = Load.loadSystemFile(filename, Lisp._AUTOLOAD_VERBOSE_.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, auto);
                return lispObject;
            }
            finally {
                thread.resetSpecialBindings(mark);
            }
        }
        return Load.loadSystemFile(filename, Symbol.LOAD_VERBOSE.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, auto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LispObject loadSystemFile(String filename, boolean verbose, boolean print, boolean auto) {
        InputStream in = null;
        Pathname pathname = null;
        Pathname truename = null;
        pathname = new Pathname(filename);
        LispObject bootPath = Site.getLispHome();
        Pathname mergedPathname = bootPath instanceof Pathname ? Pathname.mergePathnames(pathname, (Pathname)bootPath) : pathname;
        URL url = null;
        truename = Load.findLoadableFile(mergedPathname);
        if (truename == null || truename.equals(Lisp.NIL) || bootPath.equals(Lisp.NIL)) {
            String path = pathname.asEntryPath();
            url = Lisp.class.getResource(path);
            if ((url == null || url.toString().endsWith("/")) && (url = Lisp.class.getResource(path.replace('-', '_') + ".abcl")) == null) {
                url = Lisp.class.getResource(path + ".lisp");
            }
            if (url == null) {
                return Lisp.error(new LispError("Failed to find loadable system file '" + path + "'" + " in boot classpath."));
            }
            if (!bootPath.equals(Lisp.NIL)) {
                Pathname urlPathname = new Pathname(url);
                truename = Load.findLoadableFile(urlPathname);
                if (truename == null) {
                    return Lisp.error(new LispError("Failed to find loadable system file in boot classpath '" + url + "'"));
                }
            } else {
                truename = null;
            }
        }
        if (truename != null && truename.type.writeToString().equals("abcl") && Utilities.checkZipFile(truename)) {
            Pathname init = new Pathname(truename.getNamestring());
            init.type = COMPILE_FILE_INIT_FASL_TYPE;
            LispObject t = Pathname.truename(init);
            if (t instanceof Pathname) {
                truename = (Pathname)t;
            } else {
                return Lisp.error(new LispError("Failed to find loadable init FASL in '" + init.getNamestring() + "'"));
            }
        }
        if (truename != null) {
            in = truename.getInputStream();
        } else {
            try {
                Debug.assertTrue(url != null);
                in = url.openStream();
            }
            catch (IOException e) {
                Lisp.error(new FileError("Failed to load system file: '" + filename + "'" + " from URL: " + "'" + url + "'"));
            }
        }
        if (in != null) {
            LispThread thread = LispThread.currentThread();
            SpecialBindingsMark mark = thread.markSpecialBindings();
            thread.bindSpecial(Lisp._WARN_ON_REDEFINITION_, Lisp.NIL);
            thread.bindSpecial(FASL_LOADER, Lisp.NIL);
            try {
                Stream stream = new Stream(Symbol.SYSTEM_STREAM, in, (LispObject)Symbol.CHARACTER);
                LispObject lispObject = Load.loadFileFromStream(pathname, truename, stream, verbose, print, auto);
                return lispObject;
            }
            finally {
                thread.resetSpecialBindings(mark);
                try {
                    in.close();
                }
                catch (IOException e) {
                    return Lisp.error(new LispError(e.getMessage()));
                }
            }
        }
        return Lisp.error(new FileError("Failed to load system file: '" + filename + "'" + " resolved as " + "'" + mergedPathname + "'", truename));
    }

    public static final LispObject getUninternedSymbol(int n) {
        LispThread thread = LispThread.currentThread();
        LispObject uninternedSymbols = _FASL_UNINTERNED_SYMBOLS_.symbolValue(thread);
        if (!(uninternedSymbols instanceof Cons)) {
            return uninternedSymbols.AREF(n);
        }
        LispInteger label = LispInteger.getInstance(n);
        while (uninternedSymbols != Lisp.NIL) {
            LispObject item = uninternedSymbols.car();
            if (label.eql(item.cdr())) {
                return item.car();
            }
            uninternedSymbols = uninternedSymbols.cdr();
        }
        return Lisp.error(new LispError("No entry for uninterned symbol."));
    }

    private static final LispObject loadFileFromStream(Pathname pathname, Pathname truename, Stream in, boolean verbose, boolean print, boolean auto) {
        return Load.loadFileFromStream(pathname == null ? Lisp.NIL : pathname, truename == null ? Lisp.NIL : truename, in, verbose, print, auto, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LispObject loadFileFromStream(LispObject pathname, LispObject truename, Stream in, boolean verbose, boolean print, boolean auto, boolean returnLastResult) {
        long start = System.currentTimeMillis();
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        for (Symbol special : savedSpecials) {
            thread.bindSpecialToCurrentValue(special);
        }
        int loadDepth = Fixnum.getValue(Lisp._LOAD_DEPTH_.symbolValue(thread));
        thread.bindSpecial(Lisp._LOAD_DEPTH_, Fixnum.getInstance(++loadDepth));
        String prefix = Load.getLoadVerbosePrefix(loadDepth);
        try {
            thread.bindSpecial(Symbol.LOAD_PATHNAME, pathname);
            Pathname truePathname = null;
            if (!truename.equals(Lisp.NIL)) {
                truePathname = new Pathname(((Pathname)truename).getNamestring());
                String type = truePathname.type.getStringValue();
                if (type.equals("abcl") || type.equals(COMPILE_FILE_INIT_FASL_TYPE.toString())) {
                    Pathname truenameFasl = new Pathname(truePathname);
                    thread.bindSpecial(Symbol.LOAD_TRUENAME_FASL, truenameFasl);
                }
                if (truePathname.type.getStringValue().equals(COMPILE_FILE_INIT_FASL_TYPE.getStringValue()) && truePathname.isJar()) {
                    if (truePathname.device.cdr() != Lisp.NIL) {
                        Pathname enclosingJar = (Pathname)truePathname.device.cdr().car();
                        truePathname.device = new Cons(truePathname.device.car(), Lisp.NIL);
                        truePathname.host = Lisp.NIL;
                        truePathname.directory = enclosingJar.directory;
                        if (truePathname.directory.car().equals(Keyword.RELATIVE)) {
                            truePathname.directory.setCar(Keyword.ABSOLUTE);
                        }
                        truePathname.name = enclosingJar.name;
                        truePathname.type = enclosingJar.type;
                        truePathname.invalidateNamestring();
                    } else if (!(truePathname.device.car() instanceof AbstractString)) {
                        truePathname = (Pathname)truePathname.device.car();
                        truePathname.invalidateNamestring();
                    }
                    thread.bindSpecial(Symbol.LOAD_TRUENAME, truePathname);
                } else {
                    thread.bindSpecial(Symbol.LOAD_TRUENAME, truename);
                }
            } else {
                thread.bindSpecial(Symbol.LOAD_TRUENAME, truename);
            }
            thread.bindSpecial(Lisp._SOURCE_, pathname != null ? pathname : Lisp.NIL);
            if (verbose) {
                Stream out = Lisp.getStandardOutput();
                out.freshLine();
                out._writeString(prefix);
                out._writeString(auto ? " Autoloading " : " Loading ");
                out._writeString(!truename.equals(Lisp.NIL) ? truePathname.writeToString() : "stream");
                out._writeLine(" ...");
                out._finishOutput();
                LispObject result = Load.loadStream(in, print, thread, returnLastResult);
                long elapsed = System.currentTimeMillis() - start;
                out.freshLine();
                out._writeString(prefix);
                out._writeString(auto ? " Autoloaded " : " Loaded ");
                out._writeString(!truename.equals(Lisp.NIL) ? truePathname.writeToString() : "stream");
                out._writeString(" (");
                out._writeString(String.valueOf((float)elapsed / 1000.0f));
                out._writeLine(" seconds)");
                out._finishOutput();
                LispObject lispObject = result;
                return lispObject;
            }
            LispObject lispObject = Load.loadStream(in, print, thread, returnLastResult);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    public static String getLoadVerbosePrefix(int loadDepth) {
        StringBuilder sb = new StringBuilder(";");
        int i = loadDepth - 1;
        while (i-- > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LispObject loadStream(Stream in, boolean print, LispThread thread, boolean returnLastResult) {
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(Lisp._LOAD_STREAM_, in);
        SpecialBinding sourcePositionBinding = thread.bindSpecial(Lisp._SOURCE_POSITION_, Fixnum.ZERO);
        try {
            LispObject lispObject;
            Environment env = new Environment();
            LispObject result = Lisp.NIL;
            while (true) {
                sourcePositionBinding.value = Fixnum.getInstance(in.getOffset());
                LispObject obj = in.read(false, Lisp.EOF, false, thread, Stream.currentReadtable);
                if (obj == Lisp.EOF) break;
                result = Lisp.eval(obj, env, thread);
                if (!print) continue;
                Stream out = Lisp.checkCharacterOutputStream(Symbol.STANDARD_OUTPUT.symbolValue(thread));
                out._writeLine(result.writeToString());
                out._finishOutput();
            }
            if (returnLastResult) {
                lispObject = result;
                return lispObject;
            }
            lispObject = Lisp.T;
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final LispObject faslLoadStream(LispThread thread) {
        Stream in = (Stream)Lisp._LOAD_STREAM_.symbolValue(thread);
        Environment env = new Environment();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        LispObject result = Lisp.NIL;
        try {
            LispObject obj;
            thread.bindSpecial(Lisp.AUTOLOADING_CACHE, AutoloadedFunctionProxy.makePreloadingContext());
            in.setExternalFormat(_FASL_EXTERNAL_FORMAT_.symbolValue(thread));
            while ((obj = in.read(false, Lisp.EOF, true, thread, Stream.faslReadtable)) != Lisp.EOF) {
                result = Lisp.eval(obj, env, thread);
            }
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
        return result;
    }

    static final LispObject load(LispObject filespec, LispObject verbose, LispObject print, LispObject ifDoesNotExist, LispObject returnLastResult) {
        if (filespec instanceof Stream && ((Stream)filespec).isOpen()) {
            LispObject pathname = filespec instanceof FileStream ? ((FileStream)filespec).getPathname() : Lisp.NIL;
            LispObject truename = pathname instanceof Pathname ? pathname : Lisp.NIL;
            return Load.loadFileFromStream(pathname, truename, (Stream)filespec, verbose != Lisp.NIL, print != Lisp.NIL, false, returnLastResult != Lisp.NIL);
        }
        Pathname pathname = Lisp.coerceToPathname(filespec);
        if (pathname instanceof LogicalPathname) {
            pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
        }
        return Load.load(pathname, verbose != Lisp.NIL, print != Lisp.NIL, ifDoesNotExist != Lisp.NIL, returnLastResult != Lisp.NIL);
    }

    private static class load_system_file
    extends Primitive {
        load_system_file() {
            super("load-system-file", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            LispThread thread = LispThread.currentThread();
            return Load.loadSystemFile(arg.getStringValue(), Symbol.LOAD_VERBOSE.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, false);
        }
    }

    private static class _load_returning_last_result
    extends Primitive {
        _load_returning_last_result() {
            super("%load-returning-last-result", Lisp.PACKAGE_SYS, false, "filespec verbose print if-does-not-exist");
        }

        public LispObject execute(LispObject filespec, LispObject verbose, LispObject print, LispObject ifDoesNotExist) {
            return Load.load(filespec, verbose, print, ifDoesNotExist, Lisp.T);
        }
    }

    private static class _load
    extends Primitive {
        _load() {
            super("%load", Lisp.PACKAGE_SYS, false, "filespec verbose print if-does-not-exist");
        }

        public LispObject execute(LispObject filespec, LispObject verbose, LispObject print, LispObject ifDoesNotExist) {
            return Load.load(filespec, verbose, print, ifDoesNotExist, Lisp.NIL);
        }
    }

    private static class init_fasl
    extends Primitive {
        init_fasl() {
            super("init-fasl", Lisp.PACKAGE_SYS, true, "&key version");
        }

        public LispObject execute(LispObject first, LispObject second) {
            LispThread thread = LispThread.currentThread();
            if (first == Keyword.VERSION && second.eql(_FASL_VERSION_.getSymbolValue())) {
                thread.bindSpecial(_FASL_UNINTERNED_SYMBOLS_, Lisp.NIL);
                thread.bindSpecial(Lisp._SOURCE_, Lisp.NIL);
                return Load.faslLoadStream(thread);
            }
            return Lisp.error(new SimpleError("FASL version mismatch; found '" + second.writeToString() + "' but expected '" + _FASL_VERSION_.getSymbolValue().writeToString() + "' in " + Symbol.LOAD_PATHNAME.symbolValue(thread).writeToString()));
        }
    }
}

