/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.ParseError;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class LogicalPathname
extends Pathname {
    private static final String LOGICAL_PATHNAME_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-;*.";
    private static final HashMap map = new HashMap();
    private static final String LOGICAL_PATHNAME_COMPONENT_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";
    private static final Primitive CANONICALIZE_LOGICAL_HOST = new canonicalize_logical_host();
    private static final Primitive _MAKE_LOGICAL_PATHNAME = new _make_logical_pathname();

    protected LogicalPathname() {
    }

    protected LogicalPathname(Pathname p) {
        super(p);
    }

    public LogicalPathname(String host, String rest) {
        int limit = rest.length();
        for (int i = 0; i < limit; ++i) {
            char c = rest.charAt(i);
            if (LOGICAL_PATHNAME_CHARS.indexOf(c) >= 0) continue;
            Lisp.error(new ParseError("The character #\\" + c + " is not valid in a logical pathname."));
            return;
        }
        this.host = new SimpleString(host);
        this.device = Keyword.UNSPECIFIC;
        int semi = rest.lastIndexOf(59);
        if (semi >= 0) {
            String d = rest.substring(0, semi + 1);
            this.directory = LogicalPathname.parseDirectory(d);
            rest = rest.substring(semi + 1);
        } else {
            this.directory = new Cons(Keyword.ABSOLUTE);
        }
        int dot = rest.indexOf(46);
        if (dot >= 0) {
            String n = rest.substring(0, dot);
            this.name = n.equals("*") ? Keyword.WILD : new SimpleString(n.toUpperCase());
            if ((dot = (rest = rest.substring(dot + 1)).indexOf(46)) >= 0) {
                String t = rest.substring(0, dot);
                this.type = t.equals("*") ? Keyword.WILD : new SimpleString(t.toUpperCase());
                String v = rest.substring(dot + 1);
                this.version = v.equals("*") ? Keyword.WILD : (v.equals("NEWEST") || v.equals("newest") ? Keyword.NEWEST : Lisp.PACKAGE_CL.intern("PARSE-INTEGER").execute(new SimpleString(v)));
            } else {
                String t = rest;
                this.type = t.equals("*") ? Keyword.WILD : new SimpleString(t.toUpperCase());
            }
        } else {
            String n = rest;
            if (n.equals("*")) {
                this.name = Keyword.WILD;
            } else if (n.length() > 0) {
                this.name = new SimpleString(n.toUpperCase());
            }
        }
    }

    public static final SimpleString canonicalizeStringComponent(AbstractString s) {
        int limit = s.length();
        for (int i = 0; i < limit; ++i) {
            char c = s.charAt(i);
            if (LOGICAL_PATHNAME_COMPONENT_CHARS.indexOf(c) >= 0) continue;
            Lisp.error(new ParseError("Invalid character #\\" + c + " in logical pathname component \"" + s + '\"'));
            return null;
        }
        return new SimpleString(s.getStringValue().toUpperCase());
    }

    public static Pathname translateLogicalPathname(LogicalPathname pathname) {
        return (Pathname)Symbol.TRANSLATE_LOGICAL_PATHNAME.execute(pathname);
    }

    private static final LispObject parseDirectory(String s) {
        LispObject result;
        if (s.charAt(0) == ';') {
            result = new Cons(Keyword.RELATIVE);
            s = s.substring(1);
        } else {
            result = new Cons(Keyword.ABSOLUTE);
        }
        StringTokenizer st = new StringTokenizer(s, ";");
        while (st.hasMoreTokens()) {
            LispObject obj;
            String token = st.nextToken();
            if (token.equals("*")) {
                obj = Keyword.WILD;
            } else if (token.equals("**")) {
                obj = Keyword.WILD_INFERIORS;
            } else if (token.equals("..")) {
                if (result.car() instanceof AbstractString) {
                    result = result.cdr();
                    continue;
                }
                obj = Keyword.UP;
            } else {
                obj = new SimpleString(token.toUpperCase());
            }
            result = new Cons(obj, result);
        }
        return ((LispObject)result).nreverse();
    }

    public LispObject typeOf() {
        return Symbol.LOGICAL_PATHNAME;
    }

    public LispObject classOf() {
        return BuiltInClass.LOGICAL_PATHNAME;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.LOGICAL_PATHNAME) {
            return Lisp.T;
        }
        if (type == BuiltInClass.LOGICAL_PATHNAME) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    protected String getDirectoryNamestring() {
        StringBuilder sb = new StringBuilder();
        if (this.directory != Lisp.NIL) {
            LispObject temp = this.directory;
            LispObject part = temp.car();
            if (part != Keyword.ABSOLUTE) {
                if (part == Keyword.RELATIVE) {
                    sb.append(';');
                } else {
                    Lisp.error(new FileError("Unsupported directory component " + part.writeToString() + ".", this));
                }
            }
            for (temp = temp.cdr(); temp != Lisp.NIL; temp = temp.cdr()) {
                part = temp.car();
                if (part instanceof AbstractString) {
                    sb.append(part.getStringValue());
                } else if (part == Keyword.WILD) {
                    sb.append('*');
                } else if (part == Keyword.WILD_INFERIORS) {
                    sb.append("**");
                } else if (part == Keyword.UP) {
                    sb.append("..");
                } else {
                    Lisp.error(new FileError("Unsupported directory component " + part.writeToString() + ".", this));
                }
                sb.append(';');
            }
        }
        return sb.toString();
    }

    public String writeToString() {
        LispThread thread = LispThread.currentThread();
        boolean printReadably = Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL;
        boolean printEscape = Symbol.PRINT_ESCAPE.symbolValue(thread) != Lisp.NIL;
        StringBuilder sb = new StringBuilder();
        if (printReadably || printEscape) {
            sb.append("#P\"");
        }
        sb.append(this.host.getStringValue());
        sb.append(':');
        if (this.directory != Lisp.NIL) {
            sb.append(this.getDirectoryNamestring());
        }
        if (this.name != Lisp.NIL) {
            if (this.name == Keyword.WILD) {
                sb.append('*');
            } else {
                sb.append(this.name.getStringValue());
            }
        }
        if (this.type != Lisp.NIL) {
            sb.append('.');
            if (this.type == Keyword.WILD) {
                sb.append('*');
            } else {
                sb.append(this.type.getStringValue());
            }
        }
        if (this.version.integerp()) {
            sb.append('.');
            int base = Fixnum.getValue(Symbol.PRINT_BASE.symbolValue(thread));
            if (this.version instanceof Fixnum) {
                sb.append(Integer.toString(((Fixnum)this.version).value, base).toUpperCase());
            } else if (this.version instanceof Bignum) {
                sb.append(((Bignum)this.version).value.toString(base).toUpperCase());
            }
        } else if (this.version == Keyword.WILD) {
            sb.append(".*");
        } else if (this.version == Keyword.NEWEST) {
            sb.append(".NEWEST");
        }
        if (printReadably || printEscape) {
            sb.append('\"');
        }
        return sb.toString();
    }

    private static class _make_logical_pathname
    extends Primitive {
        _make_logical_pathname() {
            super("%make-logical-pathname", Lisp.PACKAGE_SYS, true, "namestring");
        }

        public LispObject execute(LispObject arg) {
            String s = arg.getStringValue();
            String h = Pathname.getHostString(s);
            if (h != null) {
                if (h.length() == 0) {
                    return Lisp.error(new LispError("Invalid logical host name: \"" + h + '\"'));
                }
                if (Pathname.LOGICAL_PATHNAME_TRANSLATIONS.get(new SimpleString(h)) != null) {
                    return new LogicalPathname(h, s.substring(s.indexOf(58) + 1));
                }
            }
            return Lisp.error(new TypeError("Logical namestring does not specify a host: \"" + s + '\"'));
        }
    }

    private static class canonicalize_logical_host
    extends Primitive {
        canonicalize_logical_host() {
            super("canonicalize-logical-host", Lisp.PACKAGE_SYS, true, "host");
        }

        public LispObject execute(LispObject arg) {
            AbstractString s = Lisp.checkString(arg);
            if (s.length() == 0) {
                return Lisp.error(new LispError("Invalid logical host name: \"" + s.getStringValue() + '\"'));
            }
            return LogicalPathname.canonicalizeStringComponent(s);
        }
    }
}

