/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.Complex;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.FloatingPointOverflow;
import org.armedbear.lisp.FloatingPointUnderflow;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Ratio;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.Symbol;

public final class MathFunctions {
    private static final Primitive SIN = new Primitive("sin", "radians"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.sin(arg);
        }
    };
    private static final Primitive COS = new Primitive("cos", "radians"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.cos(arg);
        }
    };
    private static final Primitive TAN = new Primitive("tan", "radians"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof DoubleFloat) {
                return new DoubleFloat(Math.tan(((DoubleFloat)arg).value));
            }
            if (arg.realp()) {
                return new SingleFloat((float)Math.tan(SingleFloat.coerceToFloat((LispObject)arg).value));
            }
            return MathFunctions.sin(arg).divideBy(MathFunctions.cos(arg));
        }
    };
    private static final Primitive ASIN = new Primitive("asin", "number"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.asin(arg);
        }
    };
    private static final Primitive ACOS = new Primitive("acos", "number"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.acos(arg);
        }
    };
    private static final Primitive ATAN = new Primitive("atan", "number1 &optional number2"){

        public LispObject execute(LispObject arg) {
            if (arg.numberp()) {
                return MathFunctions.atan(arg);
            }
            return Lisp.type_error(arg, Symbol.NUMBER);
        }

        public LispObject execute(LispObject y, LispObject x) {
            if (!y.realp()) {
                return Lisp.type_error(y, Symbol.REAL);
            }
            if (!x.realp()) {
                return Lisp.type_error(x, Symbol.REAL);
            }
            double d1 = DoubleFloat.coerceToFloat((LispObject)y).value;
            double d2 = DoubleFloat.coerceToFloat((LispObject)x).value;
            double result = Math.atan2(d1, d2);
            if (y instanceof DoubleFloat || x instanceof DoubleFloat) {
                return new DoubleFloat(result);
            }
            return new SingleFloat((float)result);
        }
    };
    private static final Primitive SINH = new Primitive("sinh", "number"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.sinh(arg);
        }
    };
    private static final Primitive COSH = new Primitive("cosh", "number"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.cosh(arg);
        }
    };
    private static final Primitive TANH = new Primitive("tanh", "number"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat) {
                double d = Math.tanh(((SingleFloat)arg).value);
                return new SingleFloat((float)d);
            }
            if (arg instanceof DoubleFloat) {
                double d = Math.tanh(((DoubleFloat)arg).value);
                return new DoubleFloat(d);
            }
            return MathFunctions.sinh(arg).divideBy(MathFunctions.cosh(arg));
        }
    };
    private static final Primitive ASINH = new Primitive("asinh", "number"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.asinh(arg);
        }
    };
    private static final Primitive ACOSH = new Primitive("acosh", "number"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.acosh(arg);
        }
    };
    private static final Primitive ATANH = new Primitive("atanh", "number"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.atanh(arg);
        }
    };
    private static final Primitive CIS = new Primitive("cis", "radians"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.cis(arg);
        }
    };
    private static final Primitive EXP = new Primitive("exp", "number"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.exp(arg);
        }
    };
    private static final Primitive SQRT = new Primitive("sqrt", "number"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.sqrt(arg);
        }
    };
    private static final Primitive LOG = new Primitive("log", "number &optional base"){

        public LispObject execute(LispObject arg) {
            return MathFunctions.log(arg);
        }

        public LispObject execute(LispObject number, LispObject base) {
            if (number.realp() && !number.minusp() && base.isEqualTo(Fixnum.getInstance(10))) {
                double d = Math.log10(DoubleFloat.coerceToFloat((LispObject)number).value);
                if (number instanceof DoubleFloat || base instanceof DoubleFloat) {
                    return new DoubleFloat(d);
                }
                return new SingleFloat((float)d);
            }
            return MathFunctions.log(number).divideBy(MathFunctions.log(base));
        }
    };
    public static final Primitive EXPT = new Primitive("expt", "base-number power-number"){

        public LispObject execute(LispObject base, LispObject power) {
            double y;
            double x;
            if (power.zerop()) {
                if (power instanceof Fixnum) {
                    if (base instanceof SingleFloat) {
                        return SingleFloat.ONE;
                    }
                    if (base instanceof DoubleFloat) {
                        return DoubleFloat.ONE;
                    }
                    if (base instanceof Complex) {
                        if (((Complex)base).realpart instanceof SingleFloat) {
                            return Complex.getInstance(SingleFloat.ONE, SingleFloat.ZERO);
                        }
                        if (((Complex)base).realpart instanceof DoubleFloat) {
                            return Complex.getInstance(DoubleFloat.ONE, DoubleFloat.ZERO);
                        }
                    }
                    return Fixnum.ONE;
                }
                if (power instanceof DoubleFloat) {
                    return DoubleFloat.ONE;
                }
                if (base instanceof DoubleFloat) {
                    return DoubleFloat.ONE;
                }
                return SingleFloat.ONE;
            }
            if (base.zerop()) {
                return base;
            }
            if (base.isEqualTo(1)) {
                return base;
            }
            if ((power instanceof Fixnum || power instanceof Bignum) && (base.rationalp() || base instanceof Complex && ((Complex)base).realpart.rationalp())) {
                return MathFunctions.intexp(base, power);
            }
            boolean wantDoubleFloat = false;
            if (base instanceof DoubleFloat) {
                wantDoubleFloat = true;
            } else if (power instanceof DoubleFloat) {
                wantDoubleFloat = true;
            } else if (base instanceof Complex && (((Complex)base).getRealPart() instanceof DoubleFloat || ((Complex)base).getImaginaryPart() instanceof DoubleFloat)) {
                wantDoubleFloat = true;
            } else if (power instanceof Complex && (((Complex)power).getRealPart() instanceof DoubleFloat || ((Complex)power).getImaginaryPart() instanceof DoubleFloat)) {
                wantDoubleFloat = true;
            }
            if (wantDoubleFloat) {
                power = power instanceof Complex ? ((Complex)power).coerceToDoubleFloat() : DoubleFloat.coerceToFloat(power);
                base = base instanceof Complex ? ((Complex)base).coerceToDoubleFloat() : DoubleFloat.coerceToFloat(base);
            }
            if (base instanceof Complex || power instanceof Complex) {
                return MathFunctions.exp(power.multiplyBy(MathFunctions.log(base)));
            }
            if (base instanceof Fixnum) {
                x = ((Fixnum)base).value;
            } else if (base instanceof Bignum) {
                x = ((Bignum)base).doubleValue();
            } else if (base instanceof Ratio) {
                x = ((Ratio)base).doubleValue();
            } else if (base instanceof SingleFloat) {
                x = ((SingleFloat)base).value;
            } else if (base instanceof DoubleFloat) {
                x = ((DoubleFloat)base).value;
            } else {
                return Lisp.error(new LispError("EXPT: unsupported case: base is of type " + base.typeOf().writeToString()));
            }
            if (power instanceof Fixnum) {
                y = ((Fixnum)power).value;
            } else if (power instanceof Bignum) {
                y = ((Bignum)power).doubleValue();
            } else if (power instanceof Ratio) {
                y = ((Ratio)power).doubleValue();
            } else if (power instanceof SingleFloat) {
                y = ((SingleFloat)power).value;
            } else if (power instanceof DoubleFloat) {
                y = ((DoubleFloat)power).value;
            } else {
                return Lisp.error(new LispError("EXPT: unsupported case: power is of type " + power.typeOf().writeToString()));
            }
            double r = Math.pow(x, y);
            if (Double.isNaN(r) && x < 0.0) {
                r = Math.pow(-x, y);
                double realPart = r * Math.cos(y * Math.PI);
                double imagPart = r * Math.sin(y * Math.PI);
                if (base instanceof DoubleFloat || power instanceof DoubleFloat) {
                    return Complex.getInstance(MathFunctions.OverUnderFlowCheck(new DoubleFloat(realPart)), MathFunctions.OverUnderFlowCheck(new DoubleFloat(imagPart)));
                }
                return Complex.getInstance(MathFunctions.OverUnderFlowCheck(new SingleFloat((float)realPart)), MathFunctions.OverUnderFlowCheck(new SingleFloat((float)imagPart)));
            }
            if (base instanceof DoubleFloat || power instanceof DoubleFloat) {
                return MathFunctions.OverUnderFlowCheck(new DoubleFloat(r));
            }
            return MathFunctions.OverUnderFlowCheck(new SingleFloat((float)r));
        }
    };

    private static final LispObject complexToRealFixup(LispObject result, LispObject arg) {
        Complex c;
        LispObject im;
        if (result instanceof Complex && !(arg instanceof Complex) && (im = (c = (Complex)result).getImaginaryPart()).zerop()) {
            return c.getRealPart();
        }
        return result;
    }

    static LispObject sin(LispObject arg) {
        if (arg instanceof DoubleFloat) {
            return new DoubleFloat(Math.sin(((DoubleFloat)arg).value));
        }
        if (arg.realp()) {
            return new SingleFloat((float)Math.sin(SingleFloat.coerceToFloat((LispObject)arg).value));
        }
        if (arg instanceof Complex) {
            LispObject n = arg.multiplyBy(Complex.getInstance(Fixnum.ZERO, Fixnum.ONE));
            LispObject result = MathFunctions.exp(n);
            result = result.subtract(MathFunctions.exp(n.multiplyBy(Fixnum.MINUS_ONE)));
            return result.divideBy(Fixnum.TWO.multiplyBy(Complex.getInstance(Fixnum.ZERO, Fixnum.ONE)));
        }
        return Lisp.type_error(arg, Symbol.NUMBER);
    }

    static LispObject cos(LispObject arg) {
        if (arg instanceof DoubleFloat) {
            return new DoubleFloat(Math.cos(((DoubleFloat)arg).value));
        }
        if (arg.realp()) {
            return new SingleFloat((float)Math.cos(SingleFloat.coerceToFloat((LispObject)arg).value));
        }
        if (arg instanceof Complex) {
            LispObject n = arg.multiplyBy(Complex.getInstance(Fixnum.ZERO, Fixnum.ONE));
            LispObject result = MathFunctions.exp(n);
            result = result.add(MathFunctions.exp(n.multiplyBy(Fixnum.MINUS_ONE)));
            return result.divideBy(Fixnum.TWO);
        }
        return Lisp.type_error(arg, Symbol.NUMBER);
    }

    static LispObject asin(LispObject arg) {
        double d;
        float f;
        if (arg instanceof SingleFloat && Math.abs(f = ((SingleFloat)arg).value) <= 1.0f) {
            return new SingleFloat((float)Math.asin(f));
        }
        if (arg instanceof DoubleFloat && Math.abs(d = ((DoubleFloat)arg).value) <= 1.0) {
            return new DoubleFloat(Math.asin(d));
        }
        LispObject result = arg.multiplyBy(arg);
        result = Fixnum.ONE.subtract(result);
        result = MathFunctions.sqrt(result);
        LispObject n = Complex.getInstance(Fixnum.ZERO, Fixnum.ONE);
        n = n.multiplyBy(arg);
        result = n.add(result);
        result = MathFunctions.log(result);
        result = result.multiplyBy(Complex.getInstance(Fixnum.ZERO, Fixnum.MINUS_ONE));
        return MathFunctions.complexToRealFixup(result, arg);
    }

    static LispObject acos(LispObject arg) {
        float f;
        double d;
        if (arg instanceof DoubleFloat && Math.abs(d = ((DoubleFloat)arg).value) <= 1.0) {
            return new DoubleFloat(Math.acos(d));
        }
        if (arg instanceof SingleFloat && Math.abs(f = ((SingleFloat)arg).value) <= 1.0f) {
            return new SingleFloat((float)Math.acos(f));
        }
        LispObject result = new DoubleFloat(1.5707963267948966);
        if (!(arg instanceof DoubleFloat || arg instanceof Complex && ((Complex)arg).getRealPart() instanceof DoubleFloat)) {
            result = new SingleFloat((float)result.value);
        }
        result = ((LispObject)result).subtract(MathFunctions.asin(arg));
        return MathFunctions.complexToRealFixup(result, arg);
    }

    static LispObject atan(LispObject arg) {
        if (arg instanceof Complex) {
            LispObject im = ((Complex)arg).imagpart;
            if (im.zerop()) {
                return Complex.getInstance(MathFunctions.atan(((Complex)arg).realpart), im);
            }
            LispObject result = arg.multiplyBy(arg);
            result = result.add(Fixnum.ONE);
            result = Fixnum.ONE.divideBy(result);
            result = MathFunctions.sqrt(result);
            LispObject n = Complex.getInstance(Fixnum.ZERO, Fixnum.ONE);
            n = n.multiplyBy(arg);
            n = n.add(Fixnum.ONE);
            result = n.multiplyBy(result);
            result = MathFunctions.log(result);
            result = result.multiplyBy(Complex.getInstance(Fixnum.ZERO, Fixnum.MINUS_ONE));
            return result;
        }
        if (arg instanceof DoubleFloat) {
            return new DoubleFloat(Math.atan(((DoubleFloat)arg).value));
        }
        return new SingleFloat((float)Math.atan(SingleFloat.coerceToFloat((LispObject)arg).value));
    }

    static LispObject sinh(LispObject arg) {
        LispObject im;
        if (arg instanceof Complex && (im = ((Complex)arg).getImaginaryPart()).zerop()) {
            return Complex.getInstance(MathFunctions.sinh(((Complex)arg).getRealPart()), im);
        }
        if (arg instanceof SingleFloat) {
            double d = Math.sinh(((SingleFloat)arg).value);
            return new SingleFloat((float)d);
        }
        if (arg instanceof DoubleFloat) {
            double d = Math.sinh(((DoubleFloat)arg).value);
            return new DoubleFloat(d);
        }
        LispObject result = MathFunctions.exp(arg);
        result = result.subtract(MathFunctions.exp(arg.multiplyBy(Fixnum.MINUS_ONE)));
        result = result.divideBy(Fixnum.TWO);
        return MathFunctions.complexToRealFixup(result, arg);
    }

    static LispObject cosh(LispObject arg) {
        LispObject im;
        if (arg instanceof Complex && (im = ((Complex)arg).getImaginaryPart()).zerop()) {
            return Complex.getInstance(MathFunctions.cosh(((Complex)arg).getRealPart()), im);
        }
        if (arg instanceof SingleFloat) {
            double d = Math.cosh(((SingleFloat)arg).value);
            return new SingleFloat((float)d);
        }
        if (arg instanceof DoubleFloat) {
            double d = Math.cosh(((DoubleFloat)arg).value);
            return new DoubleFloat(d);
        }
        LispObject result = MathFunctions.exp(arg);
        result = result.add(MathFunctions.exp(arg.multiplyBy(Fixnum.MINUS_ONE)));
        result = result.divideBy(Fixnum.TWO);
        return MathFunctions.complexToRealFixup(result, arg);
    }

    static LispObject asinh(LispObject arg) {
        LispObject im;
        if (arg instanceof Complex && (im = ((Complex)arg).getImaginaryPart()).zerop()) {
            return Complex.getInstance(MathFunctions.asinh(((Complex)arg).getRealPart()), im);
        }
        LispObject result = arg.multiplyBy(arg);
        result = Fixnum.ONE.add(result);
        result = MathFunctions.sqrt(result);
        result = result.add(arg);
        result = MathFunctions.log(result);
        return MathFunctions.complexToRealFixup(result, arg);
    }

    static LispObject acosh(LispObject arg) {
        LispObject im;
        if (arg instanceof Complex && (im = ((Complex)arg).getImaginaryPart()).zerop()) {
            return Complex.getInstance(MathFunctions.acosh(((Complex)arg).getRealPart()), im);
        }
        LispObject n1 = arg.add(Fixnum.ONE);
        n1 = n1.divideBy(Fixnum.TWO);
        n1 = MathFunctions.sqrt(n1);
        LispObject n2 = arg.subtract(Fixnum.ONE);
        n2 = n2.divideBy(Fixnum.TWO);
        n2 = MathFunctions.sqrt(n2);
        LispObject result = n1.add(n2);
        result = MathFunctions.log(result);
        result = result.multiplyBy(Fixnum.TWO);
        return MathFunctions.complexToRealFixup(result, arg);
    }

    static LispObject atanh(LispObject arg) {
        LispObject im;
        if (arg instanceof Complex && (im = ((Complex)arg).getImaginaryPart()).zerop()) {
            return Complex.getInstance(MathFunctions.atanh(((Complex)arg).getRealPart()), im);
        }
        LispObject n1 = MathFunctions.log(Fixnum.ONE.add(arg));
        LispObject n2 = MathFunctions.log(Fixnum.ONE.subtract(arg));
        LispObject result = n1.subtract(n2);
        result = result.divideBy(Fixnum.TWO);
        return MathFunctions.complexToRealFixup(result, arg);
    }

    static LispObject cis(LispObject arg) {
        if (arg.realp()) {
            return Complex.getInstance(MathFunctions.cos(arg), MathFunctions.sin(arg));
        }
        return Lisp.type_error(arg, Symbol.REAL);
    }

    static LispObject exp(LispObject arg) {
        if (arg.realp()) {
            if (arg instanceof DoubleFloat) {
                double d = Math.pow(Math.E, ((DoubleFloat)arg).value);
                return MathFunctions.OverUnderFlowCheck(new DoubleFloat(d));
            }
            float f = (float)Math.pow(Math.E, SingleFloat.coerceToFloat((LispObject)arg).value);
            return MathFunctions.OverUnderFlowCheck(new SingleFloat(f));
        }
        if (arg instanceof Complex) {
            Complex c = (Complex)arg;
            return MathFunctions.exp(c.getRealPart()).multiplyBy(MathFunctions.cis(c.getImaginaryPart()));
        }
        return Lisp.type_error(arg, Symbol.NUMBER);
    }

    static final LispObject sqrt(LispObject obj) {
        if (obj instanceof DoubleFloat) {
            if (obj.minusp()) {
                return Complex.getInstance(new DoubleFloat(0.0), MathFunctions.sqrt(obj.negate()));
            }
            return new DoubleFloat(Math.sqrt(DoubleFloat.coerceToFloat((LispObject)obj).value));
        }
        if (obj.realp()) {
            if (obj.minusp()) {
                return Complex.getInstance(new SingleFloat(0.0f), MathFunctions.sqrt(obj.negate()));
            }
            return new SingleFloat((float)Math.sqrt(SingleFloat.coerceToFloat((LispObject)obj).value));
        }
        if (obj instanceof Complex) {
            LispObject imagpart = ((Complex)obj).imagpart;
            if (imagpart.zerop()) {
                LispObject realpart = ((Complex)obj).realpart;
                if (realpart.minusp()) {
                    return Complex.getInstance(imagpart, MathFunctions.sqrt(realpart.negate()));
                }
                return Complex.getInstance(MathFunctions.sqrt(realpart), imagpart);
            }
            return MathFunctions.exp(MathFunctions.log(obj).divideBy(Fixnum.TWO));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    static final LispObject log(LispObject obj) {
        if (obj.realp() && !obj.minusp()) {
            if (obj instanceof Fixnum) {
                return new SingleFloat((float)Math.log(((Fixnum)obj).value));
            }
            if (obj instanceof Bignum) {
                return new SingleFloat((float)Math.log(((Bignum)obj).doubleValue()));
            }
            if (obj instanceof Ratio) {
                return new SingleFloat((float)Math.log(((Ratio)obj).doubleValue()));
            }
            if (obj instanceof SingleFloat) {
                return new SingleFloat((float)Math.log(((SingleFloat)obj).value));
            }
            if (obj instanceof DoubleFloat) {
                return new DoubleFloat(Math.log(((DoubleFloat)obj).value));
            }
        } else {
            if (obj.realp() && obj.minusp()) {
                if (obj instanceof DoubleFloat) {
                    DoubleFloat re = DoubleFloat.coerceToFloat(obj);
                    DoubleFloat abs = new DoubleFloat(Math.abs(re.value));
                    DoubleFloat phase = new DoubleFloat(Math.PI);
                    return Complex.getInstance(new DoubleFloat(Math.log(abs.getValue())), phase);
                }
                SingleFloat re = SingleFloat.coerceToFloat(obj);
                SingleFloat abs = new SingleFloat(Math.abs(re.value));
                SingleFloat phase = new SingleFloat((float)Math.PI);
                return Complex.getInstance(new SingleFloat((float)Math.log(abs.value)), phase);
            }
            if (obj instanceof Complex) {
                if (((Complex)obj).getRealPart() instanceof DoubleFloat) {
                    DoubleFloat re = DoubleFloat.coerceToFloat(((Complex)obj).getRealPart());
                    DoubleFloat im = DoubleFloat.coerceToFloat(((Complex)obj).getImaginaryPart());
                    DoubleFloat phase = new DoubleFloat(Math.atan2(im.getValue(), re.getValue()));
                    DoubleFloat abs = DoubleFloat.coerceToFloat(obj.ABS());
                    return Complex.getInstance(new DoubleFloat(Math.log(abs.getValue())), phase);
                }
                SingleFloat re = SingleFloat.coerceToFloat(((Complex)obj).getRealPart());
                SingleFloat im = SingleFloat.coerceToFloat(((Complex)obj).getImaginaryPart());
                SingleFloat phase = new SingleFloat((float)Math.atan2(im.value, re.value));
                SingleFloat abs = SingleFloat.coerceToFloat(obj.ABS());
                return Complex.getInstance(new SingleFloat((float)Math.log(abs.value)), phase);
            }
        }
        Lisp.type_error(obj, Symbol.NUMBER);
        return Lisp.NIL;
    }

    static final LispObject OverUnderFlowCheck(LispObject number) {
        if (number instanceof Complex) {
            MathFunctions.OverUnderFlowCheck(((Complex)number).realpart);
            MathFunctions.OverUnderFlowCheck(((Complex)number).imagpart);
            return number;
        }
        if (Lisp.TRAP_OVERFLOW) {
            if (number instanceof SingleFloat && Float.isInfinite(((SingleFloat)number).value)) {
                return Lisp.error(new FloatingPointOverflow(Lisp.NIL));
            }
            if (number instanceof DoubleFloat && Double.isInfinite(((DoubleFloat)number).value)) {
                return Lisp.error(new FloatingPointOverflow(Lisp.NIL));
            }
        }
        if (Lisp.TRAP_UNDERFLOW && number.zerop()) {
            return Lisp.error(new FloatingPointUnderflow(Lisp.NIL));
        }
        return number;
    }

    static final float OverUnderFlowCheck(float number) {
        if (Lisp.TRAP_OVERFLOW && Float.isInfinite(number)) {
            Lisp.error(new FloatingPointOverflow(Lisp.NIL));
        }
        if (Lisp.TRAP_UNDERFLOW && number == 0.0f) {
            Lisp.error(new FloatingPointUnderflow(Lisp.NIL));
        }
        return number;
    }

    public static final double OverUnderFlowCheck(double number) {
        if (Lisp.TRAP_OVERFLOW && Double.isInfinite(number)) {
            Lisp.error(new FloatingPointOverflow(Lisp.NIL));
        }
        if (Lisp.TRAP_UNDERFLOW && number == 0.0) {
            Lisp.error(new FloatingPointUnderflow(Lisp.NIL));
        }
        return number;
    }

    static final LispObject intexp(LispObject base, LispObject power) {
        if (power.isEqualTo(0)) {
            return Fixnum.ONE;
        }
        if (base.isEqualTo(1)) {
            return base;
        }
        if (base.isEqualTo(0)) {
            return base;
        }
        if (power.minusp()) {
            power = Fixnum.ZERO.subtract(power);
            return Fixnum.ONE.divideBy(MathFunctions.intexp(base, power));
        }
        if (base.eql(Fixnum.TWO)) {
            return Fixnum.ONE.ash(power);
        }
        LispObject nextn = power.ash(Fixnum.MINUS_ONE);
        LispObject total = power.oddp() ? base : Fixnum.ONE;
        while (!nextn.zerop()) {
            base = base.multiplyBy(base);
            if (nextn.oddp()) {
                total = base.multiplyBy(total);
            }
            nextn = nextn.ash(Fixnum.MINUS_ONE);
        }
        return total;
    }
}

