/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class NilVector
extends AbstractString {
    private int capacity;

    public NilVector(int capacity) {
        this.capacity = capacity;
    }

    public char[] chars() {
        if (this.capacity != 0) {
            this.accessError();
        }
        return new char[0];
    }

    public char[] getStringChars() {
        if (this.capacity != 0) {
            this.accessError();
        }
        return new char[0];
    }

    public String getStringValue() {
        if (this.capacity != 0) {
            this.accessError();
        }
        return "";
    }

    public LispObject typeOf() {
        return Lisp.list(Symbol.NIL_VECTOR, Fixnum.getInstance(this.capacity));
    }

    public LispObject classOf() {
        return BuiltInClass.NIL_VECTOR;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.NIL_VECTOR) {
            return Lisp.T;
        }
        if (type == Symbol.SIMPLE_STRING) {
            return Lisp.T;
        }
        if (type == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.NIL_VECTOR) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_STRING) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public LispObject SIMPLE_STRING_P() {
        return Lisp.T;
    }

    public boolean equal(LispObject obj) {
        if (obj instanceof NilVector) {
            if (this.capacity != ((NilVector)obj).capacity) {
                return false;
            }
            if (this.capacity != 0) {
                this.accessError();
                return false;
            }
            return true;
        }
        if (obj instanceof AbstractString) {
            if (this.capacity != obj.length()) {
                return false;
            }
            if (this.capacity != 0) {
                this.accessError();
                return false;
            }
            return true;
        }
        return false;
    }

    public String getValue() {
        if (this.capacity == 0) {
            return "";
        }
        this.accessError();
        return null;
    }

    public int length() {
        return this.capacity;
    }

    public int capacity() {
        return this.capacity;
    }

    public LispObject getElementType() {
        return Lisp.NIL;
    }

    public LispObject CHAR(int index) {
        return this.accessError();
    }

    public LispObject SCHAR(int index) {
        return this.accessError();
    }

    public LispObject AREF(int index) {
        return this.accessError();
    }

    public void aset(int index, LispObject newValue) {
        this.storeError(newValue);
    }

    public char charAt(int index) {
        this.accessError();
        return '\u0000';
    }

    public void setCharAt(int index, char c) {
        this.storeError(LispCharacter.getInstance(c));
    }

    public LispObject subseq(int start, int end) {
        if (this.capacity == 0 && start == 0 && end == 0) {
            return this;
        }
        return this.accessError();
    }

    public void fill(LispObject obj) {
        this.storeError(obj);
    }

    public void fill(char c) {
        this.storeError(LispCharacter.getInstance(c));
    }

    public void shrink(int n) {
    }

    public LispObject reverse() {
        return this.accessError();
    }

    public LispObject accessError() {
        return Lisp.error(new TypeError("Attempt to access an array of element type NIL."));
    }

    private void storeError(LispObject obj) {
        Lisp.error(new TypeError(String.valueOf(obj) + " is not of type NIL."));
    }

    public String toString() {
        return this.unreadableString("NIL-VECTOR");
    }

    public int sxhash() {
        return 0;
    }

    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        this.accessError();
        return null;
    }

    public AbstractVector adjustArray(int size, AbstractArray displacedTo, int displacement) {
        this.accessError();
        return null;
    }
}

