/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.LinkedList;
import org.armedbear.lisp.Autoload;
import org.armedbear.lisp.Binding;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Closure;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Nil;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.SpecialBinding;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.StandardGenericFunction;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.SymbolMacro;
import org.armedbear.lisp.UndefinedFunction;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class SpecialOperators {
    private static final SpecialOperator QUOTE = new sf_quote();
    private static final SpecialOperator IF = new sf_if();
    private static final SpecialOperator LET = new sf_let();
    private static final SpecialOperator LET_STAR = new sf_let_star();
    private static final SpecialOperator SYMBOL_MACROLET = new sf_symbol_macrolet();
    private static final SpecialOperator LOAD_TIME_VALUE = new sf_load_time_value();
    private static final SpecialOperator LOCALLY = new sf_locally();
    private static final SpecialOperator PROGN = new sf_progn();
    private static final SpecialOperator FLET = new sf_flet();
    private static final SpecialOperator LABELS = new sf_labels();
    private static final SpecialOperator THE = new sf_the();
    private static final SpecialOperator PROGV = new sf_progv();
    private static final SpecialOperator DECLARE = new sf_declare();
    private static final SpecialOperator FUNCTION = new sf_function();
    private static final SpecialOperator SETQ = new sf_setq();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final LispObject _let(LispObject args, Environment env, boolean sequential) {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        try {
            LispObject varList = Lisp.checkList(args.car());
            LispObject bodyAndDecls = Lisp.parseBody(args.cdr(), false);
            LispObject specials = Lisp.parseSpecials(bodyAndDecls.NTH(1));
            LispObject body = bodyAndDecls.car();
            Environment ext = new Environment(env);
            LinkedList<Cons> nonSequentialVars = new LinkedList<Cons>();
            while (varList != Lisp.NIL) {
                LispObject value;
                Symbol symbol;
                LispObject obj = varList.car();
                if (obj instanceof Cons) {
                    if (obj.length() > 2) {
                        LispObject lispObject = Lisp.error(new LispError("The " + (sequential ? "LET*" : "LET") + " binding specification " + obj.writeToString() + " is invalid."));
                        return lispObject;
                    }
                    symbol = Lisp.checkSymbol(((Cons)obj).car);
                    value = Lisp.eval(obj.cadr(), sequential ? ext : env, thread);
                } else {
                    symbol = Lisp.checkSymbol(obj);
                    value = Lisp.NIL;
                }
                if (sequential) {
                    ext = new Environment(ext);
                    Lisp.bindArg(specials, symbol, value, ext, thread);
                } else {
                    nonSequentialVars.add(new Cons(symbol, value));
                }
                varList = ((Cons)varList).cdr;
            }
            if (!sequential) {
                for (Cons x : nonSequentialVars) {
                    Lisp.bindArg(specials, (Symbol)x.car(), x.cdr(), ext, thread);
                }
            }
            while (specials != Lisp.NIL) {
                ext.declareSpecial((Symbol)specials.car());
                specials = specials.cdr();
            }
            LispObject lispObject = Lisp.progn(body, ext, thread);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final LispObject _flet(LispObject args, Environment env, boolean recursive) {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        Environment funEnv = new Environment(env);
        for (LispObject defs = Lisp.checkList(args.car()); defs != Lisp.NIL; defs = defs.cdr()) {
            Symbol symbol;
            LispObject def = Lisp.checkList(defs.car());
            LispObject name = def.car();
            if (name instanceof Symbol) {
                symbol = Lisp.checkSymbol(name);
                if (symbol.getSymbolFunction() instanceof SpecialOperator) {
                    String message = symbol.getName() + " is a special operator and may not be redefined";
                    return Lisp.error(new ProgramError(message));
                }
            } else if (Lisp.isValidSetfFunctionName(name)) {
                symbol = Lisp.checkSymbol(name.cadr());
            } else {
                return Lisp.type_error(name, Lisp.FUNCTION_NAME);
            }
            LispObject rest = def.cdr();
            LispObject parameters = rest.car();
            LispObject body = rest.cdr();
            LispObject decls = Lisp.NIL;
            while (body.car() instanceof Cons && body.car().car() == Symbol.DECLARE) {
                decls = new Cons(body.car(), decls);
                body = body.cdr();
            }
            body = new Cons(symbol, body);
            body = new Cons(Symbol.BLOCK, body);
            body = new Cons(body, Lisp.NIL);
            while (decls != Lisp.NIL) {
                body = new Cons(decls.car(), body);
                decls = decls.cdr();
            }
            Cons lambda_expression = new Cons(Symbol.LAMBDA, (LispObject)new Cons(parameters, body));
            Cons lambda_name = Lisp.list(recursive ? Symbol.LABELS : Symbol.FLET, name);
            Closure closure = new Closure(lambda_name, lambda_expression, recursive ? funEnv : env);
            funEnv.addFunctionBinding(name, closure);
        }
        try {
            Environment ext = new Environment(funEnv);
            LispObject body = args.cdr();
            body = ext.processDeclarations(body);
            LispObject lispObject = Lisp.progn(body, ext, thread);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    private static final class sf_setq
    extends SpecialOperator {
        sf_setq() {
            super(Symbol.SETQ, "&rest vars-and-values");
        }

        public LispObject execute(LispObject args, Environment env) {
            LispObject value = Nil.NIL;
            LispThread thread = LispThread.currentThread();
            while (args != Lisp.NIL) {
                Cons form;
                LispObject expansion;
                Object binding;
                Symbol symbol = Lisp.checkSymbol(args.car());
                if (symbol.isConstant()) {
                    return Lisp.error(new ProgramError(symbol.writeToString() + " is a constant and thus cannot be set."));
                }
                args = args.cdr();
                if (symbol.isSpecialVariable() || env.isDeclaredSpecial(symbol)) {
                    binding = thread.getSpecialBinding(symbol);
                    if (binding != null) {
                        if (((SpecialBinding)binding).value instanceof SymbolMacro) {
                            expansion = ((SymbolMacro)((SpecialBinding)binding).value).getExpansion();
                            form = Lisp.list(Symbol.SETF, expansion, args.car());
                            value = Lisp.eval(form, env, thread);
                        } else {
                            value = Lisp.eval(args.car(), env, thread);
                            ((SpecialBinding)binding).value = value;
                        }
                    } else if (symbol.getSymbolValue() instanceof SymbolMacro) {
                        expansion = ((SymbolMacro)symbol.getSymbolValue()).getExpansion();
                        form = Lisp.list(Symbol.SETF, expansion, args.car());
                        value = Lisp.eval(form, env, thread);
                    } else {
                        value = Lisp.eval(args.car(), env, thread);
                        symbol.setSymbolValue(value);
                    }
                } else {
                    binding = env.getBinding(symbol);
                    if (binding != null) {
                        if (((Binding)binding).value instanceof SymbolMacro) {
                            expansion = ((SymbolMacro)((Binding)binding).value).getExpansion();
                            form = Lisp.list(Symbol.SETF, expansion, args.car());
                            value = Lisp.eval(form, env, thread);
                        } else {
                            value = Lisp.eval(args.car(), env, thread);
                            ((Binding)binding).value = value;
                        }
                    } else if (symbol.getSymbolValue() instanceof SymbolMacro) {
                        expansion = ((SymbolMacro)symbol.getSymbolValue()).getExpansion();
                        form = Lisp.list(Symbol.SETF, expansion, args.car());
                        value = Lisp.eval(form, env, thread);
                    } else {
                        value = Lisp.eval(args.car(), env, thread);
                        symbol.setSymbolValue(value);
                    }
                }
                args = args.cdr();
            }
            thread._values = null;
            return value;
        }
    }

    private static final class sf_function
    extends SpecialOperator {
        sf_function() {
            super(Symbol.FUNCTION, "thing");
        }

        public LispObject execute(LispObject args, Environment env) {
            LispObject arg = args.car();
            if (arg instanceof Symbol) {
                LispObject operator = env.lookupFunction(arg);
                if (operator instanceof Autoload) {
                    Autoload autoload = (Autoload)operator;
                    autoload.load();
                    operator = autoload.getSymbol().getSymbolFunction();
                }
                if (operator instanceof Function) {
                    return operator;
                }
                if (operator instanceof StandardGenericFunction) {
                    return operator;
                }
                return Lisp.error(new UndefinedFunction(arg));
            }
            if (arg instanceof Cons) {
                LispObject car = ((Cons)arg).car;
                if (car == Symbol.SETF) {
                    LispObject f = env.lookupFunction(arg);
                    if (f != null) {
                        return f;
                    }
                    Symbol symbol = Lisp.checkSymbol(arg.cadr());
                    f = Lisp.get(symbol, Symbol.SETF_FUNCTION, null);
                    if (f != null) {
                        return f;
                    }
                    f = Lisp.get(symbol, Symbol.SETF_INVERSE, null);
                    if (f != null) {
                        return f;
                    }
                }
                if (car == Symbol.LAMBDA) {
                    return new Closure(arg, env);
                }
                if (car == Symbol.NAMED_LAMBDA) {
                    LispObject name = arg.cadr();
                    if (name instanceof Symbol || Lisp.isValidSetfFunctionName(name)) {
                        return new Closure(name, new Cons(Symbol.LAMBDA, arg.cddr()), env);
                    }
                    return Lisp.type_error(name, Lisp.FUNCTION_NAME);
                }
            }
            return Lisp.error(new UndefinedFunction(Lisp.list(Keyword.NAME, arg)));
        }
    }

    private static final class sf_declare
    extends SpecialOperator {
        sf_declare() {
            super(Symbol.DECLARE, "&rest declaration-specifiers");
        }

        public LispObject execute(LispObject args, Environment env) {
            return Lisp.NIL;
        }
    }

    private static final class sf_progv
    extends SpecialOperator {
        sf_progv() {
            super(Symbol.PROGV, "symbols values &body body");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LispObject execute(LispObject args, Environment env) {
            if (args.length() < 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispThread thread = LispThread.currentThread();
            LispObject symbols = Lisp.checkList(Lisp.eval(args.car(), env, thread));
            LispObject values = Lisp.checkList(Lisp.eval(args.cadr(), env, thread));
            SpecialBindingsMark mark = thread.markSpecialBindings();
            try {
                Lisp.progvBindVars(symbols, values, thread);
                LispObject lispObject = Lisp.progn(args.cdr().cdr(), env, thread);
                return lispObject;
            }
            finally {
                thread.resetSpecialBindings(mark);
            }
        }
    }

    private static final class sf_the
    extends SpecialOperator {
        sf_the() {
            super(Symbol.THE, "type value");
        }

        public LispObject execute(LispObject args, Environment env) {
            if (args.length() != 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispObject rv = Lisp.eval(args.cadr(), env, LispThread.currentThread());
            LispObject type = args.car();
            if ((type instanceof Symbol && Lisp.get(type, Symbol.DEFTYPE_DEFINITION) == Lisp.NIL || type instanceof BuiltInClass) && rv.typep(type) == Lisp.NIL) {
                Lisp.type_error(rv, type);
            }
            return rv;
        }
    }

    private static final class sf_labels
    extends SpecialOperator {
        sf_labels() {
            super(Symbol.LABELS, "definitions &body body");
        }

        public LispObject execute(LispObject args, Environment env) {
            return SpecialOperators._flet(args, env, true);
        }
    }

    private static final class sf_flet
    extends SpecialOperator {
        sf_flet() {
            super(Symbol.FLET, "definitions &body body");
        }

        public LispObject execute(LispObject args, Environment env) {
            return SpecialOperators._flet(args, env, false);
        }
    }

    private static final class sf_progn
    extends SpecialOperator {
        sf_progn() {
            super(Symbol.PROGN, "&rest forms");
        }

        public LispObject execute(LispObject args, Environment env) {
            LispThread thread = LispThread.currentThread();
            return Lisp.progn(args, env, thread);
        }
    }

    private static final class sf_locally
    extends SpecialOperator {
        sf_locally() {
            super(Symbol.LOCALLY, "&body body");
        }

        public LispObject execute(LispObject args, Environment env) {
            LispThread thread = LispThread.currentThread();
            Environment ext = new Environment(env);
            args = ext.processDeclarations(args);
            return Lisp.progn(args, ext, thread);
        }
    }

    private static final class sf_load_time_value
    extends SpecialOperator {
        sf_load_time_value() {
            super(Symbol.LOAD_TIME_VALUE, "form &optional read-only-p");
        }

        public LispObject execute(LispObject args, Environment env) {
            switch (args.length()) {
                case 1: 
                case 2: {
                    return Lisp.eval(args.car(), new Environment(), LispThread.currentThread());
                }
            }
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }
    }

    private static final class sf_symbol_macrolet
    extends SpecialOperator {
        sf_symbol_macrolet() {
            super(Symbol.SYMBOL_MACROLET, "macrobindings &body body");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LispObject execute(LispObject args, Environment env) {
            LispObject varList = Lisp.checkList(args.car());
            LispThread thread = LispThread.currentThread();
            SpecialBindingsMark mark = thread.markSpecialBindings();
            Environment ext = new Environment(env);
            try {
                LispObject body = ext.processDeclarations(args.cdr());
                int i = varList.length();
                while (i-- > 0) {
                    Symbol symbol;
                    LispObject obj = varList.car();
                    varList = varList.cdr();
                    if (obj instanceof Cons && obj.length() == 2) {
                        symbol = Lisp.checkSymbol(obj.car());
                        if (symbol.isSpecialVariable() || ext.isDeclaredSpecial(symbol)) {
                            LispObject lispObject = Lisp.error(new ProgramError("Attempt to bind the special variable " + symbol.writeToString() + " with SYMBOL-MACROLET."));
                            return lispObject;
                        }
                    } else {
                        LispObject lispObject = Lisp.error(new ProgramError("Malformed symbol-expansion pair in SYMBOL-MACROLET: " + obj.writeToString()));
                        return lispObject;
                    }
                    Lisp.bindArg(null, symbol, new SymbolMacro(obj.cadr()), ext, thread);
                }
                LispObject lispObject = Lisp.progn(body, ext, thread);
                return lispObject;
            }
            finally {
                thread.resetSpecialBindings(mark);
            }
        }
    }

    private static final class sf_let_star
    extends SpecialOperator {
        sf_let_star() {
            super(Symbol.LET_STAR, "bindings &body body");
        }

        public LispObject execute(LispObject args, Environment env) {
            if (args == Lisp.NIL) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            return SpecialOperators._let(args, env, true);
        }
    }

    private static final class sf_let
    extends SpecialOperator {
        sf_let() {
            super(Symbol.LET, "bindings &body body");
        }

        public LispObject execute(LispObject args, Environment env) {
            if (args == Lisp.NIL) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            return SpecialOperators._let(args, env, false);
        }
    }

    private static final class sf_if
    extends SpecialOperator {
        sf_if() {
            super(Symbol.IF, "test then &optional else");
        }

        public LispObject execute(LispObject args, Environment env) {
            LispThread thread = LispThread.currentThread();
            switch (args.length()) {
                case 2: {
                    if (Lisp.eval(((Cons)args).car, env, thread) != Lisp.NIL) {
                        return Lisp.eval(args.cadr(), env, thread);
                    }
                    thread.clearValues();
                    return Lisp.NIL;
                }
                case 3: {
                    if (Lisp.eval(((Cons)args).car, env, thread) != Lisp.NIL) {
                        return Lisp.eval(args.cadr(), env, thread);
                    }
                    return Lisp.eval(((Cons)args).cdr.cadr(), env, thread);
                }
            }
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }
    }

    private static final class sf_quote
    extends SpecialOperator {
        sf_quote() {
            super(Symbol.QUOTE, "thing");
        }

        public LispObject execute(LispObject args, Environment env) {
            if (args.cdr() != Lisp.NIL) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            return args.car();
        }
    }
}

