/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.concurrent.ConcurrentHashMap;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.StandardMethod;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.Symbol;

public final class StandardGenericFunction
extends StandardObject {
    LispObject function;
    int numberOfRequiredArgs;
    ConcurrentHashMap<CacheEntry, LispObject> cache;
    ConcurrentHashMap<LispObject, LispObject> slotCache;
    private int callCount;
    private int hotCount;
    private static final Primitive _GENERIC_FUNCTION_NAME = new Primitive("%generic-function-name", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[0];
        }
    };
    private static final Primitive _SET_GENERIC_FUNCTION_NAME = new Primitive("%set-generic-function-name", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[0] = second;
            return second;
        }
    };
    private static final Primitive _GENERIC_FUNCTION_LAMBDA_LIST = new Primitive("%generic-function-lambda-list", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[1];
        }
    };
    private static final Primitive _SET_GENERIC_FUNCTION_LAMBDA_LIST = new Primitive("%set-generic-function-lambda-list", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[1] = second;
            return second;
        }
    };
    private static final Primitive FUNCALLABLE_INSTANCE_FUNCTION = new Primitive("funcallable-instance-function", Lisp.PACKAGE_MOP, false, "funcallable-instance"){

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).function;
        }
    };
    private static final Primitive SET_FUNCALLABLE_INSTANCE_FUNCTION = new Primitive("set-funcallable-instance-function", Lisp.PACKAGE_MOP, true, "funcallable-instance function"){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).function = second;
            return second;
        }
    };
    private static final Primitive GF_REQUIRED_ARGS = new Primitive("gf-required-args", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[2];
        }
    };
    private static final Primitive _SET_GF_REQUIRED_ARGS = new Primitive("%set-gf-required-args", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            gf.slots[2] = second;
            gf.numberOfRequiredArgs = second.length();
            return second;
        }
    };
    private static final Primitive GENERIC_FUNCTION_INITIAL_METHODS = new Primitive("generic-function-initial-methods", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[3];
        }
    };
    private static final Primitive SET_GENERIC_FUNCTION_INITIAL_METHODS = new Primitive("set-generic-function-initial-methods", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[3] = second;
            return second;
        }
    };
    private static final Primitive GENERIC_FUNCTION_METHODS = new Primitive("generic-function-methods", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[4];
        }
    };
    private static final Primitive SET_GENERIC_FUNCTION_METHODS = new Primitive("set-generic-function-methods", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[4] = second;
            return second;
        }
    };
    private static final Primitive GENERIC_FUNCTION_METHOD_CLASS = new Primitive("generic-function-method-class", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[5];
        }
    };
    private static final Primitive SET_GENERIC_FUNCTION_METHOD_CLASS = new Primitive("set-generic-function-method-class", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[5] = second;
            return second;
        }
    };
    private static final Primitive GENERIC_FUNCTION_METHOD_COMBINATION = new Primitive("generic-function-method-combination", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[6];
        }
    };
    private static final Primitive SET_GENERIC_FUNCTION_METHOD_COMBINATION = new Primitive("set-generic-function-method-combination", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[6] = second;
            return second;
        }
    };
    private static final Primitive GENERIC_FUNCTION_ARGUMENT_PRECEDENCE_ORDER = new Primitive("generic-function-argument-precedence-order", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[7];
        }
    };
    private static final Primitive SET_GENERIC_FUNCTION_ARGUMENT_PRECEDENCE_ORDER = new Primitive("set-generic-function-argument-precedence-order", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[7] = second;
            return second;
        }
    };
    private static final Primitive GENERIC_FUNCTION_CLASSES_TO_EMF_TABLE = new Primitive("generic-function-classes-to-emf-table", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[8];
        }
    };
    private static final Primitive SET_GENERIC_FUNCTION_CLASSES_TO_EMF_TABLE = new Primitive("set-generic-function-classes-to-emf-table", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[8] = second;
            return second;
        }
    };
    private static final Primitive GENERIC_FUNCTION_DOCUMENTATION = new Primitive("generic-function-documentation", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[9];
        }
    };
    private static final Primitive SET_GENERIC_FUNCTION_DOCUMENTATION = new Primitive("set-generic-function-documentation", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[9] = second;
            return second;
        }
    };
    private static final Primitive _FINALIZE_GENERIC_FUNCTION = new Primitive("%finalize-generic-function", Lisp.PACKAGE_SYS, true, "generic-function"){

        public LispObject execute(LispObject arg) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(arg);
            gf.finalizeInternal();
            return Lisp.T;
        }
    };
    private static final Primitive CACHE_EMF = new Primitive("cache-emf", Lisp.PACKAGE_SYS, true, "generic-function args emf"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            LispObject args = second;
            LispObject[] array = new LispObject[gf.numberOfRequiredArgs];
            int i = gf.numberOfRequiredArgs;
            while (i-- > 0) {
                array[i] = gf.getArgSpecialization(args.car());
                args = args.cdr();
            }
            CacheEntry specializations = new CacheEntry(array);
            ConcurrentHashMap<CacheEntry, LispObject> ht = gf.cache;
            if (ht == null) {
                ht = gf.cache = new ConcurrentHashMap();
            }
            ht.put(specializations, third);
            return third;
        }
    };
    private static final Primitive GET_CACHED_EMF = new Primitive("get-cached-emf", Lisp.PACKAGE_SYS, true, "generic-function args"){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            LispObject args = second;
            LispObject[] array = new LispObject[gf.numberOfRequiredArgs];
            int i = gf.numberOfRequiredArgs;
            while (i-- > 0) {
                array[i] = gf.getArgSpecialization(args.car());
                args = args.cdr();
            }
            CacheEntry specializations = new CacheEntry(array);
            ConcurrentHashMap<CacheEntry, LispObject> ht = gf.cache;
            if (ht == null) {
                return Lisp.NIL;
            }
            LispObject emf = ht.get(specializations);
            return emf != null ? emf : Lisp.NIL;
        }
    };
    private static final Primitive _GET_ARG_SPECIALIZATION = new Primitive("%get-arg-specialization", Lisp.PACKAGE_SYS, true, "generic-function arg"){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            return gf.getArgSpecialization(second);
        }
    };
    private static final Primitive CACHE_SLOT_LOCATION = new Primitive("cache-slot-location", Lisp.PACKAGE_SYS, true, "generic-function layout location"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            LispObject layout = second;
            LispObject location = third;
            ConcurrentHashMap<LispObject, LispObject> ht = gf.slotCache;
            if (ht == null) {
                ht = gf.slotCache = new ConcurrentHashMap();
            }
            ht.put(layout, location);
            return third;
        }
    };
    private static final Primitive GET_CACHED_SLOT_LOCATION = new Primitive("get-cached-slot-location", Lisp.PACKAGE_SYS, true, "generic-function layout"){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            LispObject layout = second;
            ConcurrentHashMap<LispObject, LispObject> ht = gf.slotCache;
            if (ht == null) {
                return Lisp.NIL;
            }
            LispObject location = ht.get(layout);
            return location != null ? location : Lisp.NIL;
        }
    };
    private static final StandardGenericFunction GENERIC_FUNCTION_NAME = new StandardGenericFunction("generic-function-name", Lisp.PACKAGE_MOP, true, _GENERIC_FUNCTION_NAME, Lisp.list(Symbol.GENERIC_FUNCTION, new LispObject[0]), Lisp.list(StandardClass.STANDARD_GENERIC_FUNCTION, new LispObject[0]));
    EqlSpecialization[] eqlSpecializations = new EqlSpecialization[0];
    private static final Primitive _INIT_EQL_SPECIALIZATIONS = new Primitive("%init-eql-specializations", Lisp.PACKAGE_SYS, true, "generic-function eql-specilizer-objects-list"){

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            LispObject eqlSpecializerObjects = second;
            gf.eqlSpecializations = new EqlSpecialization[eqlSpecializerObjects.length()];
            for (int i = 0; i < gf.eqlSpecializations.length; ++i) {
                gf.eqlSpecializations[i] = new EqlSpecialization(eqlSpecializerObjects.car());
                eqlSpecializerObjects = eqlSpecializerObjects.cdr();
            }
            return Lisp.NIL;
        }
    };

    public StandardGenericFunction() {
        super(StandardClass.STANDARD_GENERIC_FUNCTION, StandardClass.STANDARD_GENERIC_FUNCTION.getClassLayout().getLength());
    }

    public StandardGenericFunction(String name, Package pkg, boolean exported, Function function, LispObject lambdaList, LispObject specializers) {
        this();
        Symbol symbol = exported ? pkg.internAndExport(name.toUpperCase()) : pkg.intern(name.toUpperCase());
        symbol.setSymbolFunction(this);
        this.function = function;
        this.slots[0] = symbol;
        this.slots[1] = lambdaList;
        this.slots[2] = lambdaList;
        this.numberOfRequiredArgs = lambdaList.length();
        this.slots[3] = Lisp.NIL;
        StandardMethod method = new StandardMethod(this, function, lambdaList, specializers);
        this.slots[4] = Lisp.list(method, new LispObject[0]);
        this.slots[5] = StandardClass.STANDARD_METHOD;
        this.slots[6] = Symbol.STANDARD;
        this.slots[7] = Lisp.NIL;
        this.slots[8] = Lisp.NIL;
        this.slots[9] = Lisp.NIL;
    }

    void finalizeInternal() {
        this.cache = null;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.COMPILED_FUNCTION) {
            if (this.function != null) {
                return this.function.typep(type);
            }
            return Lisp.NIL;
        }
        if (type == Symbol.STANDARD_GENERIC_FUNCTION) {
            return Lisp.T;
        }
        if (type == StandardClass.STANDARD_GENERIC_FUNCTION) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public LispObject getGenericFunctionName() {
        return this.slots[0];
    }

    public void setGenericFunctionName(LispObject name) {
        this.slots[0] = name;
    }

    public LispObject execute() {
        return this.function.execute();
    }

    public LispObject execute(LispObject arg) {
        return this.function.execute(arg);
    }

    public LispObject execute(LispObject first, LispObject second) {
        return this.function.execute(first, second);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        return this.function.execute(first, second, third);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
        return this.function.execute(first, second, third, fourth);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        return this.function.execute(first, second, third, fourth, fifth);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        return this.function.execute(first, second, third, fourth, fifth, sixth);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        return this.function.execute(first, second, third, fourth, fifth, sixth, seventh);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        return this.function.execute(first, second, third, fourth, fifth, sixth, seventh, eighth);
    }

    public LispObject execute(LispObject[] args) {
        return this.function.execute(args);
    }

    public String writeToString() {
        LispObject name = this.getGenericFunctionName();
        if (name != null) {
            StringBuilder sb = new StringBuilder();
            LispObject lispClass = this.getLispClass();
            LispObject className = lispClass instanceof LispClass ? ((LispClass)lispClass).getName() : Symbol.CLASS_NAME.execute(lispClass);
            sb.append(className.writeToString());
            sb.append(' ');
            sb.append(name.writeToString());
            return this.unreadableString(sb.toString());
        }
        return super.writeToString();
    }

    public final int getCallCount() {
        return this.callCount;
    }

    public void setCallCount(int n) {
        this.callCount = n;
    }

    public final void incrementCallCount() {
        ++this.callCount;
    }

    public final int getHotCount() {
        return this.hotCount;
    }

    public void setHotCount(int n) {
        this.hotCount = n;
    }

    public final void incrementHotCount() {
        ++this.hotCount;
    }

    LispObject getArgSpecialization(LispObject arg) {
        for (EqlSpecialization eqlSpecialization : this.eqlSpecializations) {
            if (!eqlSpecialization.eqlTo.eql(arg)) continue;
            return eqlSpecialization;
        }
        return arg.classOf();
    }

    public static final StandardGenericFunction checkStandardGenericFunction(LispObject obj) {
        if (obj instanceof StandardGenericFunction) {
            return (StandardGenericFunction)obj;
        }
        return (StandardGenericFunction)Lisp.type_error(obj, Symbol.STANDARD_GENERIC_FUNCTION);
    }

    private static class EqlSpecialization
    extends LispObject {
        public LispObject eqlTo;

        public EqlSpecialization(LispObject eqlTo) {
            this.eqlTo = eqlTo;
        }
    }

    private static class CacheEntry {
        final LispObject[] array;

        CacheEntry(LispObject[] array) {
            this.array = array;
        }

        public int hashCode() {
            int result = 0;
            int i = this.array.length;
            while (i-- > 0) {
                result ^= this.array[i].hashCode();
            }
            return result;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CacheEntry)) {
                return false;
            }
            CacheEntry otherEntry = (CacheEntry)object;
            if (otherEntry.array.length != this.array.length) {
                return false;
            }
            LispObject[] otherArray = otherEntry.array;
            int i = this.array.length;
            while (i-- > 0) {
                if (this.array[i] == otherArray[i]) continue;
                return false;
            }
            return true;
        }
    }
}

