/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Function;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.StandardGenericFunction;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.Symbol;

public class StandardMethod
extends StandardObject {
    private static final Primitive METHOD_LAMBDA_LIST = new Primitive("method-lambda-list", Lisp.PACKAGE_SYS, true, "method"){

        public LispObject execute(LispObject arg) {
            return StandardMethod.checkStandardMethod((LispObject)arg).slots[1];
        }
    };
    private static final Primitive SET_METHOD_LAMBDA_LIST = new Primitive("set-method-lambda-list", Lisp.PACKAGE_SYS, true, "method lambda-list"){

        public LispObject execute(LispObject first, LispObject second) {
            StandardMethod.checkStandardMethod((LispObject)first).slots[1] = second;
            return second;
        }
    };
    private static final Primitive _METHOD_QUALIFIERS = new Primitive("%method-qualifiers", Lisp.PACKAGE_SYS, true, "method"){

        public LispObject execute(LispObject arg) {
            return StandardMethod.checkStandardMethod((LispObject)arg).slots[3];
        }
    };
    private static final Primitive SET_METHOD_QUALIFIERS = new Primitive("set-method-qualifiers", Lisp.PACKAGE_SYS, true, "method qualifiers"){

        public LispObject execute(LispObject first, LispObject second) {
            StandardMethod.checkStandardMethod((LispObject)first).slots[3] = second;
            return second;
        }
    };
    private static final Primitive METHOD_DOCUMENTATION = new Primitive("method-documentation", Lisp.PACKAGE_SYS, true, "method"){

        public LispObject execute(LispObject arg) {
            return StandardMethod.checkStandardMethod((LispObject)arg).slots[6];
        }
    };
    private static final Primitive SET_METHOD_DOCUMENTATION = new Primitive("set-method-documentation", Lisp.PACKAGE_SYS, true, "method documentation"){

        public LispObject execute(LispObject first, LispObject second) {
            StandardMethod.checkStandardMethod((LispObject)first).slots[6] = second;
            return second;
        }
    };
    private static final Primitive _METHOD_GENERIC_FUNCTION = new Primitive("%method-generic-function", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return StandardMethod.checkStandardMethod((LispObject)arg).slots[0];
        }
    };
    private static final Primitive _SET_METHOD_GENERICFUNCTION = new Primitive("%set-method-generic-function", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            StandardMethod.checkStandardMethod((LispObject)first).slots[0] = second;
            return second;
        }
    };
    private static final Primitive _METHOD_FUNCTION = new Primitive("%method-function", Lisp.PACKAGE_SYS, true, "method"){

        public LispObject execute(LispObject arg) {
            return StandardMethod.checkStandardMethod((LispObject)arg).slots[4];
        }
    };
    private static final Primitive _SET_METHOD_FUNCTION = new Primitive("%set-method-function", Lisp.PACKAGE_SYS, true, "method function"){

        public LispObject execute(LispObject first, LispObject second) {
            StandardMethod.checkStandardMethod((LispObject)first).slots[4] = second;
            return second;
        }
    };
    private static final Primitive _METHOD_FAST_FUNCTION = new Primitive("%method-fast-function", Lisp.PACKAGE_SYS, true, "method"){

        public LispObject execute(LispObject arg) {
            return StandardMethod.checkStandardMethod((LispObject)arg).slots[5];
        }
    };
    private static final Primitive _SET_METHOD_FAST_FUNCTION = new Primitive("%set-method-fast-function", Lisp.PACKAGE_SYS, true, "method fast-function"){

        public LispObject execute(LispObject first, LispObject second) {
            StandardMethod.checkStandardMethod((LispObject)first).slots[5] = second;
            return second;
        }
    };
    private static final Primitive _METHOD_SPECIALIZERS = new Primitive("%method-specializers", Lisp.PACKAGE_SYS, true, "method"){

        public LispObject execute(LispObject arg) {
            return StandardMethod.checkStandardMethod((LispObject)arg).slots[2];
        }
    };
    private static final Primitive _SET_METHOD_SPECIALIZERS = new Primitive("%set-method-specializers", Lisp.PACKAGE_SYS, true, "method specializers"){

        public LispObject execute(LispObject first, LispObject second) {
            StandardMethod.checkStandardMethod((LispObject)first).slots[2] = second;
            return second;
        }
    };
    private static final StandardGenericFunction METHOD_SPECIALIZERS = new StandardGenericFunction("method-specializers", Lisp.PACKAGE_MOP, true, _METHOD_SPECIALIZERS, Lisp.list(Symbol.METHOD, new LispObject[0]), Lisp.list(StandardClass.STANDARD_METHOD, new LispObject[0]));
    private static final StandardGenericFunction METHOD_QUALIFIERS = new StandardGenericFunction("method-qualifiers", Lisp.PACKAGE_MOP, true, _METHOD_QUALIFIERS, Lisp.list(Symbol.METHOD, new LispObject[0]), Lisp.list(StandardClass.STANDARD_METHOD, new LispObject[0]));

    public StandardMethod() {
        super(StandardClass.STANDARD_METHOD, StandardClass.STANDARD_METHOD.getClassLayout().getLength());
    }

    protected StandardMethod(LispClass cls, int length) {
        super(cls, length);
    }

    public StandardMethod(StandardGenericFunction gf, Function fastFunction, LispObject lambdaList, LispObject specializers) {
        this();
        this.slots[0] = gf;
        this.slots[1] = lambdaList;
        this.slots[2] = specializers;
        this.slots[3] = Lisp.NIL;
        this.slots[4] = Lisp.NIL;
        this.slots[5] = fastFunction;
        this.slots[6] = Lisp.NIL;
    }

    public LispObject getFunction() {
        return this.slots[4];
    }

    public String writeToString() {
        LispObject name;
        LispObject genericFunction = this.slots[0];
        if (genericFunction instanceof StandardGenericFunction && (name = ((StandardGenericFunction)genericFunction).getGenericFunctionName()) != null) {
            StringBuilder sb = new StringBuilder();
            LispObject lispClass = this.getLispClass();
            LispObject className = lispClass instanceof LispClass ? ((LispClass)lispClass).getName() : Symbol.CLASS_NAME.execute(lispClass);
            sb.append(className.writeToString());
            sb.append(' ');
            sb.append(name.writeToString());
            LispObject specializers = this.slots[2];
            if (specializers != null) {
                LispObject names = Lisp.NIL;
                for (LispObject specs = specializers; specs != Lisp.NIL; specs = specs.cdr()) {
                    LispObject spec = specs.car();
                    names = spec instanceof LispClass ? names.push(((LispClass)spec).getName()) : names.push(spec);
                }
                sb.append(' ');
                sb.append(names.nreverse().writeToString());
            }
            return this.unreadableString(sb.toString());
        }
        return super.writeToString();
    }

    public static final StandardMethod checkStandardMethod(LispObject first) {
        if (first instanceof StandardMethod) {
            return (StandardMethod)first;
        }
        return (StandardMethod)Lisp.type_error(first, Symbol.METHOD);
    }
}

