/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Layout;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.Symbol;

public class StandardObjectFunctions {
    private static final Primitive _STD_ALLOCATE_INSTANCE = new Primitive("%std-allocate-instance", Lisp.PACKAGE_SYS, true, "class"){

        public LispObject execute(LispObject arg) {
            if (arg == StandardClass.STANDARD_CLASS) {
                return new StandardClass();
            }
            if (arg instanceof StandardClass) {
                return ((StandardClass)arg).allocateInstance();
            }
            if (arg.typep(StandardClass.STANDARD_CLASS) != Lisp.NIL) {
                LispObject l = Symbol.CLASS_LAYOUT.execute(arg);
                if (!(l instanceof Layout)) {
                    return Lisp.error(new ProgramError("Invalid standard class layout for: " + arg.writeToString()));
                }
                return new StandardObject((Layout)l);
            }
            return Lisp.type_error(arg, Symbol.STANDARD_CLASS);
        }
    };
}

