/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleVector;
import org.armedbear.lisp.StorageCondition;
import org.armedbear.lisp.StringOutputStream;
import org.armedbear.lisp.StructureClass;
import org.armedbear.lisp.Symbol;

public class StructureObject
extends LispObject {
    private final StructureClass structureClass;
    final LispObject[] slots;
    private static final Primitive STRUCTURE_OBJECT_P = new Primitive("structure-object-p", Lisp.PACKAGE_SYS, true, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof StructureObject ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive STRUCTURE_LENGTH = new Primitive("structure-length", Lisp.PACKAGE_SYS, true, "instance"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof StructureObject) {
                return Fixnum.getInstance(((StructureObject)arg).slots.length);
            }
            return Lisp.type_error(arg, Symbol.STRUCTURE_OBJECT);
        }
    };
    private static final Primitive STRUCTURE_REF = new Primitive("structure-ref", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof StructureObject) {
                try {
                    return ((StructureObject)first).slots[Fixnum.getValue(second)];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return Lisp.error(new LispError("Internal error."));
                }
            }
            return Lisp.type_error(first, Symbol.STRUCTURE_OBJECT);
        }
    };
    private static final Primitive STRUCTURE_SET = new Primitive("structure-set", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first instanceof StructureObject) {
                try {
                    ((StructureObject)first).slots[Fixnum.getValue((LispObject)second)] = third;
                    return third;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return Lisp.error(new LispError("Internal error."));
                }
            }
            return Lisp.type_error(first, Symbol.STRUCTURE_OBJECT);
        }
    };
    private static final Primitive MAKE_STRUCTURE = new Primitive("make-structure", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            return new StructureObject(Lisp.checkSymbol(first), second);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return new StructureObject(Lisp.checkSymbol(first), second, third);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            return new StructureObject(Lisp.checkSymbol(first), second, third, fourth);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
            return new StructureObject(Lisp.checkSymbol(first), second, third, fourth, fifth);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
            return new StructureObject(Lisp.checkSymbol(first), second, third, fourth, fifth, sixth);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
            return new StructureObject(Lisp.checkSymbol(first), second, third, fourth, fifth, sixth, seventh);
        }
    };
    private static final Primitive _MAKE_STRUCTURE = new Primitive("%make-structure", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            return new StructureObject(Lisp.checkSymbol(first), second.copyToArray());
        }
    };
    private static final Primitive COPY_STRUCTURE = new Primitive(Symbol.COPY_STRUCTURE, "structure"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof StructureObject) {
                return new StructureObject((StructureObject)arg);
            }
            return Lisp.type_error(arg, Symbol.STRUCTURE_OBJECT);
        }
    };

    public StructureObject(Symbol symbol) {
        this.structureClass = (StructureClass)LispClass.findClass(symbol);
        if (this.structureClass == null) {
            System.err.println("No mitens sitten: " + BuiltInClass.SYSTEM_STREAM.toString());
            System.err.println("joopa joo:" + Symbol.SYSTEM_STREAM.name);
            System.err.println("Oh noes, structure object got a null class:" + symbol.toString() + ", symbol name:" + symbol.name);
        }
        this.slots = new LispObject[0];
    }

    public StructureObject(Symbol symbol, LispObject[] slots) {
        this.structureClass = (StructureClass)LispClass.findClass(symbol);
        this.slots = slots;
    }

    public StructureObject(Symbol symbol, LispObject obj0) {
        this.structureClass = (StructureClass)LispClass.findClass(symbol);
        LispObject[] slots = new LispObject[]{obj0};
        this.slots = slots;
    }

    public StructureObject(Symbol symbol, LispObject obj0, LispObject obj1) {
        this.structureClass = (StructureClass)LispClass.findClass(symbol);
        LispObject[] slots = new LispObject[]{obj0, obj1};
        this.slots = slots;
    }

    public StructureObject(Symbol symbol, LispObject obj0, LispObject obj1, LispObject obj2) {
        this.structureClass = (StructureClass)LispClass.findClass(symbol);
        LispObject[] slots = new LispObject[]{obj0, obj1, obj2};
        this.slots = slots;
    }

    public StructureObject(Symbol symbol, LispObject obj0, LispObject obj1, LispObject obj2, LispObject obj3) {
        this.structureClass = (StructureClass)LispClass.findClass(symbol);
        LispObject[] slots = new LispObject[]{obj0, obj1, obj2, obj3};
        this.slots = slots;
    }

    public StructureObject(Symbol symbol, LispObject obj0, LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4) {
        this.structureClass = (StructureClass)LispClass.findClass(symbol);
        LispObject[] slots = new LispObject[]{obj0, obj1, obj2, obj3, obj4};
        this.slots = slots;
    }

    public StructureObject(Symbol symbol, LispObject obj0, LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4, LispObject obj5) {
        this.structureClass = (StructureClass)LispClass.findClass(symbol);
        LispObject[] slots = new LispObject[]{obj0, obj1, obj2, obj3, obj4, obj5};
        this.slots = slots;
    }

    public StructureObject(StructureObject obj) {
        this.structureClass = obj.structureClass;
        this.slots = new LispObject[obj.slots.length];
        int i = this.slots.length;
        while (i-- > 0) {
            this.slots[i] = obj.slots[i];
        }
    }

    public LispObject typeOf() {
        return this.structureClass.getName();
    }

    public LispObject classOf() {
        return this.structureClass;
    }

    protected int getSlotIndex(LispObject slotName) {
        LispObject effectiveSlots = this.structureClass.getSlotDefinitions();
        LispObject[] effectiveSlotsArray = effectiveSlots.copyToArray();
        for (int i = 0; i < this.slots.length; ++i) {
            SimpleVector slotDefinition = (SimpleVector)effectiveSlotsArray[i];
            LispObject candidateSlotName = slotDefinition.AREF(1);
            if (slotName != candidateSlotName) continue;
            return i;
        }
        return -1;
    }

    public LispObject SLOT_VALUE(LispObject slotName) {
        LispObject value;
        int index = this.getSlotIndex(slotName);
        if (index >= 0) {
            value = this.slots[index];
        } else {
            value = Lisp.UNBOUND_VALUE;
            value = Symbol.SLOT_UNBOUND.execute(this.structureClass, this, slotName);
            LispThread.currentThread()._values = null;
        }
        return value;
    }

    public void setSlotValue(LispObject slotName, LispObject newValue) {
        int index = this.getSlotIndex(slotName);
        if (index >= 0) {
            this.slots[index] = newValue;
        } else {
            LispObject[] args = new LispObject[]{this.structureClass, this, slotName, Symbol.SETF, newValue};
            Symbol.SLOT_MISSING.execute(args);
        }
    }

    public LispObject getParts() {
        LispObject result = Lisp.NIL;
        result = result.push(new Cons("class", (LispObject)this.structureClass));
        LispObject effectiveSlots = this.structureClass.getSlotDefinitions();
        LispObject[] effectiveSlotsArray = effectiveSlots.copyToArray();
        Debug.assertTrue(effectiveSlotsArray.length == this.slots.length);
        for (int i = 0; i < this.slots.length; ++i) {
            SimpleVector slotDefinition = (SimpleVector)effectiveSlotsArray[i];
            LispObject slotName = slotDefinition.AREF(1);
            result = result.push(new Cons(slotName, this.slots[i]));
        }
        return result.nreverse();
    }

    public LispObject typep(LispObject type) {
        LispClass c;
        if (type instanceof StructureClass) {
            return Lisp.memq(type, this.structureClass.getCPL()) ? Lisp.T : Lisp.NIL;
        }
        if (type == this.structureClass.getName()) {
            return Lisp.T;
        }
        if (type == Symbol.STRUCTURE_OBJECT) {
            return Lisp.T;
        }
        if (type == BuiltInClass.STRUCTURE_OBJECT) {
            return Lisp.T;
        }
        if (type instanceof Symbol && (c = LispClass.findClass((Symbol)type)) != null) {
            return Lisp.memq(c, this.structureClass.getCPL()) ? Lisp.T : Lisp.NIL;
        }
        return super.typep(type);
    }

    public boolean equalp(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StructureObject) {
            StructureObject o = (StructureObject)obj;
            if (this.structureClass != o.structureClass) {
                return false;
            }
            for (int i = 0; i < this.slots.length; ++i) {
                if (this.slots[i].equalp(o.slots[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public LispObject getSlotValue_0() {
        try {
            return this.slots[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.badIndex(0);
        }
    }

    public LispObject getSlotValue_1() {
        try {
            return this.slots[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.badIndex(1);
        }
    }

    public LispObject getSlotValue_2() {
        try {
            return this.slots[2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.badIndex(2);
        }
    }

    public LispObject getSlotValue_3() {
        try {
            return this.slots[3];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.badIndex(3);
        }
    }

    public LispObject getSlotValue(int index) {
        try {
            return this.slots[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.badIndex(index);
        }
    }

    public int getFixnumSlotValue(int index) {
        try {
            return Fixnum.getValue(this.slots[index]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index);
            return 0;
        }
    }

    public boolean getSlotValueAsBoolean(int index) {
        try {
            return this.slots[index] != Lisp.NIL;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index);
            return false;
        }
    }

    public void setSlotValue_0(LispObject value) {
        try {
            this.slots[0] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(0);
        }
    }

    public void setSlotValue_1(LispObject value) {
        try {
            this.slots[1] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(1);
        }
    }

    public void setSlotValue_2(LispObject value) {
        try {
            this.slots[2] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(2);
        }
    }

    public void setSlotValue_3(LispObject value) {
        try {
            this.slots[3] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(3);
        }
    }

    public void setSlotValue(int index, LispObject value) {
        try {
            this.slots[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index);
        }
    }

    private LispObject badIndex(int n) {
        StringBuilder sb = new StringBuilder("Invalid slot index ");
        sb.append(Fixnum.getInstance(n).writeToString());
        sb.append(" for ");
        sb.append(this.writeToString());
        return Lisp.error(new LispError(sb.toString()));
    }

    public final int psxhash() {
        return this.psxhash(4);
    }

    public final int psxhash(int depth) {
        int result = Lisp.mix(this.structureClass.sxhash(), 7814971L);
        if (depth > 0) {
            int limit = this.slots.length;
            if (limit > 4) {
                limit = 4;
            }
            for (int i = 0; i < limit; ++i) {
                result = Lisp.mix(this.slots[i].psxhash(depth - 1), result);
            }
        }
        return result & Integer.MAX_VALUE;
    }

    public String writeToString() {
        try {
            LispObject currentPrintLevel;
            int currentLevel;
            LispThread thread = LispThread.currentThread();
            if (this.typep(Symbol.RESTART) != Lisp.NIL) {
                Symbol PRINT_RESTART = Lisp.PACKAGE_SYS.intern("PRINT-RESTART");
                LispObject fun = PRINT_RESTART.getSymbolFunction();
                StringOutputStream stream = new StringOutputStream();
                thread.execute(fun, this, stream);
                return stream.getString().getStringValue();
            }
            if (Lisp._PRINT_STRUCTURE_.symbolValue(thread) == Lisp.NIL) {
                return this.unreadableString(this.structureClass.getName().writeToString());
            }
            int maxLevel = Integer.MAX_VALUE;
            LispObject printLevel = Symbol.PRINT_LEVEL.symbolValue(thread);
            if (printLevel instanceof Fixnum) {
                maxLevel = ((Fixnum)printLevel).value;
            }
            if ((currentLevel = Fixnum.getValue(currentPrintLevel = Lisp._CURRENT_PRINT_LEVEL_.symbolValue(thread))) >= maxLevel && this.slots.length > 0) {
                return "#";
            }
            StringBuilder sb = new StringBuilder("#S(");
            sb.append(this.structureClass.getName().writeToString());
            if (currentLevel < maxLevel) {
                LispObject effectiveSlots = this.structureClass.getSlotDefinitions();
                LispObject[] effectiveSlotsArray = effectiveSlots.copyToArray();
                Debug.assertTrue(effectiveSlotsArray.length == this.slots.length);
                LispObject printLength = Symbol.PRINT_LENGTH.symbolValue(thread);
                int limit = printLength instanceof Fixnum ? Math.min(this.slots.length, ((Fixnum)printLength).value) : this.slots.length;
                boolean printCircle = Symbol.PRINT_CIRCLE.symbolValue(thread) != Lisp.NIL;
                for (int i = 0; i < limit; ++i) {
                    sb.append(' ');
                    SimpleVector slotDefinition = (SimpleVector)effectiveSlotsArray[i];
                    LispObject slotName = slotDefinition.AREF(1);
                    Debug.assertTrue(slotName instanceof Symbol);
                    sb.append(':');
                    sb.append(((Symbol)slotName).name.getStringValue());
                    sb.append(' ');
                    if (printCircle) {
                        StringOutputStream stream = new StringOutputStream();
                        thread.execute(Symbol.OUTPUT_OBJECT.getSymbolFunction(), this.slots[i], stream);
                        sb.append(stream.getString().getStringValue());
                        continue;
                    }
                    sb.append(this.slots[i].writeToString());
                }
                if (limit < this.slots.length) {
                    sb.append(" ...");
                }
            }
            sb.append(')');
            return sb.toString();
        }
        catch (StackOverflowError e) {
            Lisp.error(new StorageCondition("Stack overflow."));
            return null;
        }
    }
}

