/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class SynonymStream
extends Stream {
    final Symbol symbol;
    private static final Primitive MAKE_SYNONYM_STREAM = new Primitive("make-synonym-stream", "symbol"){

        public LispObject execute(LispObject arg) {
            return new SynonymStream(Lisp.checkSymbol(arg));
        }
    };
    private static final Primitive SYNONYM_STREAM_STREAMS = new Primitive("synonym-stream-symbol", "synonym-stream"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SynonymStream) {
                return ((SynonymStream)arg).symbol;
            }
            return Lisp.error(new TypeError(arg, Symbol.SYNONYM_STREAM));
        }
    };

    SynonymStream(Symbol symbol) {
        super(Symbol.SYNONYM_STREAM);
        this.symbol = symbol;
    }

    public boolean isInputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isInputStream();
    }

    public boolean isOutputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isOutputStream();
    }

    public boolean isCharacterInputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isCharacterInputStream();
    }

    public boolean isBinaryInputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isBinaryInputStream();
    }

    public boolean isCharacterOutputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isCharacterOutputStream();
    }

    public boolean isBinaryOutputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isBinaryOutputStream();
    }

    public LispObject typeOf() {
        return Symbol.SYNONYM_STREAM;
    }

    public LispObject classOf() {
        return BuiltInClass.SYNONYM_STREAM;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.SYNONYM_STREAM) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.SYNONYM_STREAM) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    public LispObject getElementType() {
        return Lisp.checkStream(this.symbol.symbolValue()).getElementType();
    }

    public LispObject listen() {
        return Lisp.checkStream(this.symbol.symbolValue()).listen();
    }

    public LispObject fileLength() {
        return Lisp.checkStream(this.symbol.symbolValue()).fileLength();
    }

    public LispObject fileStringLength(LispObject arg) {
        return Lisp.checkStream(this.symbol.symbolValue()).fileStringLength(arg);
    }

    protected int _readChar() throws IOException {
        return Lisp.checkStream(this.symbol.symbolValue())._readChar();
    }

    protected void _unreadChar(int n) throws IOException {
        Lisp.checkStream(this.symbol.symbolValue())._unreadChar(n);
    }

    protected boolean _charReady() throws IOException {
        return Lisp.checkStream(this.symbol.symbolValue())._charReady();
    }

    public void _writeChar(char c) {
        Lisp.checkStream(this.symbol.symbolValue())._writeChar(c);
    }

    public void _writeChars(char[] chars, int start, int end) {
        Lisp.checkStream(this.symbol.symbolValue())._writeChars(chars, start, end);
    }

    public void _writeString(String s) {
        Lisp.checkStream(this.symbol.symbolValue())._writeString(s);
    }

    public void _writeLine(String s) {
        Lisp.checkStream(this.symbol.symbolValue())._writeLine(s);
    }

    public int _readByte() {
        return Lisp.checkStream(this.symbol.symbolValue())._readByte();
    }

    public void _writeByte(int n) {
        Lisp.checkStream(this.symbol.symbolValue())._writeByte(n);
    }

    public void _finishOutput() {
        Lisp.checkStream(this.symbol.symbolValue())._finishOutput();
    }

    public void _clearInput() {
        Lisp.checkStream(this.symbol.symbolValue())._clearInput();
    }

    protected long _getFilePosition() {
        return Lisp.checkStream(this.symbol.symbolValue())._getFilePosition();
    }

    protected boolean _setFilePosition(LispObject arg) {
        return Lisp.checkStream(this.symbol.symbolValue())._setFilePosition(arg);
    }

    public void _close() {
        Lisp.checkStream(this.symbol.symbolValue())._close();
    }

    public String writeToString() {
        StringBuffer sb = new StringBuffer("SYNONYM-STREAM ");
        sb.append(this.symbol.writeToString());
        return this.unreadableString(sb.toString());
    }
}

