/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.StandardClass;

public final class WrongNumberOfArgumentsException
extends ProgramError {
    private Operator operator;
    private int expectedArgs;
    private String message;

    public WrongNumberOfArgumentsException(Operator operator) {
        this(operator, -1);
    }

    public WrongNumberOfArgumentsException(Operator operator, int expectedArgs) {
        super(StandardClass.PROGRAM_ERROR);
        this.operator = operator;
        this.expectedArgs = expectedArgs;
        this.setFormatControl(this.getMessage());
        this.setFormatArguments(Lisp.NIL);
    }

    public WrongNumberOfArgumentsException(String message) {
        super(StandardClass.PROGRAM_ERROR);
        if (message == null) {
            throw new NullPointerException("message can not be null");
        }
        this.message = message;
        this.setFormatControl(this.getMessage());
        this.setFormatArguments(Lisp.NIL);
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        StringBuilder sb = new StringBuilder("Wrong number of arguments");
        LispObject lambdaName = this.operator.getLambdaName();
        if (lambdaName != null && lambdaName != Lisp.NIL) {
            sb.append(" for ");
            sb.append(this.operator.getLambdaName().writeToString());
        }
        if (this.expectedArgs >= 0) {
            sb.append("; ");
            sb.append(this.expectedArgs);
            sb.append(" expected");
        }
        sb.append('.');
        this.message = sb.toString();
        return this.message;
    }
}

