/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.PrintNotReadable;
import org.armedbear.lisp.StringOutputStream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class ZeroRankArray
extends AbstractArray {
    private final LispObject elementType;
    private final boolean adjustable;
    private LispObject data;

    public ZeroRankArray(LispObject elementType, LispObject data, boolean adjustable) {
        this.elementType = elementType;
        this.data = data;
        this.adjustable = adjustable;
    }

    public LispObject typeOf() {
        if (this.adjustable) {
            return Lisp.list(Symbol.ARRAY, this.elementType, Lisp.NIL);
        }
        return Lisp.list(Symbol.SIMPLE_ARRAY, this.elementType, Lisp.NIL);
    }

    public LispObject classOf() {
        return BuiltInClass.ARRAY;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.SIMPLE_ARRAY) {
            return this.adjustable ? Lisp.NIL : Lisp.T;
        }
        return super.typep(type);
    }

    public int getRank() {
        return 0;
    }

    public LispObject getDimensions() {
        return Lisp.NIL;
    }

    public int getDimension(int n) {
        Lisp.error(new TypeError("Bad array dimension (" + n + ") for array of rank 0."));
        return -1;
    }

    public LispObject getElementType() {
        return this.elementType;
    }

    public int getTotalSize() {
        return 1;
    }

    public LispObject AREF(int index) {
        if (index == 0) {
            return this.data;
        }
        return Lisp.error(new TypeError("Bad row major index " + index + "."));
    }

    public void aset(int index, LispObject obj) {
        if (obj.typep(this.elementType) == Lisp.NIL) {
            Lisp.error(new TypeError(obj, this.elementType));
        }
        if (index == 0) {
            this.data = obj;
        } else {
            Lisp.error(new TypeError("Bad row major index " + index + "."));
        }
    }

    public void fill(LispObject obj) {
        if (obj.typep(this.elementType) == Lisp.NIL) {
            Lisp.error(new TypeError(obj, this.elementType));
        }
        this.data = obj;
    }

    public String writeToString() {
        boolean printReadably;
        LispThread thread = LispThread.currentThread();
        boolean bl = printReadably = Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL;
        if (printReadably && this.elementType != Lisp.T) {
            Lisp.error(new PrintNotReadable(Lisp.list(Keyword.OBJECT, this)));
            return null;
        }
        if (printReadably || Symbol.PRINT_ARRAY.symbolValue(thread) != Lisp.NIL) {
            StringBuffer sb = new StringBuffer("#0A");
            if (this.data == this && Symbol.PRINT_CIRCLE.symbolValue(thread) != Lisp.NIL) {
                StringOutputStream stream = new StringOutputStream();
                thread.execute(Symbol.OUTPUT_OBJECT.getSymbolFunction(), this.data, stream);
                sb.append(stream.getString().getStringValue());
            } else {
                sb.append(this.data.writeToString());
            }
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer();
        if (!this.adjustable) {
            sb.append("SIMPLE-");
        }
        sb.append("ARRAY ");
        sb.append(this.elementType.writeToString());
        sb.append(" NIL");
        return this.unreadableString(sb.toString());
    }

    public AbstractArray adjustArray(int[] dims, LispObject initialElement, LispObject initialContents) {
        if (this.isAdjustable()) {
            if (initialContents != null) {
                this.data = initialContents;
            }
            return this;
        }
        return new ZeroRankArray(this.elementType, initialContents != null ? initialContents : (initialElement != null ? initialElement : this.data), false);
    }

    public AbstractArray adjustArray(int[] dims, AbstractArray displacedTo, int displacement) {
        Lisp.error(new TypeError("Displacement not supported for array of rank 0."));
        return null;
    }
}

