/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LogicalPathname;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.ZipCache;

public final class delete_file
extends Primitive {
    private static final Primitive DELETE_FILE = new delete_file();

    private delete_file() {
        super("delete-file", "filespec");
    }

    public LispObject execute(LispObject arg) {
        Pathname pathname = Lisp.coerceToPathname(arg);
        if (arg instanceof Stream) {
            ((Stream)arg)._close();
        }
        if (pathname instanceof LogicalPathname) {
            pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
        }
        if (pathname.isWild()) {
            return Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
        }
        Pathname defaultedPathname = Pathname.mergePathnames(pathname, Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()), Lisp.NIL);
        String namestring = defaultedPathname.getNamestring();
        if (namestring == null) {
            return Lisp.error(new FileError("Pathname has no namestring: " + defaultedPathname.writeToString(), defaultedPathname));
        }
        File file = new File(namestring);
        ZipCache.remove(file);
        if (file.exists()) {
            for (int i = 0; i < 5; ++i) {
                if (file.delete()) {
                    return Lisp.T;
                }
                System.gc();
                Thread.yield();
            }
            Pathname truename = new Pathname(file.getAbsolutePath());
            StringBuilder sb = new StringBuilder("Unable to delete ");
            sb.append(file.isDirectory() ? "directory " : "file ");
            sb.append(truename.writeToString());
            sb.append('.');
            return Lisp.error(new FileError(sb.toString(), truename));
        }
        return Lisp.T;
    }
}

