/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleError;

@DocString(name="zip", args="pathname pathnames &optional topdir", doc="Creates a zip archive at PATHNAME whose entries enumerated via the list of PATHNAMES.\nIf the optional TOPDIR argument is specified, the archive will preserve the hierarchy of PATHNAMES relative to TOPDIR.  Without TOPDIR, there will be no sub-directories in the archive, i.e. it will be flat.")
public final class zip
extends Primitive {
    private static final Primitive zip = new zip();

    private zip() {
        super("zip", Lisp.PACKAGE_SYS, true);
    }

    public LispObject execute(LispObject first, LispObject second) {
        Pathname zipfilePathname = Lisp.coerceToPathname(first);
        byte[] buffer = new byte[4096];
        try {
            String zipfileNamestring = zipfilePathname.getNamestring();
            if (zipfileNamestring == null) {
                return Lisp.error(new SimpleError("Pathname has no namestring: " + zipfilePathname.writeToString()));
            }
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfileNamestring));
            for (LispObject list = second; list != Lisp.NIL; list = list.cdr()) {
                int n;
                Pathname pathname = Lisp.coerceToPathname(list.car());
                String namestring = pathname.getNamestring();
                if (namestring == null) {
                    out.close();
                    File zipfile = new File(zipfileNamestring);
                    zipfile.delete();
                    return Lisp.error(new SimpleError("Pathname has no namestring: " + pathname.writeToString()));
                }
                File file = new File(namestring);
                FileInputStream in = new FileInputStream(file);
                ZipEntry entry = new ZipEntry(file.getName());
                out.putNextEntry(entry);
                while ((n = in.read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IOException e) {
            return Lisp.error(new LispError(e.getMessage()));
        }
        return zipfilePathname;
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        Pathname zipfilePathname = Lisp.coerceToPathname(first);
        byte[] buffer = new byte[4096];
        try {
            String zipfileNamestring = zipfilePathname.getNamestring();
            if (zipfileNamestring == null) {
                return Lisp.error(new SimpleError("Pathname has no namestring: " + zipfilePathname.writeToString()));
            }
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfileNamestring));
            Pathname root = Lisp.coerceToPathname(third);
            String rootPath = root.getDirectoryNamestring();
            int rootPathLength = rootPath.length();
            HashSet<String> directories = new HashSet<String>();
            LispObject list = second;
            while (list != Lisp.NIL) {
                int n;
                File file;
                Pathname pathname = Lisp.coerceToPathname(list.car());
                String namestring = pathname.getNamestring();
                if (namestring == null) {
                    out.close();
                    File zipfile = new File(zipfileNamestring);
                    zipfile.delete();
                    return Lisp.error(new SimpleError("Pathname has no namestring: " + pathname.writeToString()));
                }
                String directory = "";
                String dir = pathname.getDirectoryNamestring();
                if (dir.length() > rootPathLength) {
                    int j;
                    String d = dir.substring(rootPathLength);
                    int i = 0;
                    while ((j = d.indexOf(47, i)) != -1) {
                        i = j + 1;
                        directory = d.substring(0, j) + '/';
                        if (directories.contains(directory)) continue;
                        directories.add(directory);
                        ZipEntry entry = new ZipEntry(directory);
                        out.putNextEntry(entry);
                        out.closeEntry();
                    }
                }
                if ((file = new File(namestring)).isDirectory()) {
                    list = list.cdr();
                    continue;
                }
                FileInputStream in = new FileInputStream(file);
                ZipEntry entry = new ZipEntry(directory + file.getName());
                out.putNextEntry(entry);
                while ((n = in.read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                }
                out.closeEntry();
                in.close();
                list = list.cdr();
            }
            out.close();
        }
        catch (IOException e) {
            return Lisp.error(new LispError(e.getMessage()));
        }
        return zipfilePathname;
    }
}

