/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public class TwoWayStream
extends Stream {
    public final Stream in;
    public final Stream out;
    private static final Primitive MAKE_TWO_WAY_STREAM = new Primitive(Symbol.MAKE_TWO_WAY_STREAM, "input-stream output-stream"){

        public LispObject execute(LispObject first, LispObject second) {
            Stream in = Lisp.checkStream(first);
            Stream out = Lisp.checkStream(second);
            if (!in.isInputStream()) {
                return Lisp.type_error(in, Lisp.list(Symbol.SATISFIES, Symbol.INPUT_STREAM_P));
            }
            if (!out.isOutputStream()) {
                return Lisp.type_error(out, Lisp.list(Symbol.SATISFIES, Symbol.OUTPUT_STREAM_P));
            }
            return new TwoWayStream(in, out);
        }
    };
    private static final Primitive TWO_WAY_STREAM_INPUT_STREAM = new Primitive(Symbol.TWO_WAY_STREAM_INPUT_STREAM, "two-way-stream"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof TwoWayStream) {
                return ((TwoWayStream)arg).in;
            }
            return Lisp.type_error(arg, Symbol.TWO_WAY_STREAM);
        }
    };
    private static final Primitive TWO_WAY_STREAM_OUTPUT_STREAM = new Primitive(Symbol.TWO_WAY_STREAM_OUTPUT_STREAM, "two-way-stream"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof TwoWayStream) {
                return ((TwoWayStream)arg).out;
            }
            return Lisp.type_error(arg, Symbol.TWO_WAY_STREAM);
        }
    };

    public TwoWayStream(Stream in, Stream out) {
        super(Symbol.TWO_WAY_STREAM);
        this.in = in;
        this.out = out;
        this.isInputStream = true;
        this.isOutputStream = true;
    }

    public TwoWayStream(Stream in, Stream out, boolean interactive) {
        this(in, out);
        this.setInteractive(interactive);
    }

    public LispObject getElementType() {
        LispObject otype;
        LispObject itype = this.in.getElementType();
        if (itype.equal(otype = this.out.getElementType())) {
            return itype;
        }
        return Lisp.list(Symbol.AND, itype, otype);
    }

    public Stream getInputStream() {
        return this.in;
    }

    public Stream getOutputStream() {
        return this.out;
    }

    public boolean isCharacterInputStream() {
        return this.in.isCharacterInputStream();
    }

    public boolean isBinaryInputStream() {
        return this.in.isBinaryInputStream();
    }

    public boolean isCharacterOutputStream() {
        return this.out.isCharacterOutputStream();
    }

    public boolean isBinaryOutputStream() {
        return this.out.isBinaryOutputStream();
    }

    public LispObject typeOf() {
        return Symbol.TWO_WAY_STREAM;
    }

    public LispObject classOf() {
        return BuiltInClass.TWO_WAY_STREAM;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.TWO_WAY_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.TWO_WAY_STREAM) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    protected int _readChar() throws IOException {
        return this.in._readChar();
    }

    protected void _unreadChar(int n) throws IOException {
        this.in._unreadChar(n);
    }

    protected boolean _charReady() throws IOException {
        return this.in._charReady();
    }

    public void _writeChar(char c) {
        this.out._writeChar(c);
    }

    public void _writeChars(char[] chars, int start, int end) {
        this.out._writeChars(chars, start, end);
    }

    public void _writeString(String s) {
        this.out._writeString(s);
    }

    public void _writeLine(String s) {
        this.out._writeLine(s);
    }

    public int _readByte() {
        return this.in._readByte();
    }

    public void _writeByte(int n) {
        this.out._writeByte(n);
    }

    public void _finishOutput() {
        this.out._finishOutput();
    }

    public void _clearInput() {
        this.in._clearInput();
    }

    public LispObject listen() {
        return this.in.listen();
    }

    public LispObject freshLine() {
        return this.out.freshLine();
    }

    public LispObject close(LispObject abort) {
        this.setOpen(false);
        return Lisp.T;
    }

    public String printObject() {
        return this.unreadableString("TWO-WAY-STREAM");
    }
}

