/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.StandardClass;

public final class WrongNumberOfArgumentsException
extends ProgramError {
    private Operator operator;
    private int expectedMinArgs;
    private int expectedMaxArgs;
    private String message;

    public WrongNumberOfArgumentsException(Operator operator) {
        this(operator, -1);
    }

    public WrongNumberOfArgumentsException(Operator operator, int expectedMin, int expectedMax) {
        super(StandardClass.PROGRAM_ERROR);
        this.operator = operator;
        this.expectedMinArgs = expectedMin;
        this.expectedMaxArgs = expectedMax;
        this.setFormatControl(this.getMessage());
        this.setFormatArguments(Lisp.NIL);
    }

    public WrongNumberOfArgumentsException(Operator operator, int expectedArgs) {
        this(operator, expectedArgs, expectedArgs);
    }

    public WrongNumberOfArgumentsException(String message) {
        super(StandardClass.PROGRAM_ERROR);
        if (message == null) {
            throw new NullPointerException("message can not be null");
        }
        this.message = message;
        this.setFormatControl(this.getMessage());
        this.setFormatArguments(Lisp.NIL);
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        StringBuilder sb = new StringBuilder("Wrong number of arguments for " + this.operator.princToString());
        if (this.expectedMinArgs >= 0 || this.expectedMaxArgs >= 0) {
            sb.append("; ");
            if (this.expectedMinArgs == this.expectedMaxArgs) {
                sb.append(this.expectedMinArgs);
            } else if (this.expectedMaxArgs < 0) {
                sb.append("at least ");
                sb.append(this.expectedMinArgs);
            } else if (this.expectedMinArgs < 0) {
                sb.append("at most ");
                sb.append(this.expectedMaxArgs);
            } else {
                sb.append("between ").append(this.expectedMinArgs);
                sb.append(" and ").append(this.expectedMaxArgs);
            }
            sb.append(" expected");
        }
        sb.append('.');
        this.message = sb.toString();
        return this.message;
    }
}

