/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.Hashtable;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Load;
import org.armedbear.lisp.MacroObject;
import org.armedbear.lisp.Nil;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.Symbol;

public class AutoloadedFunctionProxy
extends Function {
    static final Symbol[] symsToSave = new Symbol[]{Lisp.AUTOLOADING_CACHE, Load._FASL_UNINTERNED_SYMBOLS_, Symbol._PACKAGE_, Symbol.LOAD_TRUENAME};
    private final Symbol symbol;
    private final String name;
    private final LispObject cache;
    private final LispObject[] savedSyms;
    private final FunctionType fType;
    Function fun = null;
    private static final Primitive PROXY_PRELOADED_FUNCTION = new proxy_preloaded_function();
    private static final Primitive FUNCTION_PRELOAD = new function_preload();

    public AutoloadedFunctionProxy(Symbol symbol, LispObject name, LispObject cache, LispObject[] savedSyms, FunctionType ft) {
        this.symbol = symbol;
        this.name = name.getStringValue();
        this.cache = cache;
        this.savedSyms = savedSyms;
        Debug.assertTrue(!(cache instanceof Nil));
        this.fType = ft;
    }

    public LispObject resolve() {
        return this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized Function load() {
        if (this.fun != null) {
            return this.fun;
        }
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        for (int i = 0; i < symsToSave.length; ++i) {
            thread.bindSpecial(symsToSave[i], this.savedSyms[i]);
        }
        thread.bindSpecial(Symbol.READ_SUPPRESS, Lisp.NIL);
        thread.bindSpecial(Symbol.READ_EVAL, Lisp.T);
        thread.bindSpecial(Symbol.READ_BASE, LispInteger.getInstance(10));
        byte[] classbytes = (byte[])((Hashtable)this.cache.javaInstance()).get(this.name);
        try {
            this.fun = Lisp.loadClassBytes(classbytes);
        }
        catch (Throwable t) {
            Debug.trace(t);
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
        if (this.symbol != null) {
            AutoloadedFunctionProxy.installFunction(this.fType, this.symbol, this.fun);
        }
        return this.fun;
    }

    private static final void installFunction(FunctionType fType, Symbol sym, Function fun) {
        if (fType == FunctionType.SETF) {
            Lisp.put(sym, Symbol.SETF_FUNCTION, fun);
        } else if (fType == FunctionType.MACRO) {
            if (sym.getSymbolFunction() instanceof SpecialOperator) {
                Lisp.put(sym, Symbol.MACROEXPAND_MACRO, new MacroObject((LispObject)sym, fun));
            } else {
                sym.setSymbolFunction(new MacroObject((LispObject)sym, fun));
            }
        } else {
            sym.setSymbolFunction(fun);
        }
    }

    public LispObject execute() {
        return this.load().execute();
    }

    public LispObject execute(LispObject arg) {
        return this.load().execute(arg);
    }

    public LispObject execute(LispObject first, LispObject second) {
        return this.load().execute(first, second);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        return this.load().execute(first, second, third);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
        return this.load().execute(first, second, third, fourth);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        return this.load().execute(first, second, third, fourth, fifth);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        return this.load().execute(first, second, third, fourth, fifth, sixth);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        return this.load().execute(first, second, third, fourth, fifth, sixth, seventh);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        return this.load().execute(first, second, third, fourth, fifth, sixth, seventh, eighth);
    }

    public LispObject execute(LispObject[] args) {
        return this.load().execute(args);
    }

    public static final LispObject loadPreloadedFunction(String name) {
        LispThread thread = LispThread.currentThread();
        LispObject value = Lisp.AUTOLOADING_CACHE.symbolValue(thread);
        if (value instanceof Nil) {
            byte[] bytes = Lisp.readFunctionBytes(new Pathname(name));
            return bytes == null ? null : Lisp.loadClassBytes(bytes);
        }
        Hashtable cache = (Hashtable)value.javaInstance();
        byte[] bytes = (byte[])cache.get(name);
        if (bytes == null) {
            return Lisp.error(new LispError("Function '" + name + "' not preloaded" + " while preloading requested."));
        }
        try {
            return Lisp.loadClassBytes(bytes);
        }
        catch (VerifyError e) {
            return Lisp.error(new LispError("Class verification failed: " + e.getMessage()));
        }
        catch (Throwable t) {
            Debug.trace(t);
            return Lisp.error(new FileError("Can't read file off stream."));
        }
    }

    static final LispObject makePreloadingContext() {
        return new JavaObject(new Hashtable());
    }

    private static class function_preload
    extends Primitive {
        function_preload() {
            super("function-preload", Lisp.PACKAGE_SYS, false, "name");
        }

        public final LispObject execute(LispObject name) {
            String namestring = name.getStringValue();
            LispThread thread = LispThread.currentThread();
            Hashtable cache = (Hashtable)Lisp.AUTOLOADING_CACHE.symbolValue(thread).javaInstance();
            Pathname pathname = new Pathname(namestring);
            byte[] bytes = Lisp.readFunctionBytes(pathname);
            cache.put(namestring, bytes);
            return Lisp.T;
        }
    }

    private static final class proxy_preloaded_function
    extends Primitive {
        proxy_preloaded_function() {
            super("proxy-preloaded-function", Lisp.PACKAGE_SYS, false, "symbol name");
        }

        public final LispObject execute(LispObject symbol, LispObject name) {
            Symbol sym;
            LispThread thread = LispThread.currentThread();
            FunctionType fType = FunctionType.NORMAL;
            if (symbol instanceof Symbol) {
                sym = (Symbol)symbol;
            } else if (Lisp.isValidSetfFunctionName(symbol)) {
                sym = (Symbol)symbol.cadr();
                fType = FunctionType.SETF;
            } else if (Lisp.isValidMacroFunctionName(symbol)) {
                sym = (Symbol)symbol.cadr();
                fType = FunctionType.MACRO;
            } else {
                Lisp.checkSymbol(symbol);
                return null;
            }
            LispObject cache = Lisp.AUTOLOADING_CACHE.symbolValue(thread);
            if (cache instanceof Nil) {
                return Lisp.loadCompiledFunction(name.getStringValue());
            }
            LispObject[] cachedSyms = new LispObject[symsToSave.length];
            for (int i = 0; i < symsToSave.length; ++i) {
                cachedSyms[i] = symsToSave[i].symbolValue(thread);
            }
            AutoloadedFunctionProxy fun = new AutoloadedFunctionProxy(sym, name, cache, cachedSyms, fType);
            fun.setClassBytes((byte[])((Hashtable)cache.javaInstance()).get(name.getStringValue()));
            return fun;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FunctionType {
        NORMAL,
        SETF,
        MACRO;

    }
}

