/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.AutoloadedFunctionProxy;
import org.armedbear.lisp.Closure;
import org.armedbear.lisp.ClosureBinding;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public class CompiledClosure
extends Closure
implements Cloneable {
    public ClosureBinding[] ctx;
    private static final Primitive LOAD_COMPILED_FUNCTION = new Primitive("load-compiled-function", Lisp.PACKAGE_SYS, true, "source"){

        public LispObject execute(LispObject arg) {
            String namestring = null;
            if (arg instanceof Pathname) {
                namestring = ((Pathname)arg).getNamestring();
            } else if (arg instanceof AbstractString) {
                namestring = arg.getStringValue();
            }
            if (namestring != null) {
                return AutoloadedFunctionProxy.loadPreloadedFunction(namestring);
            }
            if (arg instanceof JavaObject) {
                try {
                    return Lisp.loadClassBytes((byte[])arg.javaInstance(byte[].class));
                }
                catch (Throwable t) {
                    Debug.trace(t);
                    return Lisp.error(new LispError("Unable to load " + arg.princToString()));
                }
            }
            return Lisp.error(new LispError("Unable to load " + arg.princToString()));
        }
    };
    private static final Primitive VARLIST = new Primitive("varlist", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Closure) {
                return ((Closure)arg).getVariableList();
            }
            return Lisp.type_error(arg, Symbol.COMPILED_FUNCTION);
        }
    };

    public CompiledClosure(Closure.Parameter[] required, Closure.Parameter[] optional, Closure.Parameter[] keyword, Symbol keys, Symbol rest, Symbol moreKeys) {
        super(required, optional, keyword, keys, rest, moreKeys);
    }

    public CompiledClosure(LispObject lambdaList) {
        super((LispObject)Lisp.list(Symbol.LAMBDA, lambdaList), null);
    }

    public final CompiledClosure setContext(ClosureBinding[] context) {
        this.ctx = context;
        return this;
    }

    public final CompiledClosure dup() {
        CompiledClosure result = null;
        try {
            result = (CompiledClosure)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return result;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.COMPILED_FUNCTION) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    private final LispObject notImplemented() {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    public LispObject execute() {
        LispObject[] args = new LispObject[]{};
        return this.execute(args);
    }

    public LispObject execute(LispObject first) {
        LispObject[] args = new LispObject[]{first};
        return this.execute(args);
    }

    public LispObject execute(LispObject first, LispObject second) {
        LispObject[] args = new LispObject[]{first, second};
        return this.execute(args);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        LispObject[] args = new LispObject[]{first, second, third};
        return this.execute(args);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
        LispObject[] args = new LispObject[]{first, second, third, fourth};
        return this.execute(args);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        LispObject[] args = new LispObject[]{first, second, third, fourth, fifth};
        return this.execute(args);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        LispObject[] args = new LispObject[]{first, second, third, fourth, fifth, sixth};
        return this.execute(args);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        LispObject[] args = new LispObject[]{first, second, third, fourth, fifth, sixth, seventh};
        return this.execute(args);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        LispObject[] args = new LispObject[]{first, second, third, fourth, fifth, sixth, seventh, eighth};
        return this.execute(args);
    }

    public LispObject execute(LispObject[] args) {
        return this.notImplemented();
    }
}

