/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.HashMap;
import java.util.Map;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.CharHashMap;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;

public final class LispCharacter
extends LispObject {
    public static final LispCharacter[] constants;
    public static final CharHashMap<LispCharacter> lispChars;
    public final char value;
    private String name;
    private static final Primitive CHARACTER;
    private static final Primitive WHITESPACEP;
    private static final Primitive CHAR_CODE;
    private static final Primitive CHAR_INT;
    private static final Primitive CODE_CHAR;
    private static final Primitive CHARACTERP;
    private static final Primitive BOTH_CASE_P;
    private static final Primitive LOWER_CASE_P;
    private static final Primitive UPPER_CASE_P;
    private static final Primitive CHAR_DOWNCASE;
    private static final Primitive CHAR_UPCASE;
    private static final Primitive DIGIT_CHAR;
    private static final Primitive DIGIT_CHAR_P;
    private static final Primitive STANDARD_CHAR_P;
    private static final Primitive GRAPHIC_CHAR_P;
    private static final Primitive ALPHA_CHAR_P;
    private static final Primitive ALPHANUMERICP;
    private static final Primitive NAME_CHAR;
    private static final Primitive CHAR_NAME;
    static int maxNamedChar;
    static Map<String, LispCharacter> namedToChar;
    static final char[] UPPER_CASE_CHARS;
    static final char[] LOWER_CASE_CHARS;

    public static LispCharacter getInstance(char c) {
        return lispChars.get(c);
    }

    private LispCharacter(char c) {
        this.value = c;
    }

    public LispObject typeOf() {
        if (this.isStandardChar()) {
            return Symbol.STANDARD_CHAR;
        }
        return Symbol.CHARACTER;
    }

    public LispObject classOf() {
        return BuiltInClass.CHARACTER;
    }

    public LispObject getDescription() {
        StringBuilder sb = new StringBuilder("character #\\");
        sb.append(this.value);
        sb.append(" char-code #x");
        sb.append(Integer.toHexString(this.value));
        return new SimpleString(sb);
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.CHARACTER) {
            return Lisp.T;
        }
        if (type == BuiltInClass.CHARACTER) {
            return Lisp.T;
        }
        if (type == Symbol.BASE_CHAR) {
            return Lisp.T;
        }
        if (type == Symbol.STANDARD_CHAR) {
            return this.isStandardChar() ? Lisp.T : Lisp.NIL;
        }
        return super.typep(type);
    }

    public boolean characterp() {
        return true;
    }

    public LispObject STRING() {
        return new SimpleString(this.value);
    }

    boolean isStandardChar() {
        if (this.value >= ' ' && this.value < '\u007f') {
            return true;
        }
        return this.value == '\n';
    }

    public boolean eql(char c) {
        return this.value == c;
    }

    public boolean eql(LispObject obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof LispCharacter && this.value == ((LispCharacter)obj).value;
    }

    public boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof LispCharacter && this.value == ((LispCharacter)obj).value;
    }

    public boolean equalp(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispCharacter) {
            if (this.value == ((LispCharacter)obj).value) {
                return true;
            }
            return LispCharacter.toLowerCase(this.value) == LispCharacter.toLowerCase(((LispCharacter)obj).value);
        }
        return false;
    }

    public static char getValue(LispObject obj) {
        if (obj instanceof LispCharacter) {
            return ((LispCharacter)obj).value;
        }
        Lisp.type_error(obj, Symbol.CHARACTER);
        return '\u0000';
    }

    public final char getValue() {
        return this.value;
    }

    public Object javaInstance() {
        return Character.valueOf(this.value);
    }

    public Object javaInstance(Class c) {
        return this.javaInstance();
    }

    public int sxhash() {
        return this.value;
    }

    public int psxhash() {
        return Character.toUpperCase(this.value);
    }

    public String getStringValue() {
        return String.valueOf(this.value);
    }

    public final String printObject() {
        LispThread thread = LispThread.currentThread();
        boolean printReadably = Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL;
        boolean printEscape = printReadably || Symbol.PRINT_ESCAPE.symbolValue(thread) != Lisp.NIL;
        StringBuilder sb = new StringBuilder();
        if (printEscape) {
            sb.append("#\\");
            switch (this.value) {
                case '\u0000': {
                    sb.append("Null");
                    break;
                }
                case '\u0007': {
                    sb.append("Bell");
                    break;
                }
                case '\b': {
                    sb.append("Backspace");
                    break;
                }
                case '\t': {
                    sb.append("Tab");
                    break;
                }
                case '\n': {
                    sb.append("Newline");
                    break;
                }
                case '\f': {
                    sb.append("Page");
                    break;
                }
                case '\r': {
                    sb.append("Return");
                    break;
                }
                case '\u001b': {
                    sb.append("Escape");
                    break;
                }
                case '\u007f': {
                    sb.append("Rubout");
                    break;
                }
                default: {
                    if (this.name != null) {
                        sb.append(this.name);
                        break;
                    }
                    sb.append(this.value);
                    break;
                }
            }
        } else {
            sb.append(this.value);
        }
        return sb.toString();
    }

    public static final int nameToChar(String s) {
        String lower = s.toLowerCase();
        LispCharacter lc = namedToChar.get(lower);
        if (lc != null) {
            return lc.value;
        }
        if (lower.length() == 5 && lower.startsWith("u")) {
            try {
                int i = Integer.parseInt(lower.substring(1, 5), 16);
                return i;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (lower.equals("null")) {
            return 0;
        }
        if (lower.equals("bell")) {
            return 7;
        }
        if (lower.equals("backspace")) {
            return 8;
        }
        if (lower.equals("tab")) {
            return 9;
        }
        if (lower.equals("linefeed")) {
            return 10;
        }
        if (lower.equals("newline")) {
            return 10;
        }
        if (lower.equals("page")) {
            return 12;
        }
        if (lower.equals("return")) {
            return 13;
        }
        if (lower.equals("escape")) {
            return 27;
        }
        if (lower.equals("space")) {
            return 32;
        }
        if (lower.equals("rubout")) {
            return 127;
        }
        return -1;
    }

    public static final String charToName(char c) {
        switch (c) {
            case '\u0000': {
                return "Null";
            }
            case '\u0007': {
                return "Bell";
            }
            case '\b': {
                return "Backspace";
            }
            case '\t': {
                return "Tab";
            }
            case '\n': {
                return "Newline";
            }
            case '\f': {
                return "Page";
            }
            case '\r': {
                return "Return";
            }
            case '\u001b': {
                return "Escape";
            }
            case ' ': {
                return "Space";
            }
            case '\u007f': {
                return "Rubout";
            }
        }
        if (c < '\u0000' || c > '\u00ff') {
            return null;
        }
        return LispCharacter.lispChars.get((char)c).name;
    }

    public static final char toUpperCase(char c) {
        if (c < '\u0080') {
            return UPPER_CASE_CHARS[c];
        }
        return Character.toUpperCase(c);
    }

    static void setCharNames(int i, String[] string) {
        int settingChar = i;
        int index = 0;
        int stringLen = string.length;
        while (stringLen-- > 0) {
            LispCharacter.setCharName(settingChar, string[index]);
            ++index;
            ++settingChar;
        }
        if (maxNamedChar < settingChar) {
            maxNamedChar = settingChar;
        }
    }

    static void setCharName(int settingChar, String string) {
        LispCharacter c = lispChars.get((char)settingChar);
        c.name = string;
        namedToChar.put(string.toLowerCase(), c);
    }

    public static final char toLowerCase(char c) {
        if (c < '\u0080') {
            return LOWER_CASE_CHARS[c];
        }
        return Character.toLowerCase(c);
    }

    static {
        lispChars = new CharHashMap<LispCharacter>(LispCharacter.class, null){

            @Override
            public LispCharacter get(char c) {
                LispCharacter lc = (LispCharacter)super.get(c);
                if (lc == null) {
                    lc = new LispCharacter(c);
                    this.put(c, lc);
                }
                return lc;
            }
        };
        constants = (LispCharacter[])LispCharacter.lispChars.constants;
        int i = constants.length;
        while (i-- > 0) {
            LispCharacter.constants[i] = new LispCharacter((char)i);
        }
        CHARACTER = new Primitive(Symbol.CHARACTER, "character"){

            public LispObject execute(LispObject arg) {
                String name;
                if (arg instanceof LispCharacter) {
                    return arg;
                }
                if (arg instanceof AbstractString) {
                    if (arg.length() == 1) {
                        return ((AbstractString)arg).AREF(0);
                    }
                } else if (arg instanceof Symbol && (name = ((Symbol)arg).getName()).length() == 1) {
                    return LispCharacter.getInstance(name.charAt(0));
                }
                return Lisp.type_error(arg, Symbol.CHARACTER_DESIGNATOR);
            }
        };
        WHITESPACEP = new Primitive("whitespacep", Lisp.PACKAGE_SYS, true){

            public LispObject execute(LispObject arg) {
                return Character.isWhitespace(LispCharacter.getValue(arg)) ? Lisp.T : Lisp.NIL;
            }
        };
        CHAR_CODE = new Primitive(Symbol.CHAR_CODE, "character"){

            public LispObject execute(LispObject arg) {
                char n = LispCharacter.getValue(arg);
                return Fixnum.getInstance(n);
            }
        };
        CHAR_INT = new Primitive(Symbol.CHAR_INT, "character"){

            public LispObject execute(LispObject arg) {
                char n = LispCharacter.getValue(arg);
                return Fixnum.getInstance(n);
            }
        };
        CODE_CHAR = new Primitive(Symbol.CODE_CHAR, "code"){

            public LispObject execute(LispObject arg) {
                int n = Fixnum.getValue(arg);
                if (Character.isValidCodePoint(n)) {
                    return LispCharacter.getInstance((char)n);
                }
                return Lisp.NIL;
            }
        };
        CHARACTERP = new Primitive(Symbol.CHARACTERP, "object"){

            public LispObject execute(LispObject arg) {
                return arg instanceof LispCharacter ? Lisp.T : Lisp.NIL;
            }
        };
        BOTH_CASE_P = new Primitive(Symbol.BOTH_CASE_P, "character"){

            public LispObject execute(LispObject arg) {
                char c = LispCharacter.getValue(arg);
                if (Character.isLowerCase(c) || Character.isUpperCase(c)) {
                    return Lisp.T;
                }
                return Lisp.NIL;
            }
        };
        LOWER_CASE_P = new Primitive(Symbol.LOWER_CASE_P, "character"){

            public LispObject execute(LispObject arg) {
                return Character.isLowerCase(LispCharacter.getValue(arg)) ? Lisp.T : Lisp.NIL;
            }
        };
        UPPER_CASE_P = new Primitive(Symbol.UPPER_CASE_P, "character"){

            public LispObject execute(LispObject arg) {
                return Character.isUpperCase(LispCharacter.getValue(arg)) ? Lisp.T : Lisp.NIL;
            }
        };
        CHAR_DOWNCASE = new Primitive(Symbol.CHAR_DOWNCASE, "character"){

            public LispObject execute(LispObject arg) {
                char c = LispCharacter.getValue(arg);
                if (c < '\u0080') {
                    return constants[LOWER_CASE_CHARS[c]];
                }
                return LispCharacter.getInstance(LispCharacter.toLowerCase(c));
            }
        };
        CHAR_UPCASE = new Primitive(Symbol.CHAR_UPCASE, "character"){

            public LispObject execute(LispObject arg) {
                char c = LispCharacter.getValue(arg);
                if (c < '\u0080') {
                    return constants[UPPER_CASE_CHARS[c]];
                }
                return LispCharacter.getInstance(LispCharacter.toUpperCase(c));
            }
        };
        DIGIT_CHAR = new Primitive(Symbol.DIGIT_CHAR, "weight &optional radix"){

            public LispObject execute(LispObject arg) {
                if (arg instanceof Bignum) {
                    return Lisp.NIL;
                }
                int weight = Fixnum.getValue(arg);
                if (weight < 10) {
                    return constants[48 + weight];
                }
                return Lisp.NIL;
            }

            public LispObject execute(LispObject first, LispObject second) {
                int radix = second instanceof Fixnum ? ((Fixnum)second).value : -1;
                if (radix < 2 || radix > 36) {
                    return Lisp.type_error(second, Lisp.list(Symbol.INTEGER, Fixnum.TWO, Fixnum.constants[36]));
                }
                if (first instanceof Bignum) {
                    return Lisp.NIL;
                }
                int weight = Fixnum.getValue(first);
                if (weight >= radix) {
                    return Lisp.NIL;
                }
                if (weight < 10) {
                    return constants[48 + weight];
                }
                return constants[65 + weight - 10];
            }
        };
        DIGIT_CHAR_P = new Primitive(Symbol.DIGIT_CHAR_P, "char &optional radix"){

            public LispObject execute(LispObject arg) {
                int n = Character.digit(LispCharacter.getValue(arg), 10);
                return n < 0 ? Lisp.NIL : Fixnum.getInstance(n);
            }

            public LispObject execute(LispObject first, LispObject second) {
                int radix;
                char c = LispCharacter.getValue(first);
                if (second instanceof Fixnum && (radix = ((Fixnum)second).value) >= 2 && radix <= 36) {
                    int n = Character.digit(c, radix);
                    return n < 0 ? Lisp.NIL : Fixnum.constants[n];
                }
                return Lisp.type_error(second, Lisp.list(Symbol.INTEGER, Fixnum.TWO, Fixnum.constants[36]));
            }
        };
        STANDARD_CHAR_P = new Primitive(Symbol.STANDARD_CHAR_P, "character"){

            public LispObject execute(LispObject arg) {
                return Lisp.checkCharacter(arg).isStandardChar() ? Lisp.T : Lisp.NIL;
            }
        };
        GRAPHIC_CHAR_P = new Primitive(Symbol.GRAPHIC_CHAR_P, "char"){

            public LispObject execute(LispObject arg) {
                char c = LispCharacter.getValue(arg);
                if (c >= ' ' && c < '\u007f') {
                    return Lisp.T;
                }
                return Character.isISOControl(c) ? Lisp.NIL : Lisp.T;
            }
        };
        ALPHA_CHAR_P = new Primitive(Symbol.ALPHA_CHAR_P, "character"){

            public LispObject execute(LispObject arg) {
                return Character.isLetter(LispCharacter.getValue(arg)) ? Lisp.T : Lisp.NIL;
            }
        };
        ALPHANUMERICP = new Primitive(Symbol.ALPHANUMERICP, "character"){

            public LispObject execute(LispObject arg) {
                return Character.isLetterOrDigit(LispCharacter.getValue(arg)) ? Lisp.T : Lisp.NIL;
            }
        };
        NAME_CHAR = new Primitive(Symbol.NAME_CHAR, "name"){

            public LispObject execute(LispObject arg) {
                String s = arg.STRING().getStringValue();
                int n = LispCharacter.nameToChar(s);
                return n >= 0 ? LispCharacter.getInstance((char)n) : Lisp.NIL;
            }
        };
        CHAR_NAME = new Primitive(Symbol.CHAR_NAME, "character"){

            public LispObject execute(LispObject arg) {
                String name = LispCharacter.charToName(LispCharacter.getValue(arg));
                return name != null ? new SimpleString(name) : Lisp.NIL;
            }
        };
        maxNamedChar = 0;
        namedToChar = new HashMap<String, LispCharacter>();
        new CharNameMaker0();
        UPPER_CASE_CHARS = new char[128];
        i = UPPER_CASE_CHARS.length;
        while (i-- > 0) {
            LispCharacter.UPPER_CASE_CHARS[i] = Character.toUpperCase((char)i);
        }
        LOWER_CASE_CHARS = new char[128];
        i = LOWER_CASE_CHARS.length;
        while (i-- > 0) {
            LispCharacter.LOWER_CASE_CHARS[i] = Character.toLowerCase((char)i);
        }
    }

    static class CharNameMaker0 {
        CharNameMaker0() {
            LispCharacter.setCharNames(0, new String[]{"Null", "Soh", "Stx", "Etx", "Eot", "Enq", "Ack", "Bell", "Backspace", "Tab", "Newline", "Vt", "Page", "Return", "So", "Si", "Dle", "Dc1", "Dc2", "Dc3", "Dc4", "Nak", "Syn", "Etb", "Can", "Em", "Sub", "Escape", "Fs", "Gs", "Rs", "Us"});
            LispCharacter.setCharNames(128, new String[]{"U0080", "U0081", "U0082", "U0083", "U0084", "U0085", "U0086", "U0087", "U0088", "U0089", "U008a", "U008b", "U008c", "U008d", "U008e", "U008f", "U0090", "U0091", "U0092", "U0093", "U0094", "U0095", "U0096", "U0097", "U0098", "U0099", "U009a", "U009b", "U009c", "U009d", "U009e", "U009f"});
        }
    }
}

