/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.WeakHashMap;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Nil;
import org.armedbear.lisp.PrintNotReadable;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispObject {
    private static final WeakHashMap<LispObject, LispObject> documentationHashTable = new WeakHashMap();

    public LispObject resolve() {
        return this;
    }

    public LispObject typeOf() {
        return Lisp.T;
    }

    public static LispObject getInstance(boolean b) {
        return b ? Lisp.T : Lisp.NIL;
    }

    public LispObject classOf() {
        return BuiltInClass.CLASS_T;
    }

    public LispObject getDescription() {
        StringBuilder sb = new StringBuilder("An object of type ");
        sb.append(this.typeOf().princToString());
        sb.append(" at #x");
        sb.append(Integer.toHexString(System.identityHashCode(this)).toUpperCase());
        return new SimpleString(sb);
    }

    public LispObject getParts() {
        return Lisp.NIL;
    }

    public boolean getBooleanValue() {
        return true;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Lisp.T) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.CLASS_T) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.ATOM) {
            return Lisp.T;
        }
        return Lisp.NIL;
    }

    public boolean constantp() {
        return true;
    }

    public final LispObject CONSTANTP() {
        return this.constantp() ? Lisp.T : Lisp.NIL;
    }

    public final LispObject ATOM() {
        return this.atom() ? Lisp.T : Lisp.NIL;
    }

    public boolean atom() {
        return true;
    }

    public Object javaInstance() {
        return this;
    }

    public Object javaInstance(Class<?> c) {
        if (c.isAssignableFrom(this.getClass())) {
            return this;
        }
        return Lisp.error(new LispError("The value " + this.princToString() + " is not of class " + c.getName()));
    }

    public Object lockableInstance() {
        return this;
    }

    public final LispObject car() {
        if (this instanceof Cons) {
            return ((Cons)this).car;
        }
        if (this instanceof Nil) {
            return Lisp.NIL;
        }
        return Lisp.type_error(this, Symbol.LIST);
    }

    public final void setCar(LispObject obj) {
        if (this instanceof Cons) {
            ((Cons)this).car = obj;
            return;
        }
        Lisp.type_error(this, Symbol.CONS);
    }

    public LispObject RPLACA(LispObject obj) {
        return Lisp.type_error(this, Symbol.CONS);
    }

    public final LispObject cdr() {
        if (this instanceof Cons) {
            return ((Cons)this).cdr;
        }
        if (this instanceof Nil) {
            return Lisp.NIL;
        }
        return Lisp.type_error(this, Symbol.LIST);
    }

    public final void setCdr(LispObject obj) {
        if (this instanceof Cons) {
            ((Cons)this).cdr = obj;
            return;
        }
        Lisp.type_error(this, Symbol.CONS);
    }

    public LispObject RPLACD(LispObject obj) {
        return Lisp.type_error(this, Symbol.CONS);
    }

    public final LispObject cadr() {
        LispObject tail = this.cdr();
        if (!(tail instanceof Nil)) {
            return tail.car();
        }
        return Lisp.NIL;
    }

    public final LispObject cddr() {
        LispObject tail = this.cdr();
        if (!(tail instanceof Nil)) {
            return tail.cdr();
        }
        return Lisp.NIL;
    }

    public final LispObject caddr() {
        LispObject tail = this.cddr();
        if (!(tail instanceof Nil)) {
            return tail.car();
        }
        return Lisp.NIL;
    }

    public final LispObject nthcdr(int n) {
        if (n < 0) {
            return Lisp.type_error(Fixnum.getInstance(n), Lisp.list(Symbol.INTEGER, Fixnum.ZERO));
        }
        if (this instanceof Cons) {
            LispObject result = this;
            int i = n;
            while (i-- > 0 && (result = result.cdr()) != Lisp.NIL) {
            }
            return result;
        }
        if (this instanceof Nil) {
            return Lisp.NIL;
        }
        return Lisp.type_error(this, Symbol.LIST);
    }

    public final LispObject push(LispObject obj) {
        if (this instanceof Cons) {
            return new Cons(obj, this);
        }
        if (this instanceof Nil) {
            return new Cons(obj);
        }
        return Lisp.type_error(this, Symbol.LIST);
    }

    public final LispObject EQ(LispObject obj) {
        return this == obj ? Lisp.T : Lisp.NIL;
    }

    public boolean eql(char c) {
        return false;
    }

    public boolean eql(int n) {
        return false;
    }

    public boolean eql(LispObject obj) {
        return this == obj;
    }

    public final LispObject EQL(LispObject obj) {
        return this.eql(obj) ? Lisp.T : Lisp.NIL;
    }

    public final LispObject EQUAL(LispObject obj) {
        return this.equal(obj) ? Lisp.T : Lisp.NIL;
    }

    public boolean equal(int n) {
        return false;
    }

    public boolean equal(LispObject obj) {
        return this == obj;
    }

    public boolean equalp(int n) {
        return false;
    }

    public boolean equalp(LispObject obj) {
        return this == obj;
    }

    public LispObject ABS() {
        return Lisp.type_error(this, Symbol.NUMBER);
    }

    public LispObject NUMERATOR() {
        return Lisp.type_error(this, Symbol.RATIONAL);
    }

    public LispObject DENOMINATOR() {
        return Lisp.type_error(this, Symbol.RATIONAL);
    }

    public final LispObject EVENP() {
        return this.evenp() ? Lisp.T : Lisp.NIL;
    }

    public boolean evenp() {
        Lisp.type_error(this, Symbol.INTEGER);
        return false;
    }

    public final LispObject ODDP() {
        return this.oddp() ? Lisp.T : Lisp.NIL;
    }

    public boolean oddp() {
        Lisp.type_error(this, Symbol.INTEGER);
        return false;
    }

    public final LispObject PLUSP() {
        return this.plusp() ? Lisp.T : Lisp.NIL;
    }

    public boolean plusp() {
        Lisp.type_error(this, Symbol.REAL);
        return false;
    }

    public final LispObject MINUSP() {
        return this.minusp() ? Lisp.T : Lisp.NIL;
    }

    public boolean minusp() {
        Lisp.type_error(this, Symbol.REAL);
        return false;
    }

    public final LispObject NUMBERP() {
        return this.numberp() ? Lisp.T : Lisp.NIL;
    }

    public boolean numberp() {
        return false;
    }

    public final LispObject ZEROP() {
        return this.zerop() ? Lisp.T : Lisp.NIL;
    }

    public boolean zerop() {
        Lisp.type_error(this, Symbol.NUMBER);
        return false;
    }

    public LispObject COMPLEXP() {
        return Lisp.NIL;
    }

    public final LispObject FLOATP() {
        return this.floatp() ? Lisp.T : Lisp.NIL;
    }

    public boolean floatp() {
        return false;
    }

    public final LispObject INTEGERP() {
        return this.integerp() ? Lisp.T : Lisp.NIL;
    }

    public boolean integerp() {
        return false;
    }

    public final LispObject RATIONALP() {
        return this.rationalp() ? Lisp.T : Lisp.NIL;
    }

    public boolean rationalp() {
        return false;
    }

    public final LispObject REALP() {
        return this.realp() ? Lisp.T : Lisp.NIL;
    }

    public boolean realp() {
        return false;
    }

    public final LispObject STRINGP() {
        return this.stringp() ? Lisp.T : Lisp.NIL;
    }

    public boolean stringp() {
        return false;
    }

    public LispObject SIMPLE_STRING_P() {
        return Lisp.NIL;
    }

    public final LispObject VECTORP() {
        return this.vectorp() ? Lisp.T : Lisp.NIL;
    }

    public boolean vectorp() {
        return false;
    }

    public final LispObject CHARACTERP() {
        return this.characterp() ? Lisp.T : Lisp.NIL;
    }

    public boolean characterp() {
        return false;
    }

    public int length() {
        Lisp.type_error(this, Symbol.SEQUENCE);
        return 0;
    }

    public final LispObject LENGTH() {
        return Fixnum.getInstance(this.length());
    }

    public LispObject CHAR(int index) {
        return Lisp.type_error(this, Symbol.STRING);
    }

    public LispObject SCHAR(int index) {
        return Lisp.type_error(this, Symbol.SIMPLE_STRING);
    }

    public LispObject NTH(int index) {
        return Lisp.type_error(this, Symbol.LIST);
    }

    public final LispObject NTH(LispObject arg) {
        return this.NTH(Fixnum.getValue(arg));
    }

    public LispObject elt(int index) {
        return Lisp.type_error(this, Symbol.SEQUENCE);
    }

    public LispObject reverse() {
        return Lisp.type_error(this, Symbol.SEQUENCE);
    }

    public LispObject nreverse() {
        return Lisp.type_error(this, Symbol.SEQUENCE);
    }

    public long aref_long(int index) {
        return this.AREF(index).longValue();
    }

    public int aref(int index) {
        return this.AREF(index).intValue();
    }

    public LispObject AREF(int index) {
        return Lisp.type_error(this, Symbol.ARRAY);
    }

    public final LispObject AREF(LispObject index) {
        return this.AREF(Fixnum.getValue(index));
    }

    public void aset(int index, int n) {
        this.aset(index, (LispObject)Fixnum.getInstance(n));
    }

    public void aset(int index, LispObject newValue) {
        Lisp.type_error(this, Symbol.ARRAY);
    }

    public final void aset(LispObject index, LispObject newValue) {
        this.aset(Fixnum.getValue(index), newValue);
    }

    public LispObject SVREF(int index) {
        return Lisp.type_error(this, Symbol.SIMPLE_VECTOR);
    }

    public void svset(int index, LispObject newValue) {
        Lisp.type_error(this, Symbol.SIMPLE_VECTOR);
    }

    public void vectorPushExtend(LispObject element) {
        this.noFillPointer();
    }

    public LispObject VECTOR_PUSH_EXTEND(LispObject element) {
        return this.noFillPointer();
    }

    public LispObject VECTOR_PUSH_EXTEND(LispObject element, LispObject extension) {
        return this.noFillPointer();
    }

    public final LispObject noFillPointer() {
        return Lisp.type_error(this, Lisp.list(Symbol.AND, Symbol.VECTOR, Lisp.list(Symbol.SATISFIES, Symbol.ARRAY_HAS_FILL_POINTER_P)));
    }

    public LispObject[] copyToArray() {
        Lisp.type_error(this, Symbol.LIST);
        return null;
    }

    public final LispObject SYMBOLP() {
        return this instanceof Symbol ? Lisp.T : Lisp.NIL;
    }

    public final boolean listp() {
        return this instanceof Cons || this instanceof Nil;
    }

    public final LispObject LISTP() {
        return this.listp() ? Lisp.T : Lisp.NIL;
    }

    public final boolean endp() {
        if (this instanceof Cons) {
            return false;
        }
        if (this instanceof Nil) {
            return true;
        }
        Lisp.type_error(this, Symbol.LIST);
        return false;
    }

    public final LispObject ENDP() {
        return this.endp() ? Lisp.T : Lisp.NIL;
    }

    public LispObject NOT() {
        return Lisp.NIL;
    }

    public boolean isSpecialOperator() {
        Lisp.type_error(this, Symbol.SYMBOL);
        return false;
    }

    public boolean isSpecialVariable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject getDocumentation(LispObject docType) {
        DocString ds;
        LispObject fn;
        LispObject entry;
        LispObject alist;
        WeakHashMap<LispObject, LispObject> weakHashMap = documentationHashTable;
        synchronized (weakHashMap) {
            alist = documentationHashTable.get(this);
        }
        if (alist != null && (entry = Lisp.assq(docType, alist)) instanceof Cons) {
            return ((Cons)entry).cdr;
        }
        if (docType == Symbol.FUNCTION && this instanceof Symbol && (fn = ((Symbol)this).getSymbolFunction()) instanceof Function && (ds = fn.getClass().getAnnotation(DocString.class)) != null) {
            String arglist2 = ds.args();
            String docstring = ds.doc();
            if (arglist2.length() != 0) {
                ((Function)fn).setLambdaList(new SimpleString(arglist2));
            }
            if (docstring.length() != 0) {
                SimpleString doc = new SimpleString(docstring);
                ((Symbol)this).setDocumentation(Symbol.FUNCTION, doc);
                return doc;
            }
        }
        return Lisp.NIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocumentation(LispObject docType, LispObject documentation) {
        WeakHashMap<LispObject, LispObject> weakHashMap = documentationHashTable;
        synchronized (weakHashMap) {
            LispObject entry;
            LispObject alist = documentationHashTable.get(this);
            if (alist == null) {
                alist = Lisp.NIL;
            }
            if ((entry = Lisp.assq(docType, alist)) instanceof Cons) {
                ((Cons)entry).cdr = documentation;
            } else {
                alist = alist.push(new Cons(docType, documentation));
                documentationHashTable.put(this, alist);
            }
        }
    }

    public LispObject getPropertyList() {
        return null;
    }

    public void setPropertyList(LispObject obj) {
    }

    public LispObject getSymbolValue() {
        return Lisp.type_error(this, Symbol.SYMBOL);
    }

    public LispObject getSymbolFunction() {
        return Lisp.type_error(this, Symbol.SYMBOL);
    }

    public LispObject getSymbolFunctionOrDie() {
        return Lisp.type_error(this, Symbol.SYMBOL);
    }

    public LispObject getSymbolSetfFunction() {
        return Lisp.type_error(this, Symbol.SYMBOL);
    }

    public LispObject getSymbolSetfFunctionOrDie() {
        return Lisp.type_error(this, Symbol.SYMBOL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String princToString() {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        try {
            thread.bindSpecial(Symbol.PRINT_READABLY, Lisp.NIL);
            thread.bindSpecial(Symbol.PRINT_ESCAPE, Lisp.NIL);
            String string = this.printObject();
            return string;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    public String printObject() {
        return this.unreadableString(this.toString(), false);
    }

    public final String unreadableString(String s) {
        return this.unreadableString(s, true);
    }

    public final String unreadableString(String s, boolean identity) {
        if (Symbol.PRINT_READABLY.symbolValue() != Lisp.NIL) {
            Lisp.error(new PrintNotReadable(Lisp.list(Keyword.OBJECT, this)));
            return null;
        }
        StringBuilder sb = new StringBuilder("#<");
        sb.append(s);
        if (identity) {
            sb.append(" {");
            sb.append(Integer.toHexString(System.identityHashCode(this)).toUpperCase());
            sb.append("}");
        }
        sb.append(">");
        return sb.toString();
    }

    public LispObject execute(LispObject args, Environment env) {
        return Lisp.error(new LispError());
    }

    public LispObject execute() {
        return Lisp.type_error(this, Symbol.FUNCTION);
    }

    public LispObject execute(LispObject arg) {
        return Lisp.type_error(this, Symbol.FUNCTION);
    }

    public LispObject execute(LispObject first, LispObject second) {
        return Lisp.type_error(this, Symbol.FUNCTION);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        return Lisp.type_error(this, Symbol.FUNCTION);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
        return Lisp.type_error(this, Symbol.FUNCTION);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        return Lisp.type_error(this, Symbol.FUNCTION);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        return Lisp.type_error(this, Symbol.FUNCTION);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        return Lisp.type_error(this, Symbol.FUNCTION);
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        return Lisp.type_error(this, Symbol.FUNCTION);
    }

    public LispObject execute(LispObject[] args) {
        return Lisp.type_error(this, Symbol.FUNCTION);
    }

    public LispObject dispatch(LispObject[] args) {
        switch (args.length) {
            case 0: {
                return this.execute();
            }
            case 1: {
                return this.execute(args[0]);
            }
            case 2: {
                return this.execute(args[0], args[1]);
            }
            case 3: {
                return this.execute(args[0], args[1], args[2]);
            }
            case 4: {
                return this.execute(args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return this.execute(args[0], args[1], args[2], args[3], args[4]);
            }
            case 6: {
                return this.execute(args[0], args[1], args[2], args[3], args[4], args[5]);
            }
            case 7: {
                return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
            case 8: {
                return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
            }
        }
        return this.execute(args);
    }

    public int intValue() {
        Lisp.type_error(this, Symbol.INTEGER);
        return 0;
    }

    public long longValue() {
        Lisp.type_error(this, Symbol.INTEGER);
        return 0L;
    }

    public float floatValue() {
        Lisp.type_error(this, Symbol.SINGLE_FLOAT);
        return 0.0f;
    }

    public double doubleValue() {
        Lisp.type_error(this, Symbol.DOUBLE_FLOAT);
        return 0.0;
    }

    public LispObject incr() {
        return Lisp.type_error(this, Symbol.NUMBER);
    }

    public LispObject decr() {
        return Lisp.type_error(this, Symbol.NUMBER);
    }

    public LispObject negate() {
        return Fixnum.ZERO.subtract(this);
    }

    public LispObject add(int n) {
        return this.add(Fixnum.getInstance(n));
    }

    public LispObject add(LispObject obj) {
        return Lisp.type_error(this, Symbol.NUMBER);
    }

    public LispObject subtract(int n) {
        return this.subtract(Fixnum.getInstance(n));
    }

    public LispObject subtract(LispObject obj) {
        return Lisp.type_error(this, Symbol.NUMBER);
    }

    public LispObject multiplyBy(int n) {
        return this.multiplyBy(Fixnum.getInstance(n));
    }

    public LispObject multiplyBy(LispObject obj) {
        return Lisp.type_error(this, Symbol.NUMBER);
    }

    public LispObject divideBy(LispObject obj) {
        return Lisp.type_error(this, Symbol.NUMBER);
    }

    public boolean isEqualTo(int n) {
        return this.isEqualTo(Fixnum.getInstance(n));
    }

    public boolean isEqualTo(LispObject obj) {
        Lisp.type_error(this, Symbol.NUMBER);
        return false;
    }

    public final LispObject IS_E(LispObject obj) {
        return this.isEqualTo(obj) ? Lisp.T : Lisp.NIL;
    }

    public boolean isNotEqualTo(int n) {
        return this.isNotEqualTo(Fixnum.getInstance(n));
    }

    public boolean isNotEqualTo(LispObject obj) {
        Lisp.type_error(this, Symbol.NUMBER);
        return false;
    }

    public final LispObject IS_NE(LispObject obj) {
        return this.isNotEqualTo(obj) ? Lisp.T : Lisp.NIL;
    }

    public boolean isLessThan(int n) {
        return this.isLessThan(Fixnum.getInstance(n));
    }

    public boolean isLessThan(LispObject obj) {
        Lisp.type_error(this, Symbol.REAL);
        return false;
    }

    public final LispObject IS_LT(LispObject obj) {
        return this.isLessThan(obj) ? Lisp.T : Lisp.NIL;
    }

    public boolean isGreaterThan(int n) {
        return this.isGreaterThan(Fixnum.getInstance(n));
    }

    public boolean isGreaterThan(LispObject obj) {
        Lisp.type_error(this, Symbol.REAL);
        return false;
    }

    public final LispObject IS_GT(LispObject obj) {
        return this.isGreaterThan(obj) ? Lisp.T : Lisp.NIL;
    }

    public boolean isLessThanOrEqualTo(int n) {
        return this.isLessThanOrEqualTo(Fixnum.getInstance(n));
    }

    public boolean isLessThanOrEqualTo(LispObject obj) {
        Lisp.type_error(this, Symbol.REAL);
        return false;
    }

    public final LispObject IS_LE(LispObject obj) {
        return this.isLessThanOrEqualTo(obj) ? Lisp.T : Lisp.NIL;
    }

    public boolean isGreaterThanOrEqualTo(int n) {
        return this.isGreaterThanOrEqualTo(Fixnum.getInstance(n));
    }

    public boolean isGreaterThanOrEqualTo(LispObject obj) {
        Lisp.type_error(this, Symbol.REAL);
        return false;
    }

    public final LispObject IS_GE(LispObject obj) {
        return this.isGreaterThanOrEqualTo(obj) ? Lisp.T : Lisp.NIL;
    }

    public LispObject truncate(LispObject obj) {
        return Lisp.type_error(this, Symbol.REAL);
    }

    public LispObject MOD(LispObject divisor) {
        this.truncate(divisor);
        LispThread thread = LispThread.currentThread();
        LispObject remainder = thread._values[1];
        thread.clearValues();
        if (!remainder.zerop() && (divisor.minusp() ? this.plusp() : this.minusp())) {
            return remainder.add(divisor);
        }
        return remainder;
    }

    public LispObject MOD(int divisor) {
        return this.MOD(Fixnum.getInstance(divisor));
    }

    public LispObject ash(int shift) {
        return this.ash(Fixnum.getInstance(shift));
    }

    public LispObject ash(LispObject obj) {
        return Lisp.type_error(this, Symbol.INTEGER);
    }

    public LispObject LOGNOT() {
        return Lisp.type_error(this, Symbol.INTEGER);
    }

    public LispObject LOGAND(int n) {
        return this.LOGAND(Fixnum.getInstance(n));
    }

    public LispObject LOGAND(LispObject obj) {
        return Lisp.type_error(this, Symbol.INTEGER);
    }

    public LispObject LOGIOR(int n) {
        return this.LOGIOR(Fixnum.getInstance(n));
    }

    public LispObject LOGIOR(LispObject obj) {
        return Lisp.type_error(this, Symbol.INTEGER);
    }

    public LispObject LOGXOR(int n) {
        return this.LOGXOR(Fixnum.getInstance(n));
    }

    public LispObject LOGXOR(LispObject obj) {
        return Lisp.type_error(this, Symbol.INTEGER);
    }

    public LispObject LDB(int size, int position) {
        return Lisp.type_error(this, Symbol.INTEGER);
    }

    public int sxhash() {
        return this.hashCode() & Integer.MAX_VALUE;
    }

    public int psxhash() {
        return this.sxhash();
    }

    public int psxhash(int depth) {
        return this.psxhash();
    }

    public LispObject STRING() {
        return Lisp.error(new TypeError(this.princToString() + " cannot be coerced to a string."));
    }

    public char[] chars() {
        Lisp.type_error(this, Symbol.STRING);
        return null;
    }

    public char[] getStringChars() {
        Lisp.type_error(this, Symbol.STRING);
        return null;
    }

    public String getStringValue() {
        Lisp.type_error(this, Symbol.STRING);
        return null;
    }

    public LispObject getSlotValue_0() {
        return Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
    }

    public LispObject getSlotValue_1() {
        return Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
    }

    public LispObject getSlotValue_2() {
        return Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
    }

    public LispObject getSlotValue_3() {
        return Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
    }

    public LispObject getSlotValue(int index) {
        return Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
    }

    public int getFixnumSlotValue(int index) {
        Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
        return 0;
    }

    public boolean getSlotValueAsBoolean(int index) {
        Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
        return false;
    }

    public void setSlotValue_0(LispObject value) {
        Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
    }

    public void setSlotValue_1(LispObject value) {
        Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
    }

    public void setSlotValue_2(LispObject value) {
        Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
    }

    public void setSlotValue_3(LispObject value) {
        Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
    }

    public void setSlotValue(int index, LispObject value) {
        Lisp.type_error(this, Symbol.STRUCTURE_OBJECT);
    }

    public LispObject SLOT_VALUE(LispObject slotName) {
        return Lisp.type_error(this, Symbol.STANDARD_OBJECT);
    }

    public void setSlotValue(LispObject slotName, LispObject newValue) {
        Lisp.type_error(this, Symbol.STANDARD_OBJECT);
    }

    public int getCallCount() {
        return 0;
    }

    public void setCallCount(int n) {
    }

    public void incrementCallCount() {
    }

    public int getHotCount() {
        return 0;
    }

    public void setHotCount(int n) {
    }

    public void incrementHotCount() {
    }
}

