/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Utilities;

public final class probe_file {
    private static final Primitive PROBE_FILE = new Primitive("probe-file", "pathspec"){

        public LispObject execute(LispObject arg) {
            return Pathname.truename(arg, false);
        }
    };
    private static final Primitive TRUENAME = new Primitive("truename", "filespec"){

        public LispObject execute(LispObject arg) {
            return Pathname.truename(arg, true);
        }
    };
    private static final Primitive PROBE_DIRECTORY = new Primitive("probe-directory", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject arg) {
            File file;
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname.isWild()) {
                Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
            }
            return (file = Utilities.getFile(pathname)).isDirectory() ? Utilities.getDirectoryPathname(file) : Lisp.NIL;
        }
    };
    private static final Primitive FILE_DIRECTORY_P = new Primitive("file-directory-p", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject arg) {
            File file;
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname.isWild()) {
                Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
            }
            return (file = Utilities.getFile(pathname)).isDirectory() ? Lisp.T : Lisp.NIL;
        }
    };
}

